/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.newItemPopup;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class NewItemSimplePopupPanel
extends JBPanel
implements Disposable {
    protected final ExtendableTextField myTextField = this.createTextField();
    private JBPopup myErrorPopup;
    protected RelativePoint myErrorShowPoint;
    protected Consumer<? super InputEvent> myApplyAction;

    public NewItemSimplePopupPanel() {
        super((LayoutManager)new BorderLayout());
        this.add((Component)this.myTextField, "North");
        this.myErrorShowPoint = new RelativePoint((Component)this.myTextField, new Point(0, this.myTextField.getHeight()));
    }

    public void setApplyAction(@NotNull Consumer<? super InputEvent> applyAction) {
        if (applyAction == null) {
            NewItemSimplePopupPanel.$$$reportNull$$$0(0);
        }
        this.myApplyAction = applyAction;
    }

    @NotNull
    public Consumer<? super InputEvent> getApplyAction() {
        Consumer<? super InputEvent> consumer2 = this.myApplyAction;
        if (consumer2 == null) {
            NewItemSimplePopupPanel.$$$reportNull$$$0(1);
        }
        return consumer2;
    }

    public void setError(@NlsContexts.DialogMessage String error) {
        this.myTextField.putClientProperty((Object)"JComponent.outline", (Object)(error != null ? "error" : null));
        if (this.myErrorPopup != null && !this.myErrorPopup.isDisposed()) {
            Disposer.dispose((Disposable)this.myErrorPopup);
        }
        if (error == null) {
            return;
        }
        ComponentPopupBuilder popupBuilder = ComponentValidator.createPopupBuilder((ValidationInfo)new ValidationInfo(error, (JComponent)this.myTextField), errorHint -> {
            Insets insets = this.myTextField.getInsets();
            Dimension hintSize = errorHint.getPreferredSize();
            Point point = new Point(0, insets.top - JBUIScale.scale((int)6) - hintSize.height);
            this.myErrorShowPoint = new RelativePoint((Component)this.myTextField, point);
        }).setCancelOnWindowDeactivation(false).setCancelOnClickOutside(true).addUserData((Object)"SIMPLE_WINDOW");
        this.myErrorPopup = popupBuilder.createPopup();
        this.myErrorPopup.show(this.myErrorShowPoint);
    }

    public void dispose() {
        if (this.myErrorPopup != null && !this.myErrorPopup.isDisposed()) {
            Disposer.dispose((Disposable)this.myErrorPopup);
        }
    }

    public JTextField getTextField() {
        return this.myTextField;
    }

    @NotNull
    protected ExtendableTextField createTextField() {
        ExtendableTextField res2 = new ExtendableTextField();
        Dimension minSize = res2.getMinimumSize();
        Dimension prefSize = res2.getPreferredSize();
        minSize.height = JBUIScale.scale((int)28);
        prefSize.height = JBUIScale.scale((int)28);
        res2.setMinimumSize(minSize);
        res2.setPreferredSize(prefSize);
        res2.setColumns(30);
        Border border = JBUI.Borders.customLine((Color)JBUI.CurrentTheme.NewClassDialog.bordersColor(), (int)1, (int)0, (int)0, (int)0);
        ErrorBorder errorBorder = new ErrorBorder(res2.getBorder());
        res2.setBorder(JBUI.Borders.merge((Border)border, (Border)errorBorder, (boolean)false));
        res2.setBackground(JBUI.CurrentTheme.NewClassDialog.searchFieldBackground());
        res2.putClientProperty((Object)"StatusVisibleFunction", field -> field.getText().isEmpty());
        res2.getEmptyText().setText(IdeBundle.message((String)"action.create.new.class.name.field", (Object[])new Object[0]));
        res2.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && NewItemSimplePopupPanel.this.myApplyAction != null) {
                    NewItemSimplePopupPanel.this.myApplyAction.consume((Object)e);
                }
            }
        });
        res2.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                NewItemSimplePopupPanel.this.setError(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/ui/newItemPopup/NewItemSimplePopupPanel$2", "textChanged"));
            }
        });
        ExtendableTextField extendableTextField = res2;
        if (extendableTextField == null) {
            NewItemSimplePopupPanel.$$$reportNull$$$0(2);
        }
        return extendableTextField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/newItemPopup/NewItemSimplePopupPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/newItemPopup/NewItemSimplePopupPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplyAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setApplyAction";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ErrorBorder
    implements Border {
        private final Border errorDelegateBorder;

        private ErrorBorder(Border delegate2) {
            this.errorDelegateBorder = delegate2;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (ErrorBorder.checkError(c)) {
                this.errorDelegateBorder.paintBorder(c, g, x, y, width, height);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return ErrorBorder.checkError(c) ? this.errorDelegateBorder.getBorderInsets(c) : JBUI.emptyInsets();
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        private static boolean checkError(Component c) {
            Object outlineObj = ((JComponent)c).getClientProperty("JComponent.outline");
            if (outlineObj == null) {
                return false;
            }
            DarculaUIUtil.Outline outline = outlineObj instanceof DarculaUIUtil.Outline ? (DarculaUIUtil.Outline)((Object)outlineObj) : DarculaUIUtil.Outline.valueOf(outlineObj.toString());
            return outline == DarculaUIUtil.Outline.error || outline == DarculaUIUtil.Outline.warning;
        }
    }
}

