/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.BundleBase;
import com.intellij.application.options.SkipSelfSearchComponent;
import com.intellij.ide.ui.search.ComponentHighlightingListener;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.PorterStemmerUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl;
import com.intellij.ide.ui.search.TraverseUIHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.CollectConsumer;
import com.intellij.util.ReflectionUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.View;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SearchUtil {
    private static final String DEBUGGER_CONFIGURABLE_CLASS = "com.intellij.xdebugger.impl.settings.DebuggerConfigurable";
    private static final Pattern HTML_PATTERN = Pattern.compile("<[^<>]*>");
    private static final Pattern QUOTED = Pattern.compile("\"([^\"]+)\"");
    public static final String HIGHLIGHT_WITH_BORDER = "searchUtil.highlightWithBorder";
    private static final String STYLE_END = "</style>";
    private static final Logger LOGGER = Logger.getInstance(SearchUtil.class);

    private SearchUtil() {
    }

    static void processConfigurables(@NotNull List<? extends Configurable> configurables, @NotNull @NotNull Map<SearchableConfigurable, @NotNull Set<OptionDescription>> options2, boolean i18n) {
        if (configurables == null) {
            SearchUtil.$$$reportNull$$$0(0);
        }
        if (options2 == null) {
            SearchUtil.$$$reportNull$$$0(1);
        }
        for (Configurable configurable2 : configurables) {
            if (!(configurable2 instanceof SearchableConfigurable) || configurable2 instanceof SearchableConfigurable.Parent && !((SearchableConfigurable.Parent)configurable2).isVisible()) continue;
            SearchableConfigurable searchableConfigurable = (SearchableConfigurable)configurable2;
            TreeSet<OptionDescription> configurableOptions = new TreeSet<OptionDescription>();
            options2.put(searchableConfigurable, configurableOptions);
            for (TraverseUIHelper extension2 : TraverseUIHelper.helperExtensionPoint.getExtensionList()) {
                extension2.beforeConfigurable(searchableConfigurable, configurableOptions);
            }
            if (configurable2 instanceof MasterDetails) {
                MasterDetails md = (MasterDetails)configurable2;
                md.initUi();
                SearchUtil.processComponent(searchableConfigurable, configurableOptions, md.getMaster(), i18n);
                SearchUtil.processComponent(searchableConfigurable, configurableOptions, md.getDetails().getComponent(), i18n);
            } else {
                SearchUtil.processComponent(searchableConfigurable, configurableOptions, configurable2.createComponent(), i18n);
                Configurable unwrapped = SearchUtil.unwrapConfigurable(configurable2);
                if (unwrapped instanceof CompositeConfigurable) {
                    unwrapped.disposeUIResources();
                    List children2 = ((CompositeConfigurable)unwrapped).getConfigurables();
                    for (UnnamedConfigurable child2 : children2) {
                        JComponent component2;
                        TreeSet<OptionDescription> childConfigurableOptions = new TreeSet<OptionDescription>();
                        options2.put(new SearchableConfigurableAdapter(searchableConfigurable, child2), childConfigurableOptions);
                        if (child2 instanceof SearchableConfigurable) {
                            SearchUtil.processUILabel(((SearchableConfigurable)child2).getDisplayName(), childConfigurableOptions, null, i18n);
                        }
                        if ((component2 = child2.createComponent()) != null) {
                            SearchUtil.processComponent(component2, childConfigurableOptions, null, i18n);
                        }
                        configurableOptions.removeAll(childConfigurableOptions);
                    }
                }
            }
            for (TraverseUIHelper extension2 : TraverseUIHelper.helperExtensionPoint.getExtensionList()) {
                extension2.afterConfigurable(searchableConfigurable, configurableOptions);
            }
        }
    }

    @NotNull
    private static Configurable unwrapConfigurable(@NotNull Configurable configurable2) {
        Class clazz;
        Configurable rootConfigurable;
        UnnamedConfigurable wrapped;
        if (configurable2 == null) {
            SearchUtil.$$$reportNull$$$0(2);
        }
        if (configurable2 instanceof ConfigurableWrapper && (wrapped = ((ConfigurableWrapper)configurable2).getConfigurable()) instanceof SearchableConfigurable) {
            configurable2 = (Configurable)wrapped;
        }
        if (DEBUGGER_CONFIGURABLE_CLASS.equals(configurable2.getClass().getName()) && (rootConfigurable = (Configurable)ReflectionUtil.getField((Class)(clazz = ReflectionUtil.forName((String)DEBUGGER_CONFIGURABLE_CLASS)), (Object)configurable2, Configurable.class, (String)"myRootConfigurable")) != null) {
            Configurable configurable3 = rootConfigurable;
            if (configurable3 == null) {
                SearchUtil.$$$reportNull$$$0(3);
            }
            return configurable3;
        }
        Configurable configurable4 = configurable2;
        if (configurable4 == null) {
            SearchUtil.$$$reportNull$$$0(4);
        }
        return configurable4;
    }

    private static void processComponent(SearchableConfigurable configurable2, Set<OptionDescription> configurableOptions, JComponent component2, boolean i18n) {
        if (component2 != null) {
            for (TraverseUIHelper extension2 : TraverseUIHelper.helperExtensionPoint.getExtensionList()) {
                extension2.beforeComponent(configurable2, component2, configurableOptions);
            }
            SearchUtil.processUILabel(configurable2.getDisplayName(), configurableOptions, null, i18n);
            SearchUtil.processComponent(component2, configurableOptions, null, i18n);
            for (TraverseUIHelper extension2 : TraverseUIHelper.helperExtensionPoint.getExtensionList()) {
                extension2.afterComponent(configurable2, component2, configurableOptions);
            }
        }
    }

    private static void processComponent(JComponent component2, Set<OptionDescription> configurableOptions, String path2, boolean i18n) {
        block7: {
            block10: {
                Object tabbedPane;
                block9: {
                    block8: {
                        block6: {
                            String label2;
                            TitledBorder titledBorder;
                            String title2;
                            if (component2 instanceof SkipSelfSearchComponent) {
                                return;
                            }
                            Border border = component2.getBorder();
                            if (border instanceof TitledBorder && (title2 = (titledBorder = (TitledBorder)border).getTitle()) != null) {
                                SearchUtil.processUILabel(title2, configurableOptions, path2, i18n);
                            }
                            if ((label2 = SearchUtil.getLabelFromComponent(component2)) == null) break block6;
                            SearchUtil.processUILabel(label2, configurableOptions, path2, i18n);
                            break block7;
                        }
                        if (!(component2 instanceof JComboBox)) break block8;
                        List<String> labels = SearchUtil.getItemsFromComboBox((JComboBox)component2);
                        for (String each : labels) {
                            SearchUtil.processUILabel(each, configurableOptions, path2, i18n);
                        }
                        break block7;
                    }
                    if (!(component2 instanceof JTabbedPane)) break block9;
                    tabbedPane = (JTabbedPane)component2;
                    int tabCount = ((JTabbedPane)tabbedPane).getTabCount();
                    for (int i2 = 0; i2 < tabCount; ++i2) {
                        String title3 = path2 != null ? path2 + "." + ((JTabbedPane)tabbedPane).getTitleAt(i2) : ((JTabbedPane)tabbedPane).getTitleAt(i2);
                        SearchUtil.processUILabel(title3, configurableOptions, title3, i18n);
                        Component tabComponent = ((JTabbedPane)tabbedPane).getComponentAt(i2);
                        if (!(tabComponent instanceof JComponent)) continue;
                        SearchUtil.processComponent((JComponent)tabComponent, configurableOptions, title3, i18n);
                    }
                    break block7;
                }
                if (!(component2 instanceof TabbedPaneWrapper.TabbedPaneHolder)) break block10;
                tabbedPane = ((TabbedPaneWrapper.TabbedPaneHolder)component2).getTabbedPaneWrapper();
                int tabCount = ((TabbedPaneWrapper)tabbedPane).getTabCount();
                for (int i3 = 0; i3 < tabCount; ++i3) {
                    String tabTitle = ((TabbedPaneWrapper)tabbedPane).getTitleAt(i3);
                    String title4 = path2 != null ? path2 + "." + tabTitle : tabTitle;
                    SearchUtil.processUILabel(title4, configurableOptions, title4, i18n);
                    JComponent tabComponent = ((TabbedPaneWrapper)tabbedPane).getComponentAt(i3);
                    if (tabComponent == null) continue;
                    SearchUtil.processComponent(tabComponent, configurableOptions, title4, i18n);
                }
                break block7;
            }
            Component[] components = component2.getComponents();
            if (components == null) break block7;
            for (Component child2 : components) {
                if (!(child2 instanceof JComponent)) continue;
                SearchUtil.processComponent((JComponent)child2, configurableOptions, path2, i18n);
            }
        }
    }

    @Nullable
    private static String getLabelFromTextView(@NotNull JComponent component2) {
        Object view;
        if (component2 == null) {
            SearchUtil.$$$reportNull$$$0(5);
        }
        if (!((view = component2.getClientProperty("html")) instanceof View)) {
            return null;
        }
        Document document = ((View)view).getDocument();
        if (document == null) {
            return null;
        }
        int length = document.getLength();
        try {
            return document.getText(0, length);
        }
        catch (BadLocationException e) {
            LOGGER.error((Throwable)e);
            return null;
        }
    }

    private static String getLabelFromComponent(@NotNull JLabel label2) {
        String text2;
        if (label2 == null) {
            SearchUtil.$$$reportNull$$$0(6);
        }
        if ((text2 = SearchUtil.getLabelFromTextView(label2)) == null) {
            text2 = label2.getText();
        }
        return text2;
    }

    private static String getLabelFromComponent(@NotNull AbstractButton button4) {
        String text2;
        if (button4 == null) {
            SearchUtil.$$$reportNull$$$0(7);
        }
        if ((text2 = SearchUtil.getLabelFromTextView(button4)) == null) {
            text2 = button4.getText();
        }
        return text2;
    }

    @Nullable
    private static String getLabelFromComponent(@Nullable Component component2) {
        String label2 = null;
        if (component2 instanceof JLabel) {
            label2 = SearchUtil.getLabelFromComponent((JLabel)component2);
        } else if (component2 instanceof JCheckBox) {
            label2 = SearchUtil.getLabelFromComponent((JCheckBox)component2);
        } else if (component2 instanceof JRadioButton) {
            label2 = SearchUtil.getLabelFromComponent((JRadioButton)component2);
        } else if (component2 instanceof JButton) {
            label2 = SearchUtil.getLabelFromComponent((JButton)component2);
        }
        return Strings.nullize((String)label2, (boolean)true);
    }

    @NotNull
    private static List<String> getItemsFromComboBox(@NotNull JComboBox<?> comboBox2) {
        DefaultListCellRenderer renderer2;
        if (comboBox2 == null) {
            SearchUtil.$$$reportNull$$$0(8);
        }
        if ((renderer2 = comboBox2.getRenderer()) == null) {
            renderer2 = new DefaultListCellRenderer();
        }
        JList<Object> jList = new BasicComboPopup(comboBox2).getList();
        ArrayList<String> result2 = new ArrayList<String>();
        int count = comboBox2.getItemCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Object value2 = comboBox2.getItemAt(i2);
            Component labelComponent = renderer2.getListCellRendererComponent(jList, value2, i2, false, false);
            String label2 = SearchUtil.getLabelFromComponent(labelComponent);
            if (label2 == null) continue;
            result2.add(label2);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            SearchUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static void processUILabel(String title2, Set<OptionDescription> configurableOptions, String path2, boolean i18n) {
        int headEnd;
        int headStart = ((String)title2).indexOf("<head>");
        int n = headEnd = headStart >= 0 ? ((String)title2).indexOf("</head>") : -1;
        if (headEnd > headStart) {
            title2 = ((String)title2).substring(0, headStart) + ((String)title2).substring(headEnd + "</head>".length());
        }
        title2 = HTML_PATTERN.matcher((CharSequence)title2).replaceAll(" ");
        HashSet words = new HashSet();
        SearchableOptionsRegistrarImpl.collectProcessedWordsWithoutStemming((String)title2, words, Collections.emptySet());
        title2 = ((String)title2).replace(BundleBase.MNEMONIC_STRING, "");
        title2 = SearchUtil.getNonWordPattern(i18n).matcher((CharSequence)title2).replaceAll(" ");
        for (String option2 : words) {
            configurableOptions.add(new OptionDescription(option2, (String)title2, path2));
        }
    }

    @NotNull
    private static Pattern getNonWordPattern(boolean i18n) {
        Pattern pattern = Pattern.compile("[" + (i18n ? "^\\pL" : "\\W") + "&&[^\\p{Punct}\\p{Blank}]]");
        if (pattern == null) {
            SearchUtil.$$$reportNull$$$0(10);
        }
        return pattern;
    }

    public static void lightOptions(SearchableConfigurable configurable2, JComponent component2, String option2) {
        if (!SearchUtil.traverseComponentsTree(configurable2, component2, option2, true)) {
            SearchUtil.traverseComponentsTree(configurable2, component2, option2, false);
        }
    }

    private static int getSelection(String tabIdx, int tabCount, Function<? super Integer, String> titleGetter) {
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        for (int i2 = 0; i2 < tabCount; ++i2) {
            Set pathWords = searchableOptionsRegistrar.getProcessedWords(tabIdx);
            String title2 = titleGetter.apply((Integer)i2);
            if (!pathWords.isEmpty()) {
                Set titleWords = searchableOptionsRegistrar.getProcessedWords(title2);
                pathWords.removeAll(titleWords);
                if (!pathWords.isEmpty()) continue;
                return i2;
            }
            if (!tabIdx.equalsIgnoreCase(title2)) continue;
            return i2;
        }
        return -1;
    }

    private static boolean traverseComponentsTree(SearchableConfigurable configurable2, JComponent rootComponent, String option2, boolean force) {
        String title2;
        Border border;
        int index2;
        Set paths2;
        rootComponent.putClientProperty(HIGHLIGHT_WITH_BORDER, null);
        if (option2 == null || option2.trim().length() == 0) {
            return false;
        }
        String label2 = SearchUtil.getLabelFromComponent(rootComponent);
        if (label2 != null) {
            if (SearchUtil.isComponentHighlighted(label2, option2, force, configurable2)) {
                SearchUtil.highlightComponent(rootComponent, option2);
                return true;
            }
        } else if (rootComponent instanceof JComboBox) {
            List<String> labels = SearchUtil.getItemsFromComboBox((JComboBox)rootComponent);
            if (labels.stream().anyMatch(t -> SearchUtil.isComponentHighlighted(t, option2, force, configurable2))) {
                SearchUtil.highlightComponent(rootComponent, option2);
                return true;
            }
        } else if (rootComponent instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)rootComponent;
            paths2 = SearchableOptionsRegistrar.getInstance().getInnerPaths(configurable2, option2);
            for (String path2 : paths2) {
                if (path2 == null || (index2 = SearchUtil.getSelection(path2, tabbedPane.getTabCount(), i2 -> tabbedPane.getTitleAt((int)i2))) <= -1 || index2 >= tabbedPane.getTabCount() || !(tabbedPane.getTabComponentAt(index2) instanceof JComponent)) continue;
                SearchUtil.highlightComponent((JComponent)tabbedPane.getTabComponentAt(index2), option2);
            }
        } else if (rootComponent instanceof TabbedPaneWrapper.TabbedPaneHolder) {
            TabbedPaneWrapper tabbedPaneWrapper = ((TabbedPaneWrapper.TabbedPaneHolder)rootComponent).getTabbedPaneWrapper();
            paths2 = SearchableOptionsRegistrar.getInstance().getInnerPaths(configurable2, option2);
            for (String path2 : paths2) {
                if (path2 == null || (index2 = SearchUtil.getSelection(path2, tabbedPaneWrapper.getTabCount(), i2 -> tabbedPaneWrapper.getTitleAt((int)i2))) <= -1 || index2 >= tabbedPaneWrapper.getTabCount()) continue;
                SearchUtil.highlightComponent((JComponent)tabbedPaneWrapper.getTabComponentAt(index2), option2);
            }
        }
        if ((border = rootComponent.getBorder()) instanceof TitledBorder && SearchUtil.isComponentHighlighted(title2 = ((TitledBorder)border).getTitle(), option2, force, configurable2)) {
            SearchUtil.highlightComponent(rootComponent, option2);
            rootComponent.putClientProperty(HIGHLIGHT_WITH_BORDER, Boolean.TRUE);
            return true;
        }
        boolean highlight = false;
        for (Component component2 : rootComponent.getComponents()) {
            if (!(component2 instanceof JComponent) || !SearchUtil.traverseComponentsTree(configurable2, (JComponent)component2, option2, force)) continue;
            highlight = true;
        }
        return highlight;
    }

    private static void highlightComponent(@NotNull JComponent rootComponent, @NotNull String searchString) {
        if (rootComponent == null) {
            SearchUtil.$$$reportNull$$$0(11);
        }
        if (searchString == null) {
            SearchUtil.$$$reportNull$$$0(12);
        }
        ((ComponentHighlightingListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ComponentHighlightingListener.TOPIC)).highlight(rootComponent, searchString);
    }

    public static boolean isComponentHighlighted(String text2, String option2, boolean force, SearchableConfigurable configurable2) {
        Set options2;
        if (text2 == null || option2 == null || option2.length() == 0) {
            return false;
        }
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        Set words = searchableOptionsRegistrar.getProcessedWords(option2);
        Set set2 = options2 = configurable2 != null ? searchableOptionsRegistrar.replaceSynonyms(words, configurable2) : words;
        if (options2.isEmpty()) {
            return Strings.toLowerCase((String)text2).contains(Strings.toLowerCase((String)option2));
        }
        Set tokens = searchableOptionsRegistrar.getProcessedWords(text2);
        if (!force) {
            options2.retainAll(tokens);
            boolean highlight = !options2.isEmpty();
            return highlight || Strings.toLowerCase((String)text2).contains(Strings.toLowerCase((String)option2));
        }
        options2.removeAll(tokens);
        return options2.isEmpty();
    }

    public static String markup(@NotNull String textToMarkup, @Nullable String filter) {
        if (textToMarkup == null) {
            SearchUtil.$$$reportNull$$$0(13);
        }
        return SearchUtil.markup(textToMarkup, filter, Color.white, ColorUtil.fromHex((String)"1d5da7"));
    }

    public static String markup(@NotNull String textToMarkup, @Nullable String filter, Color textColor, Color backgroundColor) {
        String foot;
        String head;
        if (textToMarkup == null) {
            SearchUtil.$$$reportNull$$$0(14);
        }
        if (filter == null || filter.length() == 0) {
            return textToMarkup;
        }
        int bodyStart = textToMarkup.indexOf("<body>");
        int bodyEnd = textToMarkup.indexOf("</body>");
        if (bodyStart >= 0) {
            head = textToMarkup.substring(0, bodyStart += "<body>".length());
            foot = bodyEnd >= 0 ? textToMarkup.substring(bodyEnd) : "";
            textToMarkup = textToMarkup.substring(bodyStart, bodyEnd);
        } else {
            foot = "";
            head = "";
        }
        Pattern insideHtmlTagPattern = Pattern.compile("[<[^<>]*>]*<[^<>]*");
        SearchableOptionsRegistrar registrar = SearchableOptionsRegistrar.getInstance();
        HashSet quoted = new HashSet();
        filter = SearchUtil.processFilter(SearchUtil.quoteStrictOccurrences(textToMarkup, filter), quoted);
        Set options2 = registrar.getProcessedWords(filter);
        Set words = registrar.getProcessedWords(textToMarkup);
        for (String option2 : options2) {
            if (!words.contains(option2)) continue;
            textToMarkup = SearchUtil.markup(textToMarkup, insideHtmlTagPattern, option2, textColor, backgroundColor);
        }
        for (String stripped : quoted) {
            if (registrar.isStopWord(stripped)) continue;
            textToMarkup = SearchUtil.markup(textToMarkup, insideHtmlTagPattern, stripped, textColor, backgroundColor);
        }
        return head + textToMarkup + foot;
    }

    private static String quoteStrictOccurrences(String textToMarkup, String filter) {
        StringBuilder cur = new StringBuilder();
        String s = Strings.toLowerCase((String)textToMarkup);
        for (String part : filter.split(" ")) {
            if (s.contains(part)) {
                cur.append("\"").append(part).append("\" ");
                continue;
            }
            cur.append(part).append(" ");
        }
        return cur.toString();
    }

    private static String markup(String textToMarkup, Pattern insideHtmlTagPattern, String option2, Color textColor, Color backgroundColor) {
        int styleIdx = textToMarkup.indexOf("<style");
        int styleEndIdx = textToMarkup.indexOf(STYLE_END);
        if (styleIdx < 0 || styleEndIdx < 0) {
            return SearchUtil.markupInText(textToMarkup, insideHtmlTagPattern, option2, textColor, backgroundColor);
        }
        return SearchUtil.markup(textToMarkup.substring(0, styleIdx), insideHtmlTagPattern, option2, textColor, backgroundColor) + SearchUtil.markup(textToMarkup.substring(styleEndIdx + STYLE_END.length()), insideHtmlTagPattern, option2, textColor, backgroundColor);
    }

    private static String markupInText(String textToMarkup, Pattern insideHtmlTagPattern, String option2, Color textColor, Color backgroundColor) {
        int idx;
        StringBuilder result2 = new StringBuilder();
        int beg = 0;
        while ((idx = Strings.indexOfIgnoreCase((String)textToMarkup, (String)option2, (int)beg)) != -1) {
            String prefix = textToMarkup.substring(beg, idx);
            String toMark = textToMarkup.substring(idx, idx + option2.length());
            if (insideHtmlTagPattern.matcher(prefix).matches()) {
                int lastIdx = textToMarkup.indexOf(">", idx);
                result2.append(prefix).append(textToMarkup, idx, lastIdx + 1);
                beg = lastIdx + 1;
                continue;
            }
            result2.append(prefix).append("<font color='#").append(ColorUtil.toHex((Color)textColor)).append("' bgColor='#").append(ColorUtil.toHex((Color)backgroundColor)).append("'>").append(toMark).append("</font>");
            beg = idx + option2.length();
        }
        result2.append(textToMarkup.substring(beg));
        return result2.toString();
    }

    public static void appendFragments(String filter, @NlsSafe String text2, @SimpleTextAttributes.StyleAttributeConstant int style, Color foreground, Color background, SimpleColoredComponent textRenderer) {
        if (text2 == null) {
            return;
        }
        if (filter == null || filter.length() == 0) {
            textRenderer.setDynamicSearchMatchHighlighting(false);
            textRenderer.append(text2, new SimpleTextAttributes(background, foreground, (Color)JBColor.RED, style));
        } else {
            textRenderer.setDynamicSearchMatchHighlighting(true);
            HashSet quoted = new HashSet();
            filter = SearchUtil.processFilter(SearchUtil.quoteStrictOccurrences(text2, filter), quoted);
            Int2ObjectRBTreeMap indexToString = new Int2ObjectRBTreeMap();
            for (String stripped : quoted) {
                int idx;
                int beg = 0;
                while ((idx = Strings.indexOfIgnoreCase((String)text2, (String)stripped, (int)beg)) != -1) {
                    indexToString.put(idx, (Object)text2.substring(idx, idx + stripped.length()));
                    beg = idx + stripped.length();
                }
            }
            ArrayList<String> selectedWords = new ArrayList<String>();
            int pos = 0;
            for (Int2ObjectMap.Entry entry2 : Int2ObjectMaps.fastIterable((Int2ObjectMap)indexToString)) {
                String stripped = (String)entry2.getValue();
                int start2 = entry2.getIntKey();
                if (pos > start2) {
                    String highlighted = (String)selectedWords.get(selectedWords.size() - 1);
                    if (highlighted.length() >= stripped.length()) continue;
                    selectedWords.remove(highlighted);
                }
                SearchUtil.appendSelectedWords(text2, selectedWords, pos, start2, filter);
                selectedWords.add(stripped);
                pos = start2 + stripped.length();
            }
            SearchUtil.appendSelectedWords(text2, selectedWords, pos, text2.length(), filter);
            int idx = 0;
            for (String word : selectedWords) {
                @NlsSafe String before = (text2 = text2.substring(idx)).substring(0, text2.indexOf(word));
                if (before.length() > 0) {
                    textRenderer.append(before, new SimpleTextAttributes(background, foreground, null, style));
                }
                idx = text2.indexOf(word) + word.length();
                textRenderer.append(text2.substring(idx - word.length(), idx), new SimpleTextAttributes(background, foreground, null, style | 0x40));
            }
            @NlsSafe String after2 = text2.substring(idx);
            if (after2.length() > 0) {
                textRenderer.append(after2, new SimpleTextAttributes(background, foreground, null, style));
            }
        }
    }

    private static void appendSelectedWords(String text2, List<? super String> selectedWords, int pos, int end, String filter) {
        if (pos < end) {
            String[] words;
            Set filters = SearchableOptionsRegistrar.getInstance().getProcessedWords(filter);
            for (String word : words = text2.substring(pos, end).split("[^\\pL&&[^-]]+")) {
                if (!filters.contains(PorterStemmerUtil.stem(Strings.toLowerCase((String)word)))) continue;
                selectedWords.add(word);
            }
        }
    }

    @NotNull
    public static List<Set<String>> findKeys(String filter, Set<? super String> quoted) {
        filter = SearchUtil.processFilter(Strings.toLowerCase((String)filter), quoted);
        ArrayList<Set<String>> keySetList = new ArrayList<Set<String>>();
        SearchableOptionsRegistrarImpl optionsRegistrar = (SearchableOptionsRegistrarImpl)SearchableOptionsRegistrar.getInstance();
        for (String word : optionsRegistrar.getProcessedWords(filter)) {
            Set<OptionDescription> descriptions = optionsRegistrar.getAcceptableDescriptions(word);
            HashSet<String> keySet = new HashSet<String>();
            if (descriptions != null) {
                for (OptionDescription description : descriptions) {
                    keySet.add(description.getPath());
                }
            }
            keySetList.add(keySet);
        }
        if (keySetList.isEmpty() && !Strings.isEmptyOrSpaces((CharSequence)filter)) {
            keySetList.add(Collections.singleton(filter));
        }
        ArrayList<Set<String>> arrayList = keySetList;
        if (arrayList == null) {
            SearchUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static String processFilter(String filter, Set<? super String> quoted) {
        StringBuilder withoutQuoted = new StringBuilder();
        int beg = 0;
        Matcher matcher = QUOTED.matcher(filter);
        while (matcher.find()) {
            int start2 = matcher.start(1);
            withoutQuoted.append(" ").append(filter, beg, start2);
            beg = matcher.end(1);
            String trimmed = filter.substring(start2, beg).trim();
            if (trimmed.length() <= 0) continue;
            quoted.add(trimmed);
        }
        return withoutQuoted + " " + filter.substring(beg);
    }

    @NotNull
    public static List<Configurable> expand(ConfigurableGroup @NotNull [] groups2) {
        if (groups2 == null) {
            SearchUtil.$$$reportNull$$$0(16);
        }
        ArrayList<Configurable> result2 = new ArrayList<Configurable>();
        CollectConsumer consumer2 = new CollectConsumer(result2);
        for (ConfigurableGroup group2 : groups2) {
            SearchUtil.processExpandedGroups(group2, (Consumer<? super Configurable>)consumer2);
        }
        ArrayList<Configurable> arrayList = result2;
        if (arrayList == null) {
            SearchUtil.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    public static List<Configurable> expandGroup(@NotNull ConfigurableGroup group2) {
        if (group2 == null) {
            SearchUtil.$$$reportNull$$$0(18);
        }
        ArrayList<Configurable> result2 = new ArrayList<Configurable>();
        SearchUtil.processExpandedGroups(group2, (Consumer<? super Configurable>)new CollectConsumer(result2));
        ArrayList<Configurable> arrayList = result2;
        if (arrayList == null) {
            SearchUtil.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    public static void processExpandedGroups(@NotNull ConfigurableGroup group2, @NotNull Consumer<? super Configurable> consumer2) {
        if (group2 == null) {
            SearchUtil.$$$reportNull$$$0(20);
        }
        if (consumer2 == null) {
            SearchUtil.$$$reportNull$$$0(21);
        }
        Configurable[] configurables = group2.getConfigurables();
        ArrayList result2 = new ArrayList();
        Collections.addAll(result2, configurables);
        for (Configurable each : configurables) {
            SearchUtil.addChildren(each, result2);
        }
        for (Configurable configurable2 : result2) {
            if (!SearchUtil.isAcceptable(configurable2)) continue;
            consumer2.accept((Configurable)configurable2);
        }
    }

    public static boolean isAcceptable(@NotNull Configurable configurable2) {
        if (configurable2 == null) {
            SearchUtil.$$$reportNull$$$0(22);
        }
        return !(configurable2 instanceof SearchableConfigurable.Parent) || ((SearchableConfigurable.Parent)configurable2).isVisible();
    }

    private static void addChildren(@NotNull Configurable configurable2, @NotNull List<? super Configurable> list2) {
        if (configurable2 == null) {
            SearchUtil.$$$reportNull$$$0(23);
        }
        if (list2 == null) {
            SearchUtil.$$$reportNull$$$0(24);
        }
        if (configurable2 instanceof Configurable.Composite) {
            for (Configurable eachKid : ((Configurable.Composite)configurable2).getConfigurables()) {
                list2.add((Configurable)eachKid);
                SearchUtil.addChildren(eachKid, list2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurables";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/search/SearchUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootComponent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchString";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToMarkup";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/search/SearchUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapConfigurable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsFromComboBox";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonWordPattern";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findKeys";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "expand";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "expandGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processConfigurables";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unwrapConfigurable";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 19: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLabelFromTextView";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLabelFromComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getItemsFromComboBox";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "highlightComponent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "markup";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "expandGroup";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processExpandedGroups";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SearchableConfigurableAdapter
    implements SearchableConfigurable {
        private final SearchableConfigurable myOriginal;
        private final UnnamedConfigurable myDelegate;

        private SearchableConfigurableAdapter(@NotNull SearchableConfigurable original, @NotNull UnnamedConfigurable delegate2) {
            if (original == null) {
                SearchableConfigurableAdapter.$$$reportNull$$$0(0);
            }
            if (delegate2 == null) {
                SearchableConfigurableAdapter.$$$reportNull$$$0(1);
            }
            this.myOriginal = original;
            this.myDelegate = delegate2;
        }

        @NotNull
        public String getId() {
            String string = this.myOriginal.getId();
            if (string == null) {
                SearchableConfigurableAdapter.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Title)
        public String getDisplayName() {
            return this.myOriginal.getDisplayName();
        }

        @NotNull
        public Class<?> getOriginalClass() {
            Class clazz = this.myDelegate instanceof SearchableConfigurable ? ((SearchableConfigurable)this.myDelegate).getOriginalClass() : this.myDelegate.getClass();
            if (clazz == null) {
                SearchableConfigurableAdapter.$$$reportNull$$$0(3);
            }
            return clazz;
        }

        @Nullable
        public JComponent createComponent() {
            return null;
        }

        public boolean isModified() {
            return false;
        }

        public void apply() {
        }

        public String toString() {
            return this.getDisplayName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/ui/search/SearchUtil$SearchableConfigurableAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/ui/search/SearchUtil$SearchableConfigurableAdapter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOriginalClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

