/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeaturesRegistryListener;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.ide.TipsOfTheDayUsagesCollector;
import com.intellij.ide.util.RecommendationDescription;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipUIUtil;
import com.intellij.ide.util.TipsUsageManager$WhenMappings;
import com.intellij.ide.util.TipsUtilityExperiment;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ShownTips", storages={@Storage(value="shownTips.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0001\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u001a\u001b\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fJ\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u001c\u0010\u0014\u001a\u00020\u00152\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ide/util/TipsUsageManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/ide/util/TipsUsageManager$State;", "()V", "shownTips", "", "", "", "utilityHolder", "Lcom/intellij/ide/util/TipsUsageManager$TipsUtilityHolder;", "filterShownTips", "", "Lcom/intellij/ide/util/TipAndTrickBean;", "tips", "fireTipShown", "", "tip", "getState", "loadState", "state", "sortTips", "Lcom/intellij/ide/util/RecommendationDescription;", "experimentType", "Lcom/intellij/ide/util/TipsUtilityExperiment;", "wereTipsShownToday", "", "Companion", "State", "TipsUsageListener", "TipsUtilityHolder", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class TipsUsageManager
implements PersistentStateComponent<State> {
    private final Map<String, Long> shownTips;
    private final TipsUtilityHolder utilityHolder;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public State getState() {
        return new State(this.shownTips);
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.shownTips.putAll(state.getShownTips());
    }

    @NotNull
    public final RecommendationDescription sortTips(@NotNull List<TipAndTrickBean> tips, @NotNull TipsUtilityExperiment experimentType) {
        List list2;
        Intrinsics.checkNotNullParameter(tips, (String)"tips");
        Intrinsics.checkNotNullParameter((Object)((Object)experimentType), (String)"experimentType");
        boolean bl = false;
        Set usedTips = new LinkedHashSet();
        boolean bl2 = false;
        Set unusedTips = new LinkedHashSet();
        ProductivityFeaturesRegistry productivityFeaturesRegistry = ProductivityFeaturesRegistry.getInstance();
        if (productivityFeaturesRegistry != null) {
            ProductivityFeaturesRegistry productivityFeaturesRegistry2 = productivityFeaturesRegistry;
            boolean bl3 = false;
            boolean bl4 = false;
            ProductivityFeaturesRegistry featuresRegistry = productivityFeaturesRegistry2;
            boolean bl5 = false;
            ProductivityFeaturesRegistry productivityFeaturesRegistry3 = featuresRegistry;
            Intrinsics.checkNotNullExpressionValue((Object)productivityFeaturesRegistry3, (String)"featuresRegistry");
            for (String featureId : productivityFeaturesRegistry3.getFeatureIds()) {
                TipAndTrickBean tip;
                FeatureDescriptor feature = featuresRegistry.getFeatureDescriptor(featureId);
                if (TipUIUtil.getTip(feature) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)tip, (String)"TipUIUtil.getTip(feature) ?: continue");
                if (!tips.contains(tip)) continue;
                long l = System.currentTimeMillis();
                FeatureDescriptor featureDescriptor = feature;
                Intrinsics.checkNotNullExpressionValue((Object)featureDescriptor, (String)"feature");
                if (l - featureDescriptor.getLastTimeUsed() < 2592000000L) {
                    usedTips.add(tip);
                    unusedTips.remove(tip);
                    continue;
                }
                if (usedTips.contains(tip)) continue;
                unusedTips.add(tip);
            }
        }
        Set otherTips = SetsKt.minus((Set)CollectionsKt.toSet((Iterable)tips), (Iterable)SetsKt.plus((Set)usedTips, (Iterable)unusedTips));
        switch (TipsUsageManager$WhenMappings.$EnumSwitchMapping$0[experimentType.ordinal()]) {
            case 1: {
                List<TipAndTrickBean> sortedByUtility = this.utilityHolder.sampleTips(SetsKt.plus((Set)unusedTips, (Iterable)usedTips));
                list2 = CollectionsKt.plus((Collection)sortedByUtility, (Iterable)CollectionsKt.shuffled((Iterable)otherTips));
                break;
            }
            case 2: {
                List<TipAndTrickBean> sortedByUtility = this.utilityHolder.sampleTips(unusedTips);
                list2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)sortedByUtility, (Iterable)CollectionsKt.shuffled((Iterable)otherTips)), (Iterable)CollectionsKt.shuffled((Iterable)usedTips));
                break;
            }
            case 3: {
                list2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.shuffled((Iterable)unusedTips), (Iterable)CollectionsKt.shuffled((Iterable)otherTips)), (Iterable)CollectionsKt.shuffled((Iterable)usedTips));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List resultTips = list2;
        return new RecommendationDescription(experimentType.toString(), resultTips, this.utilityHolder.getMetadataVersion());
    }

    public final void fireTipShown(@NotNull TipAndTrickBean tip) {
        Intrinsics.checkNotNullParameter((Object)tip, (String)"tip");
        String string = tip.fileName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tip.fileName");
        this.shownTips.put(string, System.currentTimeMillis());
    }

    @NotNull
    public final List<TipAndTrickBean> filterShownTips(@NotNull List<TipAndTrickBean> tips) {
        List resultTips;
        block12: {
            Object v2;
            Object object3;
            boolean bl;
            Object object2;
            Intrinsics.checkNotNullParameter(tips, (String)"tips");
            resultTips = CollectionsKt.toMutableList((Collection)tips);
            for (String tipFile : CollectionsKt.shuffled((Iterable)this.shownTips.keySet())) {
                Object v0;
                block10: {
                    object2 = resultTips;
                    bl = false;
                    Iterable iterable = object2;
                    boolean bl2 = false;
                    for (Object object3 : iterable) {
                        TipAndTrickBean it = (TipAndTrickBean)object3;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.fileName, (Object)tipFile)) continue;
                        v0 = object3;
                        break block10;
                    }
                    v0 = null;
                }
                TipAndTrickBean tipAndTrickBean = v0;
                if (tipAndTrickBean == null) continue;
                object2 = tipAndTrickBean;
                bl = false;
                boolean bl4 = false;
                Object tip = object2;
                boolean bl5 = false;
                resultTips.remove(tip);
                resultTips.add(tip);
            }
            if (!this.wereTipsShownToday()) break block12;
            Object object4 = this.shownTips;
            boolean bl6 = false;
            object2 = object4.entrySet();
            bl = false;
            Iterator iterator2 = object2.iterator();
            if (!iterator2.hasNext()) {
                v2 = null;
            } else {
                Object object5 = iterator2.next();
                if (!iterator2.hasNext()) {
                    v2 = object5;
                } else {
                    Map.Entry it = (Map.Entry)object5;
                    boolean bl7 = false;
                    long l = ((Number)it.getValue()).longValue();
                    do {
                        object3 = iterator2.next();
                        Map.Entry it22 = (Map.Entry)object3;
                        iterator3 = false;
                        long it22 = ((Number)it22.getValue()).longValue();
                        if (l >= it22) continue;
                        object5 = object3;
                        l = it22;
                    } while (iterator2.hasNext());
                    v2 = object5;
                }
            }
            Map.Entry entry2 = v2;
            if (entry2 != null) {
                Object v4;
                boolean bl8;
                Object object6;
                block11: {
                    object4 = entry2;
                    bl6 = false;
                    boolean bl9 = false;
                    Object it = object4;
                    boolean bl10 = false;
                    object6 = resultTips;
                    bl8 = false;
                    object3 = object6;
                    boolean it22 = false;
                    Iterator iterator3 = object3.iterator();
                    while (iterator3.hasNext()) {
                        Object t = iterator3.next();
                        TipAndTrickBean tip = (TipAndTrickBean)t;
                        boolean bl11 = false;
                        if (!Intrinsics.areEqual((Object)tip.fileName, (Object)((String)it.getKey()))) continue;
                        v4 = t;
                        break block11;
                    }
                    v4 = null;
                }
                TipAndTrickBean tipAndTrickBean = v4;
                if (tipAndTrickBean != null) {
                    object6 = tipAndTrickBean;
                    bl8 = false;
                    boolean bl12 = false;
                    Object tip = object6;
                    boolean bl13 = false;
                    resultTips.remove(tip);
                    resultTips.add(0, tip);
                }
            }
        }
        return resultTips;
    }

    public final boolean wereTipsShownToday() {
        Comparable comparable;
        Map<String, Long> map2 = this.shownTips;
        long l = System.currentTimeMillis();
        boolean bl = false;
        Iterable iterable = map2.entrySet();
        boolean bl2 = false;
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            Map.Entry it = (Map.Entry)iterator2.next();
            boolean bl3 = false;
            Comparable comparable2 = Long.valueOf(((Number)it.getValue()).longValue());
            while (iterator2.hasNext()) {
                Map.Entry it2 = (Map.Entry)iterator2.next();
                $i$a$-maxOfOrNull-TipsUsageManager$wereTipsShownToday$1 = false;
                Comparable comparable3 = Long.valueOf(((Number)it2.getValue()).longValue());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Comparable comparable4 = comparable;
        Long l2 = (Long)comparable4;
        return l - (l2 != null ? l2 : 0L) < 86400000L;
    }

    public TipsUsageManager() {
        boolean bl = false;
        this.shownTips = new LinkedHashMap();
        this.utilityHolder = TipsUtilityHolder.Companion.readFromResourcesAndCreate();
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect().subscribe(FeaturesRegistryListener.TOPIC, (Object)new TipsUsageListener());
    }

    @JvmStatic
    @NotNull
    public static final TipsUsageManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001R&\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/util/TipsUsageManager$State;", "", "shownTips", "", "", "", "(Ljava/util/Map;)V", "getShownTips", "()Ljava/util/Map;", "setShownTips", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
    public static final class State {
        @NotNull
        private Map<String, Long> shownTips;

        @NotNull
        public final Map<String, Long> getShownTips() {
            return this.shownTips;
        }

        public final void setShownTips(@NotNull Map<String, Long> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            this.shownTips = map2;
        }

        public State(@NotNull Map<String, Long> shownTips) {
            Intrinsics.checkNotNullParameter(shownTips, (String)"shownTips");
            this.shownTips = shownTips;
        }

        public /* synthetic */ State(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map2 = MapsKt.emptyMap();
            }
            this(map2);
        }

        public State() {
            this(null, 1, null);
        }

        @NotNull
        public final Map<String, Long> component1() {
            return this.shownTips;
        }

        @NotNull
        public final State copy(@NotNull Map<String, Long> shownTips) {
            Intrinsics.checkNotNullParameter(shownTips, (String)"shownTips");
            return new State(shownTips);
        }

        public static /* synthetic */ State copy$default(State state, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = state.shownTips;
            }
            return state.copy(map2);
        }

        @NotNull
        public String toString() {
            return "State(shownTips=" + this.shownTips + ")";
        }

        public int hashCode() {
            Map<String, Long> map2 = this.shownTips;
            return map2 != null ? ((Object)map2).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof State)) break block3;
                    State state = (State)object;
                    if (!Intrinsics.areEqual(this.shownTips, state.shownTips)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\u0004J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eJ,\u0010\u000f\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\n0\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\u00130\fH\u0002J,\u0010\u0014\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\n0\u00112\u0018\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\u00130\fH\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/util/TipsUsageManager$TipsUtilityHolder;", "", "tips2utility", "", "", "", "(Ljava/util/Map;)V", "getMetadataVersion", "getTipUtility", "tip", "Lcom/intellij/ide/util/TipAndTrickBean;", "sampleTips", "", "tips", "", "sampleByUtility", "", "", "knownTips", "Lkotlin/Pair;", "sampleUnknown", "unknownTips", "Companion", "intellij.platform.ide.impl"})
    private static final class TipsUtilityHolder {
        private final Map<String, Double> tips2utility;
        private static final Logger LOG;
        private static final String TIPS_UTILITY_FILE = "tips_utility.csv";
        @NotNull
        public static final Companion Companion;

        @NotNull
        public final String getMetadataVersion() {
            return "0.1";
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<TipAndTrickBean> sampleTips(@NotNull Iterable<TipAndTrickBean> tips) {
            void knownTips;
            void $this$partition$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(tips, (String)"tips");
            Iterable $this$map$iv = tips;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TipAndTrickBean tipAndTrickBean = (TipAndTrickBean)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Pair pair = new Pair((Object)it, (Object)this.getTipUtility((TipAndTrickBean)it));
                collection.add(pair);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                if (((Number)it.getSecond()).doubleValue() >= 0.0) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List list2 = (List)pair.component1();
            List unknownTips = (List)pair.component2();
            boolean bl = false;
            List result2 = new ArrayList();
            this.sampleByUtility(result2, (List<Pair<TipAndTrickBean, Double>>)knownTips);
            this.sampleUnknown(result2, unknownTips);
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        private final void sampleByUtility(List<TipAndTrickBean> $this$sampleByUtility, List<Pair<TipAndTrickBean, Double>> knownTips) {
            void it;
            Iterable $this$sortedByDescending$iv = knownTips;
            boolean $i$f$sortedByDescending = false;
            boolean bl = false;
            Set sortedTips = CollectionsKt.toMutableSet((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Pair it = (Pair)b;
                    boolean bl2 = false;
                    Comparable comparable = (Double)it.getSecond();
                    it = (Pair)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Double d = (Double)it.getSecond();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
                }
            }));
            Iterable $this$sumByDouble$iv22 = sortedTips;
            boolean $i$f$sumByDouble = false;
            double sum$iv = 0.0;
            for (Object element$iv : $this$sumByDouble$iv22) {
                Pair pair = (Pair)element$iv;
                double d = sum$iv;
                boolean bl2 = false;
                double d2 = ((Number)it.getSecond()).doubleValue();
                sum$iv = d + d2;
            }
            double totalUtility = sum$iv;
            int $this$sumByDouble$iv22 = 0;
            int n = sortedTips.size();
            while ($this$sumByDouble$iv22 < n) {
                void i2;
                double cumulativeUtility = 0.0;
                if (totalUtility <= 0.0) {
                    Collection<TipAndTrickBean> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = sortedTips;
                    List<TipAndTrickBean> list2 = $this$sampleByUtility;
                    boolean $i$f$map = false;
                    it = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        Pair pair = (Pair)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl3 = false;
                        TipAndTrickBean tipAndTrickBean = (TipAndTrickBean)it2.getFirst();
                        collection.add(tipAndTrickBean);
                    }
                    collection = (List)destination$iv$iv;
                    list2.addAll(CollectionsKt.shuffled((Iterable)collection));
                    break;
                }
                double prob = Random.Default.nextDouble(totalUtility);
                for (Pair tip2utility : sortedTips) {
                    double tipUtility = ((Number)tip2utility.getSecond()).doubleValue();
                    if (!(prob <= (cumulativeUtility += tipUtility))) continue;
                    $this$sampleByUtility.add((TipAndTrickBean)tip2utility.getFirst());
                    totalUtility -= tipUtility;
                    sortedTips.remove(tip2utility);
                    break;
                }
                ++i2;
            }
        }

        private final void sampleUnknown(List<TipAndTrickBean> $this$sampleUnknown, List<Pair<TipAndTrickBean, Double>> unknownTips) {
            double unknownProb = (double)unknownTips.size() / (double)($this$sampleUnknown.size() + unknownTips.size());
            int currentIndex = 0;
            for (Pair unknownTip : CollectionsKt.shuffled((Iterable)unknownTips)) {
                while (currentIndex < $this$sampleUnknown.size() && Random.Default.nextDouble() > unknownProb) {
                    ++currentIndex;
                }
                $this$sampleUnknown.add(currentIndex, (TipAndTrickBean)unknownTip.getFirst());
                ++currentIndex;
            }
        }

        private final double getTipUtility(TipAndTrickBean tip) {
            String string = tip.fileName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tip.fileName");
            return ((Number)this.tips2utility.getOrDefault(string, -1.0)).doubleValue();
        }

        private TipsUtilityHolder(Map<String, Double> tips2utility) {
            this.tips2utility = tips2utility;
        }

        static {
            Companion = new Companion(null);
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TipsUtilityHolder.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            LOG = logger;
        }

        public /* synthetic */ TipsUtilityHolder(Map tips2utility, DefaultConstructorMarker $constructor_marker) {
            this(tips2utility);
        }

        public static final /* synthetic */ Logger access$getLOG$cp() {
            return LOG;
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000bJ\u0006\u0010\r\u001a\u00020\tJ\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000bH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/util/TipsUsageManager$TipsUtilityHolder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TIPS_UTILITY_FILE", "", "create", "Lcom/intellij/ide/util/TipsUsageManager$TipsUtilityHolder;", "tipsUtility", "", "", "readFromResourcesAndCreate", "readTipsUtility", "intellij.platform.ide.impl"})
        public static final class Companion {
            @NotNull
            public final TipsUtilityHolder create(@NotNull Map<String, Double> tipsUtility) {
                Intrinsics.checkNotNullParameter(tipsUtility, (String)"tipsUtility");
                return new TipsUtilityHolder(tipsUtility, null);
            }

            @NotNull
            public final TipsUtilityHolder readFromResourcesAndCreate() {
                return this.create(this.readTipsUtility());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            private final Map<String, Double> readTipsUtility() {
                if (!EventQueue.isDispatchThread()) ** GOTO lbl-1000
                v0 = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"ApplicationManager.getApplication()");
                if (v0.isUnitTestMode()) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                var1_1 = v1;
                var2_3 = false;
                var3_5 = false;
                if (_Assertions.ENABLED && !var1_1) {
                    var4_8 = false;
                    var4_9 = "Assertion failed";
                    throw (Throwable)new AssertionError((Object)var4_9);
                }
                classLoader = TipsUtilityHolder.class.getClassLoader();
                v2 = classLoader.getResourceAsStream("tips_utility.csv");
                if (v2 != null) {
                    var3_6 = v2;
                    var4_10 = false;
                    var5_11 = false;
                    var5_12 = null;
                    try {
                        it = (InputStream)var3_6;
                        $i$a$-use-TipsUsageManager$TipsUtilityHolder$Companion$readTipsUtility$lines$1 = false;
                        var8_19 = it;
                        var9_21 = Charsets.UTF_8;
                        var10_22 = false;
                        var11_24 = var8_19;
                        var12_25 = 0;
                        var11_24 = new InputStreamReader((InputStream)var11_24, var9_21);
                        var12_25 = 8192;
                        var13_27 = false;
                        it = TextStreamsKt.readLines((Reader)(var11_24 instanceof BufferedReader != false ? (BufferedReader)var11_24 : new BufferedReader((Reader)var11_24, var12_25)));
                        v3 = it;
                    }
                    catch (Throwable it) {
                        var5_12 = it;
                        throw it;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var3_6, (Throwable)var5_12);
                    }
                } else {
                    v3 = lines = null;
                }
                if (lines == null) {
                    TipsUtilityHolder.access$getLOG$cp().error("Can't read resource file with tips utilities: tips_utility.csv");
                    return MapsKt.emptyMap();
                }
                $this$associate$iv = (Iterable)lines;
                $i$f$associate = false;
                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                it = $this$associate$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                $i$f$associateTo = false;
                for (E element$iv$iv : $this$associateTo$iv$iv) {
                    var11_24 = destination$iv$iv;
                    it = (String)element$iv$iv;
                    $i$a$-associate-TipsUsageManager$TipsUtilityHolder$Companion$readTipsUtility$1 = false;
                    values = StringsKt.split$default((CharSequence)it, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
                    v4 = StringsKt.toDoubleOrNull((String)((String)values.get(1)));
                    var12_26 = new Pair(values.get(0), (Object)(v4 != null ? v4 : 0.0));
                    var13_27 = false;
                    var11_24.put(var12_26.getFirst(), var12_26.getSecond());
                }
                return destination$iv$iv;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/util/TipsUsageManager$TipsUsageListener;", "Lcom/intellij/featureStatistics/FeaturesRegistryListener;", "(Lcom/intellij/ide/util/TipsUsageManager;)V", "featureUsed", "", "feature", "Lcom/intellij/featureStatistics/FeatureDescriptor;", "intellij.platform.ide.impl"})
    private final class TipsUsageListener
    implements FeaturesRegistryListener {
        public void featureUsed(@NotNull FeatureDescriptor feature) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
                TipAndTrickBean tipAndTrickBean = TipUIUtil.getTip(feature);
                if (tipAndTrickBean == null) break block1;
                TipAndTrickBean tipAndTrickBean2 = tipAndTrickBean;
                boolean bl = false;
                boolean bl2 = false;
                TipAndTrickBean tip = tipAndTrickBean2;
                boolean bl3 = false;
                Long l = (Long)TipsUsageManager.this.shownTips.get(tip.fileName);
                if (l != null) {
                    Long l2 = l;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    long timestamp = ((Number)l2).longValue();
                    boolean bl6 = false;
                    TipsOfTheDayUsagesCollector.triggerTipUsed(tip.fileName, System.currentTimeMillis() - timestamp);
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ide/util/TipsUsageManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/ide/util/TipsUsageManager;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final TipsUsageManager getInstance() {
            boolean $i$f$service = false;
            Class<TipsUsageManager> serviceClass$iv = TipsUsageManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (TipsUsageManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

