/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.InputMethodDisablerKt;
import com.intellij.idea.OutputParser;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.util.Consumer;
import com.intellij.util.ReflectionUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.im.InputContext;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0006\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0007\u001a\u00020\bH\u0002\u001a\b\u0010\t\u001a\u00020\bH\u0000\u001a\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\r\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"IS_NOTIFICATION_REGISTERED", "", "NOTIFICATION_GROUP", "", "PERSISTENT_SETTING_AUTO_DISABLE_KEY", "PERSISTENT_SETTING_MUTED_KEY", "canDisableInputMethod", "disableInputMethdosImpl", "", "disableInputMethodsIfPossible", "freeIMRecursively", "c", "Ljava/awt/Component;", "getLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
public final class InputMethodDisablerKt {
    private static final String PERSISTENT_SETTING_MUTED_KEY = "input.method.disabler.muted";
    private static final String PERSISTENT_SETTING_AUTO_DISABLE_KEY = "input.method.disabler.auto";
    private static final String NOTIFICATION_GROUP = "Input method disabler";
    private static boolean IS_NOTIFICATION_REGISTERED;

    public static final void disableInputMethodsIfPossible() {
        if (!SystemInfo.isXWindow || !SystemInfo.isJetBrainsJvm) {
            return;
        }
        PropertiesComponent properties2 = PropertiesComponent.getInstance();
        boolean muted = properties2.isTrueValue(PERSISTENT_SETTING_MUTED_KEY);
        if (muted) {
            boolean auto = properties2.isTrueValue(PERSISTENT_SETTING_AUTO_DISABLE_KEY);
            if (auto) {
                EventQueue.invokeLater(disableInputMethodsIfPossible.1.INSTANCE);
            }
            return;
        }
        properties2.setValue(PERSISTENT_SETTING_MUTED_KEY, true);
        if (!InputMethodDisablerKt.canDisableInputMethod()) {
            return;
        }
        if (!IS_NOTIFICATION_REGISTERED) {
            IS_NOTIFICATION_REGISTERED = true;
            NotificationsConfiguration.getNotificationsConfiguration().register(NOTIFICATION_GROUP, NotificationDisplayType.STICKY_BALLOON, true);
        }
        String string = IdeBundle.message((String)"notification.title.input.method.disabler", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"notif\u2026e.input.method.disabler\")");
        String title2 = string;
        String string2 = IdeBundle.message((String)"notification.content.input.method.disabler", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdeBundle.message(\"notif\u2026t.input.method.disabler\")");
        String message2 = string2;
        Notification notification = new Notification(NOTIFICATION_GROUP, title2, message2, NotificationType.WARNING);
        notification.addAction((AnAction)DumbAwareAction.create((String)IdeBundle.message((String)"action.text.disable.input.methods", (Object[])new Object[0]), (Consumer)new Consumer(notification){
            final /* synthetic */ Notification $notification;

            public final void consume(@Nullable AnActionEvent e) {
                PropertiesComponent.getInstance().setValue("input.method.disabler.auto", true);
                InputMethodDisablerKt.access$disableInputMethdosImpl();
                this.$notification.expire();
            }
            {
                this.$notification = notification;
            }
        }));
        notification.notify(null);
    }

    /*
     * WARNING - void declaration
     */
    private static final void disableInputMethdosImpl() {
        try {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Class clazz = ReflectionUtil.forName((String)"java.awt.Component");
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"ReflectionUtil.forName(\"java.awt.Component\")");
            Class componentClass = clazz;
            Method method2 = ReflectionUtil.getMethod((Class)componentClass, (String)"disableInputMethodSupport", (Class[])new Class[0]);
            if (method2 == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"ReflectionUtil.getMethod\u2026MethodSupport\") ?: return");
            Method method3 = method2;
            method3.invoke((Object)componentClass, new Object[0]);
            InputMethodDisablerKt.getLogger().info("Input method disabler: disabled for any java.awt.Component.");
            WindowManagerEx windowManagerEx = WindowManagerEx.getInstanceEx();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)windowManagerEx), (String)"WindowManagerEx.getInstanceEx()");
            List<ProjectFrameHelper> list2 = windowManagerEx.getProjectFrameHelpers();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"WindowManagerEx.getInsta\u2026eEx().projectFrameHelpers");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void fh;
                ProjectFrameHelper projectFrameHelper = (ProjectFrameHelper)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v4 = fh;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"fh");
                Component component2 = SwingUtilities.getRoot(v4.getFrame());
                collection.add(component2);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Component \u0441 = (Component)element$iv$iv;
                boolean bl = false;
                if (!(\u0441 != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List frames = (List)destination$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)ApplicationManager.getApplication().executeOnPooledThread(new Runnable(frames){
                final /* synthetic */ List $frames;

                public final void run() {
                    long startMs = System.currentTimeMillis();
                    Iterator<E> iterator2 = this.$frames.iterator();
                    while (iterator2.hasNext()) {
                        Component frameRoot;
                        Component component2 = frameRoot = (Component)iterator2.next();
                        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"frameRoot");
                        InputMethodDisablerKt.access$freeIMRecursively(component2);
                    }
                    InputMethodDisablerKt.access$getLogger().info("Input method disabler: resources of input methods were released, spent " + (System.currentTimeMillis() - startMs) + " ms.");
                }
                {
                    this.$frames = list2;
                }
            }), (String)"ApplicationManager.getAp\u2026 startMs) + \" ms.\")\n    }");
        }
        catch (Throwable e) {
            InputMethodDisablerKt.getLogger().warn(e);
        }
    }

    private static final Logger getLogger() {
        Logger logger = Logger.getInstance((String)"#com.intellij.idea.ApplicationLoader");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026.idea.ApplicationLoader\")");
        return logger;
    }

    private static final void freeIMRecursively(Component c) {
        InputContext ic2 = c.getInputContext();
        if (ic2 != null) {
            ic2.removeNotify(c);
        }
        if (!(c instanceof Container)) {
            return;
        }
        Component[] componentArray = ((Container)c).getComponents();
        int n = componentArray.length;
        for (int j = 0; j < n; ++j) {
            Component k;
            Component component2 = k = componentArray[j];
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"k");
            InputMethodDisablerKt.freeIMRecursively(component2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean canDisableInputMethod() {
        boolean canDisable;
        boolean first;
        Object parser;
        boolean isGTKDesktop;
        String string;
        String gdmSession;
        block16: {
            block15: {
                String string2 = System.getenv("GDMSESSION");
                if (string2 == null) {
                    string2 = gdmSession = "";
                }
                if ((string = System.getenv("XDG_CURRENT_DESKTOP")) == null) break block15;
                String string3 = string;
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ENGLISH");
                Locale locale2 = locale;
                boolean bl = false;
                String string4 = string3;
                boolean bl2 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
                string = string6;
                if (string6 != null) break block16;
            }
            string = "";
        }
        String xdgDesktop = string;
        boolean bl = isGTKDesktop = StringsKt.startsWith$default((String)gdmSession, (String)"gnome", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)gdmSession, (String)"ubuntu", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)xdgDesktop, (String)"unity", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)xdgDesktop, (String)"ubuntu", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)xdgDesktop, (String)"gnome", (boolean)false, (int)2, null);
        if (!isGTKDesktop) {
            InputMethodDisablerKt.getLogger().info("Input method disabler: not gtk desktop: '" + gdmSession + "' | '" + xdgDesktop + '\'');
            return false;
        }
        long startMs = System.currentTimeMillis();
        HashMap layoutId2type = new HashMap();
        String line = "";
        try {
            String cmd = "gsettings get org.gnome.desktop.input-sources sources";
            Runtime run2 = Runtime.getRuntime();
            Process pr = run2.exec(cmd);
            pr.waitFor();
            Process process2 = pr;
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"pr");
            BufferedReader buf = new BufferedReader(new InputStreamReader(process2.getInputStream()));
            block2: for (String line2 : TextStreamsKt.lineSequence((BufferedReader)buf)) {
                parser = new OutputParser(line2);
                first = true;
                while (true) {
                    String type;
                    if ((type = ((OutputParser)parser).extractString(first ? "('" : "'", "'")) == null) {
                        if (!first) continue block2;
                        InputMethodDisablerKt.getLogger().warn("Input method disabler: can't parse gsettings line: " + line2);
                        return false;
                    }
                    first = false;
                    String layoutId = ((OutputParser)parser).extractString("'", "'");
                    if (layoutId == null) {
                        InputMethodDisablerKt.getLogger().warn("Input method disabler: can't parse gsettings line: " + line2);
                        return false;
                    }
                    ((Map)layoutId2type).put(layoutId, type);
                }
            }
        }
        catch (Throwable e) {
            InputMethodDisablerKt.getLogger().warn("Input method disabler: error during parsing gsettings line: " + line, e);
        }
        long endMs = System.currentTimeMillis();
        boolean bl3 = canDisable = !layoutId2type.isEmpty() && !layoutId2type.values().contains("ibus");
        if (canDisable) {
            Set supportedLayouts = SetsKt.setOf((Object[])new String[]{"am", "ara", "by", "jp", "kg", "kr", "la", "mk", "np", "ru", "th", "us"});
            for (String key : layoutId2type.keySet()) {
                if (supportedLayouts.contains(key)) continue;
                canDisable = false;
                break;
            }
        }
        StringBuilder logInfo = new StringBuilder("Input method disabler: canDisableInputMethod spent ").append(endMs - startMs).append(" ms, found keyboard layouts: [");
        parser = layoutId2type;
        first = false;
        Iterator iterator2 = parser.entrySet().iterator();
        while (iterator2.hasNext()) {
            void key;
            Map.Entry entry2;
            Map.Entry entry3 = entry2 = iterator2.next();
            boolean bl4 = false;
            parser = (String)entry3.getKey();
            entry3 = entry2;
            bl4 = false;
            String value2 = (String)entry3.getValue();
            logInfo.append('(');
            logInfo.append((String)key);
            logInfo.append(", ");
            logInfo.append(value2);
            logInfo.append("), ");
        }
        logInfo.append("], result==").append(canDisable);
        InputMethodDisablerKt.getLogger().info(logInfo.toString());
        return canDisable;
    }

    public static final /* synthetic */ void access$disableInputMethdosImpl() {
        InputMethodDisablerKt.disableInputMethdosImpl();
    }

    public static final /* synthetic */ void access$freeIMRecursively(Component c) {
        InputMethodDisablerKt.freeIMRecursively(c);
    }

    public static final /* synthetic */ Logger access$getLogger() {
        return InputMethodDisablerKt.getLogger();
    }
}

