/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.CliResult;
import com.intellij.ide.IdeBundle;
import com.intellij.idea.SplashManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtilRt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.MessageDecoder;

public final class SocketLock {
    public static final String LAUNCHER_INITIAL_DIRECTORY_ENV_VAR = "IDEA_INITIAL_DIRECTORY";
    private static final String ACTIVATE_COMMAND = "activate ";
    private static final String OK_RESPONSE = "ok";
    private static final String PATHS_EOT_RESPONSE = "---";
    private final AtomicReference<Function<List<String>, Future<CliResult>>> myCommandProcessorRef;
    private final Path myConfigPath;
    private final Path mySystemPath;
    private final List<AutoCloseable> myLockedFiles;
    private volatile CompletableFuture<BuiltInServer> myBuiltinServerFuture;

    public SocketLock(@NotNull Path configPath, @NotNull Path systemPath) {
        if (configPath == null) {
            SocketLock.$$$reportNull$$$0(0);
        }
        if (systemPath == null) {
            SocketLock.$$$reportNull$$$0(1);
        }
        this.myLockedFiles = new ArrayList<AutoCloseable>(4);
        this.myConfigPath = configPath;
        this.mySystemPath = systemPath;
        if (this.myConfigPath.equals(this.mySystemPath)) {
            throw new IllegalArgumentException("'config' and 'system' paths should point to different directories");
        }
        this.myCommandProcessorRef = new AtomicReference<Function<List, Future>>(args -> CliResult.error((int)14, (String)IdeBundle.message((String)"activation.not.initialized", (Object[])new Object[0])));
    }

    @NotNull
    public Path getConfigPath() {
        Path path2 = this.myConfigPath;
        if (path2 == null) {
            SocketLock.$$$reportNull$$$0(2);
        }
        return path2;
    }

    @NotNull
    public Path getSystemPath() {
        Path path2 = this.mySystemPath;
        if (path2 == null) {
            SocketLock.$$$reportNull$$$0(3);
        }
        return path2;
    }

    public void setCommandProcessor(@NotNull Function<List<String>, Future<CliResult>> processor2) {
        if (processor2 == null) {
            SocketLock.$$$reportNull$$$0(4);
        }
        this.myCommandProcessorRef.set(processor2);
    }

    public void dispose() {
        SocketLock.log("enter: dispose()", new Object[0]);
        BuiltInServer server = null;
        try {
            server = this.getServer();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.myLockedFiles.isEmpty()) {
                this.lockPortFiles();
            }
            if (server != null) {
                Disposer.dispose((Disposable)server);
            }
            Files.deleteIfExists(this.myConfigPath.resolve("port"));
            Files.deleteIfExists(this.mySystemPath.resolve("port"));
            Files.deleteIfExists(this.mySystemPath.resolve("token"));
            this.unlockPortFiles();
        }
        catch (Exception e) {
            SocketLock.log(e);
        }
    }

    @Nullable
    BuiltInServer getServer() {
        CompletableFuture<BuiltInServer> future2 = this.myBuiltinServerFuture;
        if (future2 != null) {
            try {
                return (BuiltInServer)future2.get();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e.getCause());
            }
        }
        return null;
    }

    @Nullable
    CompletableFuture<BuiltInServer> getServerFuture() {
        return this.myBuiltinServerFuture;
    }

    @NotNull
    public Map.Entry<ActivationStatus, CliResult> lockAndTryActivate(@NotNull @NotNull String @NotNull [] args) throws Exception {
        if (args == null) {
            SocketLock.$$$reportNull$$$0(5);
        }
        SocketLock.log("enter: lock(config=%s system=%s)", this.myConfigPath, this.mySystemPath);
        this.lockPortFiles();
        HashMap<Integer, List<String>> portToPath = new HashMap<Integer, List<String>>();
        SocketLock.readPort(this.myConfigPath, portToPath);
        SocketLock.readPort(this.mySystemPath, portToPath);
        if (!portToPath.isEmpty()) {
            for (Map.Entry entry2 : portToPath.entrySet()) {
                Map.Entry<ActivationStatus, CliResult> status = this.tryActivate((Integer)entry2.getKey(), (List)entry2.getValue(), args);
                if (status.getKey() == ActivationStatus.NO_INSTANCE) continue;
                SocketLock.log("exit: lock(): " + status.getValue(), new Object[0]);
                this.unlockPortFiles();
                Map.Entry<ActivationStatus, CliResult> entry3 = status;
                if (entry3 == null) {
                    SocketLock.$$$reportNull$$$0(6);
                }
                return entry3;
            }
        }
        this.myBuiltinServerFuture = CompletableFuture.supplyAsync(() -> {
            Activity activity = StartUpMeasurer.startActivity((String)"built-in server launch", (ActivityCategory)ActivityCategory.DEFAULT);
            String token2 = UUID.randomUUID().toString();
            Path[] lockedPaths = new Path[]{this.myConfigPath, this.mySystemPath};
            BuiltInServer server = BuiltInServer.Companion.start(6942, 50, false, () -> new MyChannelInboundHandler(lockedPaths, this.myCommandProcessorRef, token2));
            try {
                byte[] portBytes = Integer.toString(server.getPort()).getBytes(StandardCharsets.UTF_8);
                Files.write(this.myConfigPath.resolve("port"), portBytes, new OpenOption[0]);
                Files.write(this.mySystemPath.resolve("port"), portBytes, new OpenOption[0]);
                Path tokenFile = this.mySystemPath.resolve("token");
                Files.write(tokenFile, token2.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                PosixFileAttributeView view = Files.getFileAttributeView(tokenFile, PosixFileAttributeView.class, new LinkOption[0]);
                if (view != null) {
                    try {
                        view.setPermissions(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
                    }
                    catch (IOException e) {
                        SocketLock.log(e);
                    }
                }
                this.unlockPortFiles();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
            activity.end();
            return server;
        }, ForkJoinPool.commonPool());
        SocketLock.log("exit: lock(): succeed", new Object[0]);
        return new AbstractMap.SimpleEntry<ActivationStatus, Object>(ActivationStatus.NO_INSTANCE, null);
    }

    private synchronized void lockPortFiles() throws IOException {
        if (!this.myLockedFiles.isEmpty()) {
            throw new IllegalStateException("File locking must not be called twice");
        }
        OpenOption[] options2 = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
        Files.createDirectories(this.myConfigPath, new FileAttribute[0]);
        FileChannel cc = FileChannel.open(this.myConfigPath.resolve("port.lock"), options2);
        this.myLockedFiles.add(cc);
        this.myLockedFiles.add(cc.lock());
        Files.createDirectories(this.mySystemPath, new FileAttribute[0]);
        FileChannel sc = FileChannel.open(this.mySystemPath.resolve("port.lock"), options2);
        this.myLockedFiles.add(sc);
        this.myLockedFiles.add(sc.lock());
    }

    private synchronized void unlockPortFiles() throws Exception {
        if (this.myLockedFiles.isEmpty()) {
            throw new IllegalStateException("File unlocking must not be called twice");
        }
        for (int i2 = this.myLockedFiles.size() - 1; i2 >= 0; --i2) {
            this.myLockedFiles.get(i2).close();
        }
        this.myLockedFiles.clear();
    }

    private static String readOneLine(Path file2) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file2);){
            String string = reader.readLine().trim();
            return string;
        }
    }

    private static void readPort(Path dir, Map<Integer, List<String>> portToPath) {
        try {
            portToPath.computeIfAbsent(Integer.parseInt(SocketLock.readOneLine(dir.resolve("port"))), it -> new ArrayList()).add(dir.toString());
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (Exception e) {
            SocketLock.log(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map.Entry<ActivationStatus, CliResult> tryActivate(int portNumber, List<String> paths2, String[] args) {
        SocketLock.log("trying: port=%s", portNumber);
        try (Socket socket = new Socket(InetAddress.getByName("127.0.0.1"), portNumber);){
            socket.setSoTimeout(5000);
            DataInputStream in = new DataInputStream(socket.getInputStream());
            List<String> stringList = SocketLock.readStringSequence(in);
            boolean result2 = paths2.stream().anyMatch(stringList::contains);
            if (!result2) return new AbstractMap.SimpleEntry<ActivationStatus, Object>(ActivationStatus.NO_INSTANCE, null);
            System.setProperty("splash", "false");
            EventQueue.invokeLater(() -> {
                Runnable hideSplashTask = SplashManager.getHideTask();
                if (hideSplashTask != null) {
                    hideSplashTask.run();
                }
            });
            try {
                String token2 = SocketLock.readOneLine(this.mySystemPath.resolve("token"));
                DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                String currentDirectory = System.getenv(LAUNCHER_INITIAL_DIRECTORY_ENV_VAR);
                if (currentDirectory == null) {
                    currentDirectory = ".";
                }
                out.writeUTF(ACTIVATE_COMMAND + token2 + "\u0000" + Paths.get(currentDirectory, new String[0]).toAbsolutePath() + "\u0000" + String.join((CharSequence)"\u0000", args));
                out.flush();
                socket.setSoTimeout(0);
                List<String> response = SocketLock.readStringSequence(in);
                SocketLock.log("read: response=%s", String.join((CharSequence)";", response));
                if (!response.isEmpty() && OK_RESPONSE.equals(response.get(0))) {
                    AbstractMap.SimpleEntry<ActivationStatus, CliResult> simpleEntry = new AbstractMap.SimpleEntry<ActivationStatus, CliResult>(ActivationStatus.ACTIVATED, SocketLock.mapResponseToCliResult(response));
                    return simpleEntry;
                }
            }
            catch (IOException | IllegalArgumentException e) {
                SocketLock.log(e);
            }
            AbstractMap.SimpleEntry<ActivationStatus, Object> simpleEntry = new AbstractMap.SimpleEntry<ActivationStatus, Object>(ActivationStatus.CANNOT_ACTIVATE, null);
            return simpleEntry;
        }
        catch (ConnectException e) {
            SocketLock.log("%s (stale port file?)", e.getMessage());
            return new AbstractMap.SimpleEntry<ActivationStatus, Object>(ActivationStatus.NO_INSTANCE, null);
        }
        catch (IOException e) {
            SocketLock.log(e);
        }
        return new AbstractMap.SimpleEntry<ActivationStatus, Object>(ActivationStatus.NO_INSTANCE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendStringSequence(ChannelHandlerContext context2, List<String> strings) throws IOException {
        ByteBuf buffer = context2.alloc().ioBuffer(1024);
        boolean success2 = false;
        try (ByteBufOutputStream out = new ByteBufOutputStream(buffer);){
            for (String s : strings) {
                out.writeUTF(s);
            }
            out.writeUTF(PATHS_EOT_RESPONSE);
            success2 = true;
        }
        finally {
            if (!success2) {
                buffer.release();
            }
        }
        context2.writeAndFlush((Object)buffer);
    }

    private static List<String> readStringSequence(DataInput in) {
        ArrayList<String> result2 = new ArrayList<String>();
        try {
            while (true) {
                String string = in.readUTF();
                SocketLock.log("read: path=%s", string);
                if (!PATHS_EOT_RESPONSE.equals(string)) {
                    result2.add(string);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            SocketLock.log("read: %s", e.getMessage());
        }
        return result2;
    }

    private static CliResult mapResponseToCliResult(List<String> responseParts) throws IllegalArgumentException {
        int code;
        if (responseParts.size() > 3 || responseParts.size() < 2) {
            throw new IllegalArgumentException("bad response: " + String.join((CharSequence)";", responseParts));
        }
        try {
            code = Integer.parseInt(responseParts.get(1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Second part is not a parsable return code", e);
        }
        String message2 = responseParts.size() == 3 ? responseParts.get(2) : null;
        return new CliResult(code, message2);
    }

    private static void log(Exception e) {
        Logger.getInstance(SocketLock.class).warn((Throwable)e);
    }

    private static void log(String format2, Object ... args) {
        Logger logger = Logger.getInstance(SocketLock.class);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format(format2, args));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemPath";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/SocketLock";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/SocketLock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "lockAndTryActivate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCommandProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lockAndTryActivate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyChannelInboundHandler
    extends MessageDecoder {
        private final List<String> myLockedPaths;
        private final AtomicReference<Function<List<String>, Future<CliResult>>> myCommandProcessorRef;
        private final String myToken;
        private State myState = State.HEADER;

        MyChannelInboundHandler(Path[] lockedPaths, AtomicReference<Function<List<String>, Future<CliResult>>> commandProcessorRef, String token2) {
            this.myLockedPaths = new ArrayList<String>(lockedPaths.length);
            for (Path path2 : lockedPaths) {
                this.myLockedPaths.add(path2.toString());
            }
            this.myCommandProcessorRef = commandProcessorRef;
            this.myToken = token2;
        }

        public void channelActive(@NotNull ChannelHandlerContext context2) throws Exception {
            if (context2 == null) {
                MyChannelInboundHandler.$$$reportNull$$$0(0);
            }
            SocketLock.sendStringSequence(context2, this.myLockedPaths);
        }

        protected void messageReceived(@NotNull ChannelHandlerContext context2, @NotNull ByteBuf input) throws Exception {
            if (context2 == null) {
                MyChannelInboundHandler.$$$reportNull$$$0(1);
            }
            if (input == null) {
                MyChannelInboundHandler.$$$reportNull$$$0(2);
            }
            while (true) {
                switch (this.myState) {
                    case HEADER: {
                        ByteBuf buffer = this.getBufferIfSufficient(input, 2, context2);
                        if (buffer == null) {
                            return;
                        }
                        this.contentLength = buffer.readUnsignedShort();
                        if (this.contentLength > 8192) {
                            context2.close();
                            return;
                        }
                        this.myState = State.CONTENT;
                        break;
                    }
                    case CONTENT: {
                        CharSequence command = this.readChars(input);
                        if (command == null) {
                            return;
                        }
                        if (StringUtilRt.startsWith((CharSequence)command, (CharSequence)SocketLock.ACTIVATE_COMMAND)) {
                            CliResult result2;
                            boolean tokenOK;
                            String data2;
                            StringTokenizer tokenizer = new StringTokenizer(data2, (data2 = command.subSequence(SocketLock.ACTIVATE_COMMAND.length(), command.length()).toString()).contains("\u0000") ? "\u0000" : "\ufffd");
                            boolean bl = tokenOK = tokenizer.hasMoreTokens() && this.myToken.equals(tokenizer.nextToken());
                            if (tokenOK) {
                                ArrayList<String> list2 = new ArrayList<String>();
                                while (tokenizer.hasMoreTokens()) {
                                    list2.add(tokenizer.nextToken());
                                }
                                Future<CliResult> future2 = this.myCommandProcessorRef.get().apply(list2);
                                result2 = CliResult.unmap(future2, (int)15);
                            } else {
                                SocketLock.log(new UnsupportedOperationException("unauthorized request: " + command));
                                result2 = new CliResult(13, IdeBundle.message((String)"activation.auth.message", (Object[])new Object[0]));
                            }
                            String exitCode = String.valueOf(result2.exitCode);
                            String message2 = result2.message;
                            List<String> response = message2 != null ? List.of(SocketLock.OK_RESPONSE, exitCode, message2) : List.of(SocketLock.OK_RESPONSE, exitCode);
                            SocketLock.sendStringSequence(context2, response);
                        }
                        context2.close();
                        break;
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/idea/SocketLock$MyChannelInboundHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "channelActive";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "messageReceived";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static enum State {
            HEADER,
            CONTENT;

        }
    }

    public static enum ActivationStatus {
        ACTIVATED,
        NO_INSTANCE,
        CANNOT_ACTIVATE;

    }
}

