/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.util.lang.ClassLoadingLocks;
import com.intellij.util.lang.ImmutableZipEntry;
import com.intellij.util.lang.ImmutableZipFile;
import com.intellij.util.lang.ZipFilePool;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ZipFilePoolImpl
extends ZipFilePool {
    private final Map<Path, MyEntryResolver> pool = new ConcurrentHashMap<Path, MyEntryResolver>();
    private final ClassLoadingLocks<Path> lock = new ClassLoadingLocks();

    @NotNull
    public ImmutableZipFile loadZipFile(@NotNull Path file2) throws IOException {
        MyEntryResolver resolver;
        if (file2 == null) {
            ZipFilePoolImpl.$$$reportNull$$$0(0);
        }
        if ((resolver = this.pool.get(file2)) == null) {
            ImmutableZipFile immutableZipFile = ImmutableZipFile.load((Path)file2);
            if (immutableZipFile == null) {
                ZipFilePoolImpl.$$$reportNull$$$0(1);
            }
            return immutableZipFile;
        }
        ImmutableZipFile immutableZipFile = resolver.zipFile;
        if (immutableZipFile == null) {
            ZipFilePoolImpl.$$$reportNull$$$0(2);
        }
        return immutableZipFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ZipFilePool.EntryResolver load(@NotNull Path file2) throws IOException {
        MyEntryResolver resolver;
        if (file2 == null) {
            ZipFilePoolImpl.$$$reportNull$$$0(3);
        }
        if ((resolver = this.pool.get(file2)) == null) {
            Object object = this.lock.getOrCreateLock((Object)file2);
            synchronized (object) {
                resolver = this.pool.get(file2);
                if (resolver == null) {
                    ImmutableZipFile zipFile = ImmutableZipFile.load((Path)file2);
                    resolver = new MyEntryResolver(zipFile);
                    this.pool.put(file2, resolver);
                }
            }
        }
        MyEntryResolver myEntryResolver = resolver;
        if (myEntryResolver == null) {
            ZipFilePoolImpl.$$$reportNull$$$0(4);
        }
        return myEntryResolver;
    }

    public void clear() {
        this.pool.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/ZipFilePoolImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/ZipFilePoolImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadZipFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadZipFile";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyEntryResolver
    implements ZipFilePool.EntryResolver {
        private final ImmutableZipFile zipFile;

        MyEntryResolver(ImmutableZipFile zipFile) {
            this.zipFile = zipFile;
        }

        @Nullable
        public InputStream loadZipEntry(@NotNull String path2) throws IOException {
            if (path2 == null) {
                MyEntryResolver.$$$reportNull$$$0(0);
            }
            ImmutableZipEntry entry2 = this.zipFile.getEntry(path2.charAt(0) == '/' ? path2.substring(1) : path2);
            return entry2 == null ? null : entry2.getInputStream(this.zipFile);
        }

        public String toString() {
            return this.zipFile.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/idea/ZipFilePoolImpl$MyEntryResolver", "loadZipEntry"));
        }
    }
}

