/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.indexing.IndexingBundle;
import org.jetbrains.annotations.NotNull;

public class ToggleDumbModeAction
extends DumbAwareAction {
    private static final Key<Boolean> DUMB = Key.create((String)"ToggleDumbModeAction");

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ToggleDumbModeAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        if (ToggleDumbModeAction.isToggledDumb(project)) {
            ToggleDumbModeAction.setToggledDumb(project, false);
        } else {
            ToggleDumbModeAction.setToggledDumb(project, true);
            new DumbModeTask(project){

                public void performInDumbMode(@NotNull ProgressIndicator indicator2) {
                    if (indicator2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator2.setIndeterminate(true);
                    indicator2.setText(IndexingBundle.message((String)"toggled.dumb.mode", (Object[])new Object[0]));
                    while (ToggleDumbModeAction.isToggledDumb(project)) {
                        indicator2.checkCanceled();
                        TimeoutUtil.sleep((long)100L);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/internal/ToggleDumbModeAction$1", "performInDumbMode"));
                }
            }.queue(project);
        }
    }

    private static void setToggledDumb(Project project, boolean value2) {
        project.putUserData(DUMB, (Object)value2);
    }

    private static boolean isToggledDumb(Project project) {
        return project.getUserData(DUMB) == Boolean.TRUE;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ToggleDumbModeAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        boolean dumb = DumbServiceImpl.getInstance(project).isDumb();
        if (!dumb && ToggleDumbModeAction.isToggledDumb(project)) {
            ToggleDumbModeAction.setToggledDumb(project, false);
        }
        e.getPresentation().setEnabled(!dumb || ToggleDumbModeAction.isToggledDumb(project));
        e.getPresentation().setText(dumb ? "Exit Dumb Mode" : "Enter Dumb Mode");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/internal/ToggleDumbModeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

