/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.components;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentCategorizer;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/internal/components/ListPersistentStateComponentsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "ComponentDescriptor", "ComponentListDialog", "intellij.platform.ide.impl"})
public final class ListPersistentStateComponentsAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        new ComponentListDialog().show();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lcom/intellij/internal/components/ListPersistentStateComponentsAction$ComponentListDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "()V", "createCenterPanel", "Ljavax/swing/JComponent;", "ComponentTableModel", "intellij.platform.ide.impl"})
    public static final class ComponentListDialog
    extends DialogWrapper {
        /*
         * WARNING - void declaration
         */
        @NotNull
        protected JComponent createCenterPanel() {
            LayoutBuilder builder$iv;
            JBTable componentTable = new JBTable();
            componentTable.setModel((TableModel)new ComponentTableModel());
            Integer[] $this$forEachIndexed$iv = ComponentTableModel.Companion.getColumnWidths();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Integer item$iv : $this$forEachIndexed$iv) {
                TableColumn column2;
                void width;
                int n = index$iv++;
                int n2 = ((Number)item$iv).intValue();
                int i2 = n;
                boolean bl = false;
                if (width <= 0) continue;
                TableColumn tableColumn = column2 = componentTable.getColumnModel().getColumn(i2);
                Intrinsics.checkNotNullExpressionValue((Object)tableColumn, (String)"column");
                tableColumn.setMinWidth(JBUI.scale((int)width));
                column2.setMaxWidth(JBUI.scale((int)width));
            }
            LCFlags[] constraints$iv = new LCFlags[]{};
            String title$iv = null;
            boolean $i$f$panel = false;
            LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
            boolean bl = false;
            RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, null, false, (Function1)new Function1<Row, Unit>(componentTable){
                final /* synthetic */ JBTable $componentTable$inlined;
                {
                    this.$componentTable$inlined = jBTable;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                    $this$row.scrollPane((Component)this.$componentTable$inlined);
                }
            }, 3, null);
            DialogPanel panel$iv = ComponentsKt.DialogPanel(title$iv, null);
            builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
            LayoutKt.initPanel(builder$iv, panel$iv);
            return (JComponent)panel$iv;
        }

        public ComponentListDialog() {
            super(false);
            this.init();
            this.setTitle("Application-Level Persistent State Components");
            this.setSize(JBUI.scale((int)1000), JBUI.scale((int)600));
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0012\u0010\u0015\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0012H\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/internal/components/ListPersistentStateComponentsAction$ComponentListDialog$ComponentTableModel;", "Ljavax/swing/table/AbstractTableModel;", "()V", "descriptors", "Ljava/util/ArrayList;", "Lcom/intellij/internal/components/ListPersistentStateComponentsAction$ComponentDescriptor;", "Lkotlin/collections/ArrayList;", "getCategory", "", "aClass", "Ljava/lang/Class;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "state", "Lcom/intellij/openapi/components/State;", "descriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "roamingType", "getColumnCount", "", "getColumnName", "column", "getRoamingType", "getRowCount", "getValueAt", "", "rowIndex", "columnIndex", "Companion", "intellij.platform.ide.impl"})
        public static final class ComponentTableModel
        extends AbstractTableModel {
            private final ArrayList<ComponentDescriptor> descriptors = new ArrayList();
            @NotNull
            private static final String[] columnNames;
            @NotNull
            private static final Integer[] columnWidths;
            @NotNull
            public static final Companion Companion;

            private final String getCategory(Class<PersistentStateComponent<?>> aClass, State state, PluginDescriptor descriptor2, String roamingType) {
                String string;
                if (Intrinsics.areEqual((Object)roamingType, (Object)RoamingType.DISABLED.toString()) ^ true && descriptor2 != null) {
                    String string2 = descriptor2.getName();
                    PluginId pluginId = PluginManagerCore.SPECIAL_IDEA_PLUGIN_ID;
                    Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"PluginManagerCore.SPECIAL_IDEA_PLUGIN_ID");
                    if (Intrinsics.areEqual((Object)string2, (Object)pluginId.getIdString())) {
                        string = state;
                        if (string == null || (string = string.category()) == null || (string = string.name()) == null) {
                            string = "";
                        }
                    } else {
                        string = ComponentCategorizer.getPluginCategory(aClass, descriptor2.getPluginId()).toString();
                    }
                } else {
                    string = "";
                }
                return string;
            }

            private final String getRoamingType(State state) {
                if (state != null) {
                    String roamingType = null;
                    Storage[] $this$forEach$iv = state.storages();
                    boolean $i$f$forEach = false;
                    Storage[] storageArray = $this$forEach$iv;
                    int n = storageArray.length;
                    for (int j = 0; j < n; ++j) {
                        String storageRoamingType;
                        Storage element$iv;
                        Storage it = element$iv = storageArray[j];
                        boolean bl = false;
                        if (it.deprecated()) continue;
                        String string = storageRoamingType = Intrinsics.areEqual((Object)it.value(), (Object)"other.xml") || Intrinsics.areEqual((Object)it.value(), (Object)"$CACHE_FILE$") || Intrinsics.areEqual((Object)it.value(), (Object)"$WORKSPACE_FILE$") ? "DISABLED" : it.roamingType().toString();
                        if (roamingType == null) {
                            roamingType = storageRoamingType;
                            continue;
                        }
                        if (!(Intrinsics.areEqual((Object)roamingType, (Object)storageRoamingType) ^ true)) continue;
                        roamingType = "MIXED";
                    }
                    String string = roamingType;
                    if (string == null) {
                        string = "";
                    }
                    return string;
                }
                return "";
            }

            @Override
            public int getRowCount() {
                return this.descriptors.size();
            }

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            @NotNull
            public Object getValueAt(int rowIndex, int columnIndex) {
                String string;
                switch (columnIndex) {
                    case 0: {
                        string = this.descriptors.get(rowIndex).getName();
                        break;
                    }
                    case 1: {
                        string = this.descriptors.get(rowIndex).getClassName();
                        break;
                    }
                    case 2: {
                        string = this.descriptors.get(rowIndex).getRoamingType();
                        break;
                    }
                    case 3: {
                        string = this.descriptors.get(rowIndex).getCategory();
                        break;
                    }
                    default: {
                        string = "";
                    }
                }
                return string;
            }

            @Override
            @NotNull
            public String getColumnName(int column2) {
                return columnNames[column2];
            }

            public ComponentTableModel() {
                Application application = ApplicationManager.getApplication();
                if (application == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.serviceContainer.ComponentManagerImpl");
                }
                ComponentManagerImpl componentManager = (ComponentManagerImpl)application;
                componentManager.processAllImplementationClasses((Function2)new Function2<Class<?>, PluginDescriptor, Unit>(){

                    public final void invoke(@NotNull Class<?> aClass, @Nullable PluginDescriptor descriptor2) {
                        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
                        if (PersistentStateComponent.class.isAssignableFrom(aClass)) {
                            State state = aClass.getAnnotation(State.class);
                            String roamingType = this.getRoamingType(state);
                            ArrayList arrayList = descriptors;
                            Object object = descriptor2;
                            if (object == null || (object = object.getName()) == null || (object = ((String)object).toString()) == null) {
                                object = "";
                            }
                            String string = aClass.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"aClass.name");
                            arrayList.add(new ComponentDescriptor((String)object, string, roamingType, this.getCategory(aClass, state, descriptor2, roamingType)));
                        }
                    }
                });
                boolean bl = false;
                Comparator comparator2 = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        ComponentDescriptor it = (ComponentDescriptor)a;
                        boolean bl2 = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (ComponentDescriptor)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Comparable comparable3 = (Comparable)((Object)it.getName());
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                    }
                };
                boolean bl2 = false;
                CollectionsKt.sortWith((List)this.descriptors, (Comparator)new Comparator<T>(comparator2){
                    final /* synthetic */ Comparator $this_thenBy;
                    {
                        this.$this_thenBy = comparator2;
                    }

                    public final int compare(T a, T b) {
                        int n;
                        int previousCompare = this.$this_thenBy.compare(a, b);
                        if (previousCompare != 0) {
                            n = previousCompare;
                        } else {
                            boolean bl = false;
                            ComponentDescriptor it = (ComponentDescriptor)a;
                            boolean bl2 = false;
                            Comparable comparable = (Comparable)((Object)it.getClassName());
                            it = (ComponentDescriptor)b;
                            Comparable comparable2 = comparable;
                            bl2 = false;
                            Comparable comparable3 = (Comparable)((Object)it.getClassName());
                            n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                        }
                        return n;
                    }
                });
            }

            static {
                Companion = new Companion(null);
                columnNames = new String[]{"Plugin", "Class Name", "Roaming Type", "Category"};
                columnWidths = new Integer[]{250, -1, 100, 100};
            }

            @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/internal/components/ListPersistentStateComponentsAction$ComponentListDialog$ComponentTableModel$Companion;", "", "()V", "columnNames", "", "", "getColumnNames", "()[Ljava/lang/String;", "[Ljava/lang/String;", "columnWidths", "", "getColumnWidths", "()[Ljava/lang/Integer;", "[Ljava/lang/Integer;", "intellij.platform.ide.impl"})
            public static final class Companion {
                @NotNull
                public final String[] getColumnNames() {
                    return columnNames;
                }

                @NotNull
                public final Integer[] getColumnWidths() {
                    return columnWidths;
                }

                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/intellij/internal/components/ListPersistentStateComponentsAction$ComponentDescriptor;", "", "name", "", "className", "roamingType", "category", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCategory", "()Ljava/lang/String;", "getClassName", "getName", "getRoamingType", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
    public static final class ComponentDescriptor {
        @NotNull
        private final String name;
        @NotNull
        private final String className;
        @NotNull
        private final String roamingType;
        @NotNull
        private final String category;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        @NotNull
        public final String getRoamingType() {
            return this.roamingType;
        }

        @NotNull
        public final String getCategory() {
            return this.category;
        }

        public ComponentDescriptor(@NotNull String name2, @NotNull String className, @NotNull String roamingType, @NotNull String category) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            this.name = name2;
            this.className = className;
            this.roamingType = roamingType;
            this.category = category;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.className;
        }

        @NotNull
        public final String component3() {
            return this.roamingType;
        }

        @NotNull
        public final String component4() {
            return this.category;
        }

        @NotNull
        public final ComponentDescriptor copy(@NotNull String name2, @NotNull String className, @NotNull String roamingType, @NotNull String category) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            return new ComponentDescriptor(name2, className, roamingType, category);
        }

        public static /* synthetic */ ComponentDescriptor copy$default(ComponentDescriptor componentDescriptor, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = componentDescriptor.name;
            }
            if ((n & 2) != 0) {
                string2 = componentDescriptor.className;
            }
            if ((n & 4) != 0) {
                string3 = componentDescriptor.roamingType;
            }
            if ((n & 8) != 0) {
                string4 = componentDescriptor.category;
            }
            return componentDescriptor.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "ComponentDescriptor(name=" + this.name + ", className=" + this.className + ", roamingType=" + this.roamingType + ", category=" + this.category + ")";
        }

        public int hashCode() {
            String string = this.name;
            String string2 = this.className;
            String string3 = this.roamingType;
            String string4 = this.category;
            return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ComponentDescriptor)) break block3;
                    ComponentDescriptor componentDescriptor = (ComponentDescriptor)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)componentDescriptor.name) || !Intrinsics.areEqual((Object)this.className, (Object)componentDescriptor.className) || !Intrinsics.areEqual((Object)this.roamingType, (Object)componentDescriptor.roamingType) || !Intrinsics.areEqual((Object)this.category, (Object)componentDescriptor.category)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

