/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml;

import com.intellij.internal.ml.Feature;
import com.intellij.internal.ml.FeatureMapper;
import com.intellij.internal.ml.InconsistentMetadataException;
import com.intellij.internal.ml.UndefinedMapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0016J\u0013\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/internal/ml/FloatFeature;", "Lcom/intellij/internal/ml/Feature;", "name", "", "defaultValue", "", "allowUndefined", "", "(Ljava/lang/String;DZ)V", "getAllowUndefined", "()Z", "getDefaultValue", "()D", "getName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "createMapper", "Lcom/intellij/internal/ml/FeatureMapper;", "suffix", "equals", "other", "", "hashCode", "", "toString", "FloatMapper", "intellij.platform.ide.impl"})
public final class FloatFeature
extends Feature {
    @NotNull
    private final String name;
    private final double defaultValue;
    private final boolean allowUndefined;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public FeatureMapper createMapper(@Nullable String suffix) {
        FeatureMapper featureMapper;
        String string = suffix;
        if (string != null) {
            String string2 = string;
            switch (string2.hashCode()) {
                case 1748463920: {
                    if (!string2.equals("UNDEFINED")) throw (Throwable)new InconsistentMetadataException("Unexpected float feature suffix: " + suffix + " (feature '" + this.getName() + "')");
                    featureMapper = UndefinedMapper.Companion.checkAndCreate(this.getName(), this.allowUndefined);
                    return featureMapper;
                }
                default: {
                    throw (Throwable)new InconsistentMetadataException("Unexpected float feature suffix: " + suffix + " (feature '" + this.getName() + "')");
                }
            }
        }
        featureMapper = new FloatMapper();
        return featureMapper;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public final double getDefaultValue() {
        return this.defaultValue;
    }

    public final boolean getAllowUndefined() {
        return this.allowUndefined;
    }

    public FloatFeature(@NotNull String name2, double defaultValue, boolean allowUndefined) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        super(null);
        this.name = name2;
        this.defaultValue = defaultValue;
        this.allowUndefined = allowUndefined;
    }

    @NotNull
    public final String component1() {
        return this.getName();
    }

    public final double component2() {
        return this.defaultValue;
    }

    public final boolean component3() {
        return this.allowUndefined;
    }

    @NotNull
    public final FloatFeature copy(@NotNull String name2, double defaultValue, boolean allowUndefined) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return new FloatFeature(name2, defaultValue, allowUndefined);
    }

    public static /* synthetic */ FloatFeature copy$default(FloatFeature floatFeature, String string, double d, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = floatFeature.getName();
        }
        if ((n & 2) != 0) {
            d = floatFeature.defaultValue;
        }
        if ((n & 4) != 0) {
            bl = floatFeature.allowUndefined;
        }
        return floatFeature.copy(string, d, bl);
    }

    @NotNull
    public String toString() {
        return "FloatFeature(name=" + this.getName() + ", defaultValue=" + this.defaultValue + ", allowUndefined=" + this.allowUndefined + ")";
    }

    public int hashCode() {
        String string = this.getName();
        int n = ((string != null ? string.hashCode() : 0) * 31 + Double.hashCode(this.defaultValue)) * 31;
        int n2 = this.allowUndefined ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof FloatFeature)) break block3;
                FloatFeature floatFeature = (FloatFeature)object;
                if (!Intrinsics.areEqual((Object)this.getName(), (Object)floatFeature.getName()) || Double.compare(this.defaultValue, floatFeature.defaultValue) != 0 || this.allowUndefined != floatFeature.allowUndefined) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0015\u0010\t\u001a\u0004\u0018\u00010\u0004*\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/ml/FloatFeature$FloatMapper;", "Lcom/intellij/internal/ml/FeatureMapper;", "(Lcom/intellij/internal/ml/FloatFeature;)V", "asArrayValue", "", "value", "", "getFeatureName", "", "asDouble", "(Ljava/lang/Object;)Ljava/lang/Double;", "intellij.platform.ide.impl"})
    private final class FloatMapper
    implements FeatureMapper {
        @Override
        @NotNull
        public String getFeatureName() {
            return FloatFeature.this.getName();
        }

        @Override
        public double asArrayValue(@Nullable Object value2) {
            Double d = this.asDouble(value2);
            return d != null ? d.doubleValue() : FloatFeature.this.getDefaultValue();
        }

        private final Double asDouble(Object $this$asDouble) {
            if ($this$asDouble instanceof Number) {
                return ((Number)$this$asDouble).doubleValue();
            }
            return StringsKt.toDoubleOrNull((String)String.valueOf($this$asDouble));
        }
    }
}

