/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.performance;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0006\"\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lcom/intellij/internal/performance/LatencyRecord;", "", "()V", "averageLatency", "", "getAverageLatency", "()J", "maxLatency", "", "getMaxLatency", "()I", "setMaxLatency", "(I)V", "samples", "Lit/unimi/dsi/fastutil/ints/IntArrayList;", "getSamples", "()Lit/unimi/dsi/fastutil/ints/IntArrayList;", "samplesSorted", "", "getSamplesSorted", "()Z", "setSamplesSorted", "(Z)V", "totalLatency", "getTotalLatency", "setTotalLatency", "(J)V", "percentile", "n", "update", "", "latencyInMS", "intellij.platform.ide.impl"})
public final class LatencyRecord {
    private long totalLatency;
    private int maxLatency;
    @NotNull
    private final IntArrayList samples = new IntArrayList();
    private boolean samplesSorted;

    public final long getTotalLatency() {
        return this.totalLatency;
    }

    public final void setTotalLatency(long l) {
        this.totalLatency = l;
    }

    public final int getMaxLatency() {
        return this.maxLatency;
    }

    public final void setMaxLatency(int n) {
        this.maxLatency = n;
    }

    @NotNull
    public final IntArrayList getSamples() {
        return this.samples;
    }

    public final boolean getSamplesSorted() {
        return this.samplesSorted;
    }

    public final void setSamplesSorted(boolean bl) {
        this.samplesSorted = bl;
    }

    public final void update(int latencyInMS) {
        this.samplesSorted = false;
        this.samples.add(latencyInMS);
        this.totalLatency += (long)latencyInMS;
        if (latencyInMS > this.maxLatency) {
            this.maxLatency = latencyInMS;
        }
    }

    public final long getAverageLatency() {
        return this.totalLatency / (long)this.samples.size();
    }

    public final int percentile(int n) {
        if (!this.samplesSorted) {
            CollectionsKt.sort((List)((List)this.samples));
            this.samplesSorted = true;
        }
        int index2 = RangesKt.coerceAtMost((int)(this.samples.size() * n / 100), (int)(this.samples.size() - 1));
        return this.samples.getInt(index2);
    }
}

