/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.psiView.stubtree;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.psiView.stubtree.StubViewerPsiBasedTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.Invoker;
import java.awt.Component;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubDetailsViewer {
    private static final boolean DEFAULT_SHOW_STUB_DETAILS = false;
    private static final String PROPERTY_NAME = "StubDetailsViewer.showPreviewDetails";
    @NotNull
    private final StubViewerPsiBasedTree myStubViewerTree;
    @NotNull
    private final Tree myStubDetailsTree;

    public StubDetailsViewer(@NotNull StubViewerPsiBasedTree tree) {
        if (tree == null) {
            StubDetailsViewer.$$$reportNull$$$0(0);
        }
        this.myStubViewerTree = tree;
        this.myStubDetailsTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.myStubDetailsTree.setRootVisible(false);
    }

    public AnAction addComponent(final JBSplitter splitter2) {
        this.updateStubDetailsTreeView(PropertiesComponent.getInstance().getBoolean(PROPERTY_NAME, false), splitter2);
        return new ToggleAction("Show Stub Details", null, AllIcons.Actions.PreviewDetails){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PropertiesComponent.getInstance().getBoolean(StubDetailsViewer.PROPERTY_NAME, false);
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                PropertiesComponent.getInstance().setValue(StubDetailsViewer.PROPERTY_NAME, state, false);
                StubDetailsViewer.this.updateStubDetailsTreeView(state, splitter2);
                if (state) {
                    StubDetailsViewer.this.valueChanged(StubDetailsViewer.this.myStubViewerTree.getSelectedStub());
                    ((AsyncTreeModel)((Object)StubDetailsViewer.this.myStubDetailsTree.getModel())).treeStructureChanged(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/internal/psiView/stubtree/StubDetailsViewer$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void updateStubDetailsTreeView(boolean isShown, JBSplitter splitter2) {
        this.myStubDetailsTree.setEnabled(isShown);
        splitter2.setSecondComponent(isShown ? ScrollPaneFactory.createScrollPane((Component)this.myStubDetailsTree, (boolean)true) : null);
    }

    public void valueChanged(@Nullable StubElement<?> stub) {
        if (this.myStubDetailsTree.isEnabled()) {
            Disposable treeModelDisposable = this.myStubViewerTree.myTreeModelDisposable;
            StructureTreeModel<StubDetailsTreeStructure> model2 = new StructureTreeModel<StubDetailsTreeStructure>(new StubDetailsTreeStructure(stub), null, Invoker.forEventDispatchThread(treeModelDisposable), treeModelDisposable);
            AsyncTreeModel asyncTreeModel = new AsyncTreeModel((TreeModel)((Object)model2), false, treeModelDisposable);
            this.myStubDetailsTree.setModel((TreeModel)((Object)asyncTreeModel));
            this.myStubDetailsTree.expandRow(0);
            this.myStubDetailsTree.treeDidChange();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/internal/psiView/stubtree/StubDetailsViewer", "<init>"));
    }

    private static class StubDetailsRootNode
    extends SimpleNode {
        @NotNull
        private final StubElement<?> myStub;

        private StubDetailsRootNode(@NotNull StubElement<?> stub) {
            if (stub == null) {
                StubDetailsRootNode.$$$reportNull$$$0(0);
            }
            this.myStub = stub;
        }

        public SimpleNode @NotNull [] getChildren() {
            SimpleNode[] simpleNodeArray = (SimpleNode[])ReflectionUtil.collectFields(this.myStub.getClass()).stream().filter(f -> {
                if (Modifier.isStatic(f.getModifiers())) {
                    return false;
                }
                Class<?> aClass = f.getDeclaringClass();
                return !StubBase.class.equals(aClass) && !ObjectStubBase.class.equals(aClass) && !AtomicReference.class.equals(aClass) && (f.canAccess(this.myStub) || f.trySetAccessible());
            }).map(f -> f.getName() + " = " + ReflectionUtil.getFieldValue((Field)f, this.myStub)).sorted().map(s -> new SimpleNode((String)s){
                final /* synthetic */ String val$s;
                {
                    this.val$s = string;
                }

                public SimpleNode @NotNull [] getChildren() {
                    if (NO_CHILDREN == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return NO_CHILDREN;
                }

                public String getName() {
                    return this.val$s;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/psiView/stubtree/StubDetailsViewer$StubDetailsRootNode$1", "getChildren"));
                }
            }).toArray(SimpleNode[]::new);
            if (simpleNodeArray == null) {
                StubDetailsRootNode.$$$reportNull$$$0(1);
            }
            return simpleNodeArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stub";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/psiView/stubtree/StubDetailsViewer$StubDetailsRootNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/psiView/stubtree/StubDetailsViewer$StubDetailsRootNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class StubDetailsTreeStructure
    extends SimpleTreeStructure {
        private final Object myRoot;

        private StubDetailsTreeStructure(@Nullable StubElement<?> root2) {
            this.myRoot = root2 != null ? new StubDetailsRootNode(root2) : new Object();
        }

        @NotNull
        public Object getRootElement() {
            Object object = this.myRoot;
            if (object == null) {
                StubDetailsTreeStructure.$$$reportNull$$$0(0);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/psiView/stubtree/StubDetailsViewer$StubDetailsTreeStructure", "getRootElement"));
        }
    }
}

