/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeymapUsageCollector
extends ApplicationUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("keymaps.name", 2);
    private static final StringEventField KEYMAP_NAME = EventFields.StringValidatedByEnum((String)"keymap_name", (String)"keymaps");
    private static final StringEventField BASED_ON = EventFields.StringValidatedByEnum((String)"based_on", (String)"keymaps");
    private static final VarargEventId KEYMAP = GROUP.registerVarargEvent("ide.keymap", new EventField[]{KEYMAP_NAME, BASED_ON});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        if (keymapManager2 == null) {
            Set<MetricEvent> set2 = Collections.emptySet();
            if (set2 == null) {
                KeymapUsageCollector.$$$reportNull$$$0(0);
            }
            return set2;
        }
        Keymap keymap2 = keymapManager2.getActiveKeymap();
        ArrayList<EventPair> data2 = new ArrayList<EventPair>();
        data2.add(KEYMAP_NAME.with((Object)KeymapUsageCollector.getKeymapName(keymap2)));
        if (keymap2.canModify()) {
            data2.add(BASED_ON.with((Object)KeymapUsageCollector.getKeymapName(keymap2.getParent())));
        }
        Set<MetricEvent> set3 = Collections.singleton(KEYMAP.metric(data2));
        if (set3 == null) {
            KeymapUsageCollector.$$$reportNull$$$0(1);
        }
        return set3;
    }

    @NotNull
    private static String getKeymapName(@Nullable Keymap keymap2) {
        if (keymap2 == null) {
            return "unknown";
        }
        String string = keymap2.canModify() ? "custom" : keymap2.getName();
        if (string == null) {
            KeymapUsageCollector.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/internal/statistic/collectors/fus/KeymapUsageCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeymapName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

