/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.advanced.AdvancedSettingBean;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.options.advanced.AdvancedSettingsImpl;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegistryApplicationUsagesCollector
extends ApplicationUsagesCollector {
    public static final String DISABLE_INTELLIJ_PROJECT_ANALYTICS = "ide.disable.intellij.project.analytics";
    private static final EventLogGroup GROUP = new EventLogGroup("platform.registry", 4);
    private static final StringEventField REGISTRY_KEY = EventFields.StringValidatedByCustomRule((String)"id", (String)"registry_key");
    private static final VarargEventId REGISTRY = GROUP.registerVarargEvent("registry", new EventField[]{REGISTRY_KEY, EventFields.PluginInfo});
    private static final VarargEventId EXPERIMENT = GROUP.registerVarargEvent("experiment", new EventField[]{REGISTRY_KEY, EventFields.PluginInfo});
    private static final VarargEventId ADVANCED_SETTING = GROUP.registerVarargEvent("advanced.setting", new EventField[]{REGISTRY_KEY, EventFields.PluginInfo});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        return RegistryApplicationUsagesCollector.getChangedValuesUsages();
    }

    @NotNull
    static Set<MetricEvent> getChangedValuesUsages() {
        Set registry = Registry.getAll().stream().filter(key -> key.isChangedFromDefault() && !StringUtil.equals((CharSequence)key.getKey(), (CharSequence)DISABLE_INTELLIJ_PROJECT_ANALYTICS)).map(key -> REGISTRY.metric(new EventPair[]{REGISTRY_KEY.with((Object)key.getKey())})).collect(Collectors.toSet());
        Set experiments = Experiments.EP_NAME.extensions().filter(f -> Experiments.getInstance().isFeatureEnabled(f.id)).map(f -> EXPERIMENT.metric(new EventPair[]{REGISTRY_KEY.with((Object)f.id)})).collect(Collectors.toSet());
        Set advancedSettings = AdvancedSettingBean.EP_NAME.extensions().filter(f -> ((AdvancedSettingsImpl)AdvancedSettings.getInstance()).isNonDefault(f.id)).map(f -> ADVANCED_SETTING.metric(new EventPair[]{REGISTRY_KEY.with((Object)f.id)})).collect(Collectors.toSet());
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>(registry);
        result2.addAll(experiments);
        result2.addAll(advancedSettings);
        HashSet<MetricEvent> hashSet = result2;
        if (hashSet == null) {
            RegistryApplicationUsagesCollector.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/collectors/fus/RegistryApplicationUsagesCollector", "getChangedValuesUsages"));
    }

    public static class RegistryUtilValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "registry_key".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context2) {
            ExperimentalFeature feature;
            if (data2 == null) {
                RegistryUtilValidator.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                RegistryUtilValidator.$$$reportNull$$$0(1);
            }
            if ((feature = RegistryUtilValidator.findFeatureById(data2)) != null) {
                PluginInfo info2 = PluginInfoDetectorKt.getPluginInfo(feature.getClass());
                context2.setPayload(PLUGIN_INFO, (Object)info2);
                ValidationResultType validationResultType = info2.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    RegistryUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            for (AdvancedSettingBean extension2 : AdvancedSettingBean.EP_NAME.getExtensionList()) {
                if (!extension2.id.equals(data2)) continue;
                PluginDescriptor descriptor2 = extension2.getPluginDescriptor();
                if (descriptor2 == null) {
                    ValidationResultType validationResultType = ValidationResultType.REJECTED;
                    if (validationResultType == null) {
                        RegistryUtilValidator.$$$reportNull$$$0(3);
                    }
                    return validationResultType;
                }
                PluginInfo info3 = PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)descriptor2);
                context2.setPayload(PLUGIN_INFO, (Object)info3);
                ValidationResultType validationResultType = info3.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    RegistryUtilValidator.$$$reportNull$$$0(4);
                }
                return validationResultType;
            }
            PluginInfo info2 = RegistryUtilValidator.getPluginInfoByRegistry(Registry.get((String)data2));
            context2.setPayload(PLUGIN_INFO, (Object)info2);
            ValidationResultType validationResultType = info2.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            if (validationResultType == null) {
                RegistryUtilValidator.$$$reportNull$$$0(5);
            }
            return validationResultType;
        }

        @NotNull
        private static PluginInfo getPluginInfoByRegistry(@NotNull RegistryValue value2) {
            String pluginId;
            if (value2 == null) {
                RegistryUtilValidator.$$$reportNull$$$0(6);
            }
            PluginInfo pluginInfo = (pluginId = value2.getPluginId()) != null ? PluginInfoDetectorKt.getPluginInfoById((PluginId)PluginId.getId((String)pluginId)) : PluginInfoDetectorKt.getPlatformPlugin();
            if (pluginInfo == null) {
                RegistryUtilValidator.$$$reportNull$$$0(7);
            }
            return pluginInfo;
        }

        @Nullable
        private static ExperimentalFeature findFeatureById(@NotNull String featureId) {
            if (featureId == null) {
                RegistryUtilValidator.$$$reportNull$$$0(8);
            }
            for (ExperimentalFeature feature : Experiments.EP_NAME.getExtensionList()) {
                if (!Objects.equals(feature.id, featureId)) continue;
                return feature;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/RegistryApplicationUsagesCollector$RegistryUtilValidator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "featureId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/RegistryApplicationUsagesCollector$RegistryUtilValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPluginInfoByRegistry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getPluginInfoByRegistry";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findFeatureById";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

