/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageCounterCollector;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class FileTypeUsageService {
    private final Map<String, Long> myStartOpenTime = new ConcurrentHashMap<String, Long>();

    public static FileTypeUsageService getInstance(@NotNull Project project) {
        if (project == null) {
            FileTypeUsageService.$$$reportNull$$$0(0);
        }
        return (FileTypeUsageService)project.getService(FileTypeUsageService.class);
    }

    private void addStartOpenTime(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeUsageService.$$$reportNull$$$0(1);
        }
        this.myStartOpenTime.put(FileTypeUsageService.getKey(file2), System.nanoTime());
    }

    @Nullable
    private Long getAndRemoveStartOpenTime(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeUsageService.$$$reportNull$$$0(2);
        }
        return this.myStartOpenTime.remove(FileTypeUsageService.getKey(file2));
    }

    @NotNull
    private static String getKey(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeUsageService.$$$reportNull$$$0(3);
        }
        String string = file2.getUrl();
        if (string == null) {
            FileTypeUsageService.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addStartOpenTime";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAndRemoveStartOpenTime";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            FileTypeUsageService service;
            if (source == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(1);
            }
            Long startOpen = (service = FileTypeUsageService.getInstance(source.getProject())) != null ? service.getAndRemoveStartOpenTime(file2) : null;
            FileTypeUsageCounterCollector.triggerOpen(source.getProject(), source, file2, startOpen);
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            if (source == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(3);
            }
            FileTypeUsageCounterCollector.triggerClosed(source.getProject(), file2);
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (event == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(4);
            }
            FileTypeUsageCounterCollector.triggerSelect(event.getManager().getProject(), event.getNewFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageService$MyFileEditorManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileOpened";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileClosed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyBeforeFileEditorManagerListener
    implements FileEditorManagerListener.Before {
        public void beforeFileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            FileTypeUsageService service;
            if (source == null) {
                MyBeforeFileEditorManagerListener.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                MyBeforeFileEditorManagerListener.$$$reportNull$$$0(1);
            }
            if ((service = FileTypeUsageService.getInstance(source.getProject())) != null) {
                service.addStartOpenTime(file2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageService$MyBeforeFileEditorManagerListener";
            objectArray[2] = "beforeFileOpened";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

