/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.fileTypes;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.fileTypes.FileTypeStatisticProvider;
import com.intellij.internal.statistic.fileTypes.UpdateComponentWatcherKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/internal/statistic/fileTypes/UpdateComponentWatcher;", "Lcom/intellij/openapi/Disposable;", "()V", "dispose", "", "scheduleUpdate", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.ide.impl"})
final class UpdateComponentWatcher
implements Disposable {
    public final void scheduleUpdate(@NotNull Editor editor2) {
        String pluginVersion;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        VirtualFile virtualFile2 = ((EditorEx)editor2).getVirtualFile();
        if (virtualFile2 == null || (virtualFile2 = virtualFile2.getFileType()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"(editor as EditorEx).vir\u2026lFile?.fileType ?: return");
        VirtualFile fileType = virtualFile2;
        FileTypeStatisticProvider fileTypeStatisticProvider = (FileTypeStatisticProvider)UpdateComponentWatcherKt.access$getEP_NAME$p().findFirstSafe(new Predicate(editor2, (FileType)fileType){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ FileType $fileType;

            public final boolean test(FileTypeStatisticProvider it) {
                return it.accept(this.$editor, this.$fileType);
            }
            {
                this.$editor = editor2;
                this.$fileType = fileType;
            }
        });
        if (fileTypeStatisticProvider == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)fileTypeStatisticProvider, (String)"EP_NAME.findFirstSafe { \u2026or, fileType) } ?: return");
        FileTypeStatisticProvider ep2 = fileTypeStatisticProvider;
        Object object = UpdateComponentWatcherKt.access$getEP_NAME$p().computeIfAbsent((Object)ep2, UpdateComponentWatcher.class, new Function(ep2){
            final /* synthetic */ FileTypeStatisticProvider $ep;

            @NotNull
            public final Optional<IdeaPluginDescriptor> apply(@NotNull FileTypeStatisticProvider it) {
                return Optional.ofNullable(PluginManagerCore.getPlugin(PluginId.getId((String)this.$ep.getPluginId())));
            }
            {
                this.$ep = fileTypeStatisticProvider;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"EP_NAME.computeIfAbsent(\u2026etId(ep.pluginId)))\n    }");
        Optional plugin2 = (Optional)object;
        String string = ep2.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ep.pluginId");
        String pluginIdString = string;
        if (!plugin2.isPresent()) {
            UpdateComponentWatcherKt.access$getLOG$p().error("Unknown plugin id: " + pluginIdString + " is reported by " + ep2.getClass());
            return;
        }
        Object t = plugin2.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"plugin.get()");
        String string2 = pluginVersion = ((IdeaPluginDescriptor)t).getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pluginVersion");
        if (UpdateComponentWatcherKt.access$checkUpdateRequired(pluginIdString, string2)) {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(pluginIdString, pluginVersion){
                final /* synthetic */ String $pluginIdString;
                final /* synthetic */ String $pluginVersion;

                public final void run() {
                    String string = this.$pluginVersion;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginVersion");
                    UpdateComponentWatcherKt.access$update(this.$pluginIdString, string);
                }
                {
                    this.$pluginIdString = string;
                    this.$pluginVersion = string2;
                }
            });
        }
    }

    public void dispose() {
    }

    public UpdateComponentWatcher() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
        EditorEventMulticaster editorEventMulticaster = editorFactory.getEventMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"EditorFactory.getInstance().eventMulticaster");
        EditorEventMulticaster multicaster = editorEventMulticaster;
        if (multicaster instanceof EditorEventMulticasterEx) {
            ((EditorEventMulticasterEx)multicaster).addFocusChangeListener(new FocusChangeListener(){

                @Override
                public void focusGained(@NotNull Editor editor2) {
                    Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                    this.scheduleUpdate(editor2);
                }
            }, this);
        }
    }
}

