/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLanguage;
import com.intellij.json.JsonLexer;
import com.intellij.json.JsonParser;
import com.intellij.json.psi.impl.JsonFileImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JsonParserDefinition
implements ParserDefinition {
    public static final TokenSet WHITE_SPACES = TokenSet.WHITE_SPACE;
    public static final TokenSet STRING_LITERALS = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.SINGLE_QUOTED_STRING, JsonElementTypes.DOUBLE_QUOTED_STRING});
    public static final IFileElementType FILE = new IFileElementType((Language)JsonLanguage.INSTANCE);
    public static final TokenSet JSON_BRACES = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.L_CURLY, JsonElementTypes.R_CURLY});
    public static final TokenSet JSON_BRACKETS = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.L_BRACKET, JsonElementTypes.R_BRACKET});
    public static final TokenSet JSON_CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.OBJECT, JsonElementTypes.ARRAY});
    public static final TokenSet JSON_BOOLEANS = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.TRUE, JsonElementTypes.FALSE});
    public static final TokenSet JSON_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.TRUE, JsonElementTypes.FALSE, JsonElementTypes.NULL});
    public static final TokenSet JSON_LITERALS = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.STRING_LITERAL, JsonElementTypes.NUMBER_LITERAL, JsonElementTypes.NULL_LITERAL, JsonElementTypes.TRUE, JsonElementTypes.FALSE});
    public static final TokenSet JSON_VALUES = TokenSet.orSet((TokenSet[])new TokenSet[]{JSON_CONTAINERS, JSON_LITERALS});
    public static final TokenSet JSON_COMMENTARIES = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.BLOCK_COMMENT, JsonElementTypes.LINE_COMMENT});

    @NotNull
    public Lexer createLexer(Project project) {
        return new JsonLexer();
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new JsonParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        IFileElementType iFileElementType = FILE;
        if (iFileElementType == null) {
            JsonParserDefinition.$$$reportNull$$$0(0);
        }
        return iFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = WHITE_SPACES;
        if (tokenSet == null) {
            JsonParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = JSON_COMMENTARIES;
        if (tokenSet == null) {
            JsonParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = STRING_LITERALS;
        if (tokenSet == null) {
            JsonParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode astNode) {
        PsiElement psiElement = JsonElementTypes.Factory.createElement(astNode);
        if (psiElement == null) {
            JsonParserDefinition.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider fileViewProvider) {
        if (fileViewProvider == null) {
            JsonParserDefinition.$$$reportNull$$$0(5);
        }
        return new JsonFileImpl(fileViewProvider, JsonLanguage.INSTANCE);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode astNode, ASTNode astNode2) {
        ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
        if (spaceRequirements == null) {
            JsonParserDefinition.$$$reportNull$$$0(6);
        }
        return spaceRequirements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/JsonParserDefinition";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileViewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/JsonParserDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceExistenceTypeBetweenTokens";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

