/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.pointer;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonPointerResolver {
    private final JsonValue myRoot;
    private final String myPointer;

    public JsonPointerResolver(@NotNull JsonValue root2, @NotNull String pointer) {
        if (root2 == null) {
            JsonPointerResolver.$$$reportNull$$$0(0);
        }
        if (pointer == null) {
            JsonPointerResolver.$$$reportNull$$$0(1);
        }
        this.myRoot = root2;
        this.myPointer = pointer;
    }

    @Nullable
    public JsonValue resolve() {
        JsonValue root2 = this.myRoot;
        List<JsonPointerPosition.Step> steps2 = JsonPointerPosition.parsePointer(this.myPointer).getSteps();
        for (JsonPointerPosition.Step step2 : steps2) {
            String name2 = step2.getName();
            if (name2 != null) {
                if (!(root2 instanceof JsonObject)) {
                    return null;
                }
                JsonProperty property2 = ((JsonObject)root2).findProperty(name2);
                root2 = property2 == null ? null : property2.getValue();
                continue;
            }
            int idx = step2.getIdx();
            if (idx < 0) {
                return null;
            }
            if (!(root2 instanceof JsonArray)) {
                if (root2 instanceof JsonObject) {
                    JsonProperty property3 = ((JsonObject)root2).findProperty(String.valueOf(idx));
                    if (property3 == null) {
                        return null;
                    }
                    root2 = property3.getValue();
                    continue;
                }
                return null;
            }
            List<JsonValue> list2 = ((JsonArray)root2).getValueList();
            if (idx >= list2.size()) {
                return null;
            }
            root2 = list2.get(idx);
        }
        return root2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "root";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "pointer";
                break;
            }
        }
        objectArray[1] = "com/intellij/json/pointer/JsonPointerResolver";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

