/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi.impl;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public abstract class JSStringLiteralEscaper<T extends PsiLanguageInjectionHost>
extends LiteralTextEscaper<T> {
    private int[] outSourceOffsets;

    public JSStringLiteralEscaper(T host) {
        super(host);
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            JSStringLiteralEscaper.$$$reportNull$$$0(0);
        }
        if (outChars == null) {
            JSStringLiteralEscaper.$$$reportNull$$$0(1);
        }
        String subText = rangeInsideHost.substring(this.myHost.getText());
        Ref sourceOffsetsRef = new Ref();
        boolean result2 = JSStringLiteralEscaper.parseStringCharacters(subText, outChars, (Ref<int[]>)sourceOffsetsRef, this.isRegExpLiteral(), !this.isOneLine());
        this.outSourceOffsets = (int[])sourceOffsetsRef.get();
        return result2;
    }

    protected abstract boolean isRegExpLiteral();

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        int result2;
        if (rangeInsideHost == null) {
            JSStringLiteralEscaper.$$$reportNull$$$0(2);
        }
        int n = result2 = offsetInDecoded < this.outSourceOffsets.length ? this.outSourceOffsets[offsetInDecoded] : -1;
        if (result2 == -1) {
            return -1;
        }
        return Math.min(result2, rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    public boolean isOneLine() {
        return true;
    }

    public static boolean parseStringCharacters(String chars, StringBuilder outChars, Ref<int[]> sourceOffsetsRef, boolean regExp, boolean escapeBacktick) {
        if (chars.indexOf(92) < 0) {
            outChars.append(chars);
            sourceOffsetsRef.set((Object)IntStream.range(0, chars.length() + 1).toArray());
            return true;
        }
        int[] sourceOffsets = new int[chars.length() + 1];
        int index2 = 0;
        int outOffset = outChars.length();
        boolean result2 = true;
        block21: while (index2 < chars.length()) {
            char c = chars.charAt(index2++);
            sourceOffsets[outChars.length() - outOffset] = index2 - 1;
            sourceOffsets[outChars.length() + 1 - outOffset] = index2;
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index2 == chars.length()) {
                result2 = false;
                break;
            }
            c = chars.charAt(index2++);
            if (escapeBacktick && c == '`') {
                outChars.append(c);
            } else if (regExp) {
                if (c != '/') {
                    outChars.append('\\');
                }
                outChars.append(c);
            } else {
                switch (c) {
                    case 'b': {
                        outChars.append('\b');
                        break;
                    }
                    case 't': {
                        outChars.append('\t');
                        break;
                    }
                    case 'n': {
                        outChars.append('\n');
                        break;
                    }
                    case 'f': {
                        outChars.append('\f');
                        break;
                    }
                    case 'r': {
                        outChars.append('\r');
                        break;
                    }
                    case '\"': {
                        outChars.append('\"');
                        break;
                    }
                    case '/': {
                        outChars.append('/');
                        break;
                    }
                    case '\n': {
                        outChars.append('\n');
                        break;
                    }
                    case '\'': {
                        outChars.append('\'');
                        break;
                    }
                    case '\\': {
                        outChars.append('\\');
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char startC = c;
                        int v2 = c - 48;
                        if (index2 < chars.length()) {
                            if ('0' <= (c = chars.charAt(index2++)) && c <= '7') {
                                v2 <<= 3;
                                v2 += c - 48;
                                if (startC <= '3' && index2 < chars.length()) {
                                    if ('0' <= (c = chars.charAt(index2++)) && c <= '7') {
                                        v2 <<= 3;
                                        v2 += c - 48;
                                    }
                                }
                            } else {
                                --index2;
                            }
                        }
                        outChars.append((char)v2);
                        break;
                    }
                    case 'x': {
                        int v;
                        if (index2 + 2 <= chars.length()) {
                            try {
                                v = Integer.parseInt(chars.substring(index2, index2 + 2), 16);
                                outChars.append((char)v);
                                index2 += 2;
                                break;
                            }
                            catch (Exception e) {
                                result2 = false;
                                break block21;
                            }
                        }
                        result2 = false;
                        break block21;
                    }
                    case 'u': {
                        int v;
                        int v2;
                        if (index2 + 3 <= chars.length() && chars.charAt(index2) == '{') {
                            int end = chars.indexOf(125, index2 + 1);
                            if (end < 0) {
                                result2 = false;
                                break block21;
                            }
                            try {
                                v2 = Integer.parseInt(chars.substring(index2 + 1, end), 16);
                                c = chars.charAt(index2 + 1);
                                if (c == '+' || c == '-') {
                                    result2 = false;
                                    break block21;
                                }
                                outChars.appendCodePoint(v2);
                                index2 = end + 1;
                                break;
                            }
                            catch (Exception e) {
                                result2 = false;
                                break block21;
                            }
                        }
                        if (index2 + 4 <= chars.length()) {
                            try {
                                v = Integer.parseInt(chars.substring(index2, index2 + 4), 16);
                                c = chars.charAt(index2);
                                if (c == '+' || c == '-') {
                                    result2 = false;
                                    break block21;
                                }
                                outChars.append((char)v);
                                index2 += 4;
                                break;
                            }
                            catch (Exception e) {
                                result2 = false;
                                break block21;
                            }
                        }
                        result2 = false;
                        break block21;
                    }
                    default: {
                        outChars.append(c);
                    }
                }
            }
            sourceOffsets[outChars.length() - outOffset] = --index2;
        }
        sourceOffsets[outChars.length() - outOffset] = chars.length();
        sourceOffsetsRef.set((Object)Arrays.copyOf(sourceOffsets, outChars.length() - outOffset + 1));
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/psi/impl/JSStringLiteralEscaper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "decode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getOffsetInHost";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

