/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.surroundWith;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.json.surroundWith.JsonWithArrayLiteralSurrounder;
import com.intellij.json.surroundWith.JsonWithObjectLiteralSurrounder;
import com.intellij.json.surroundWith.JsonWithQuotesSurrounder;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JsonSurroundDescriptor
implements SurroundDescriptor {
    private static final Surrounder[] ourSurrounders = new Surrounder[]{new JsonWithObjectLiteralSurrounder(), new JsonWithArrayLiteralSurrounder(), new JsonWithQuotesSurrounder()};

    public PsiElement @NotNull [] getElementsToSurround(PsiFile file2, int startOffset, int endOffset) {
        JsonProperty property2;
        PsiElement firstElement;
        PsiElement lastElement = file2.findElementAt(endOffset - 1);
        for (firstElement = file2.findElementAt(startOffset); firstElement != null && (firstElement instanceof PsiWhiteSpace || firstElement.getNode().getElementType() == JsonElementTypes.COMMA); firstElement = firstElement.getNextSibling()) {
        }
        while (lastElement != null && (lastElement instanceof PsiWhiteSpace || lastElement.getNode().getElementType() == JsonElementTypes.COMMA)) {
            lastElement = lastElement.getPrevSibling();
        }
        if (firstElement != null) {
            startOffset = firstElement.getTextRange().getStartOffset();
        }
        if (lastElement != null) {
            endOffset = lastElement.getTextRange().getEndOffset();
        }
        if ((property2 = (JsonProperty)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)startOffset, (int)endOffset, JsonProperty.class)) != null) {
            return JsonSurroundDescriptor.collectElements(endOffset, property2, JsonProperty.class);
        }
        JsonValue value2 = (JsonValue)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)startOffset, (int)endOffset, JsonValue.class);
        if (value2 != null) {
            return JsonSurroundDescriptor.collectElements(endOffset, value2, JsonValue.class);
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            JsonSurroundDescriptor.$$$reportNull$$$0(0);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static <T extends PsiElement> PsiElement @NotNull [] collectElements(int endOffset, @NotNull T property2, @NotNull Class<T> kind) {
        if (property2 == null) {
            JsonSurroundDescriptor.$$$reportNull$$$0(1);
        }
        if (kind == null) {
            JsonSurroundDescriptor.$$$reportNull$$$0(2);
        }
        ArrayList properties2 = ContainerUtil.newArrayList((Object[])new PsiElement[]{property2});
        for (PsiElement nextSibling = property2.getNextSibling(); nextSibling != null && nextSibling.getTextRange().getEndOffset() <= endOffset; nextSibling = nextSibling.getNextSibling()) {
            if (!kind.isInstance(nextSibling)) continue;
            properties2.add((PsiElement)kind.cast(nextSibling));
        }
        PsiElement[] psiElementArray = properties2.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            JsonSurroundDescriptor.$$$reportNull$$$0(3);
        }
        return psiElementArray;
    }

    public Surrounder @NotNull [] getSurrounders() {
        if (ourSurrounders == null) {
            JsonSurroundDescriptor.$$$reportNull$$$0(4);
        }
        return ourSurrounders;
    }

    public boolean isExclusive() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/surroundWith/JsonSurroundDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToSurround";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/surroundWith/JsonSurroundDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurrounders";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

