/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath;

import com.intellij.jsonpath.psi.JsonPathId;
import com.intellij.jsonpath.psi.JsonPathIdSegment;
import com.intellij.jsonpath.psi.JsonPathStringLiteral;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JsonPathSpellcheckerStrategy
extends SpellcheckingStrategy {
    private final Tokenizer<JsonPathStringLiteral> ourStringLiteralTokenizer = new Tokenizer<JsonPathStringLiteral>(){

        @Override
        public void tokenize(@NotNull JsonPathStringLiteral element2, TokenConsumer consumer2) {
            if (element2 == null) {
                1.$$$reportNull$$$0(0);
            }
            PlainTextSplitter textSplitter = PlainTextSplitter.getInstance();
            if (element2.textContains('\\')) {
                List<Pair<TextRange, String>> fragments = element2.getTextFragments();
                for (Pair<TextRange, String> fragment2 : fragments) {
                    TextRange fragmentRange = (TextRange)fragment2.getFirst();
                    String escaped = (String)fragment2.getSecond();
                    if (escaped.length() != fragmentRange.getLength() || escaped.startsWith("\\")) continue;
                    consumer2.consumeToken(element2, escaped, false, fragmentRange.getStartOffset(), TextRange.allOf((String)escaped), textSplitter);
                }
            } else {
                consumer2.consumeToken(element2, textSplitter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsonpath/JsonPathSpellcheckerStrategy$1", "tokenize"));
        }
    };
    private final Tokenizer<JsonPathId> idLiteralTokenizer = new Tokenizer<JsonPathId>(){

        @Override
        public void tokenize(@NotNull JsonPathId element2, TokenConsumer consumer2) {
            if (element2 == null) {
                2.$$$reportNull$$$0(0);
            }
            PlainTextSplitter textSplitter = PlainTextSplitter.getInstance();
            consumer2.consumeToken(element2, textSplitter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsonpath/JsonPathSpellcheckerStrategy$2", "tokenize"));
        }
    };

    @Override
    @NotNull
    public Tokenizer getTokenizer(PsiElement element2) {
        if (element2 instanceof JsonPathStringLiteral) {
            Tokenizer<JsonPathStringLiteral> tokenizer = this.ourStringLiteralTokenizer;
            if (tokenizer == null) {
                JsonPathSpellcheckerStrategy.$$$reportNull$$$0(0);
            }
            return tokenizer;
        }
        if (element2 instanceof JsonPathId && element2.getParent() instanceof JsonPathIdSegment) {
            Tokenizer<JsonPathId> tokenizer = this.idLiteralTokenizer;
            if (tokenizer == null) {
                JsonPathSpellcheckerStrategy.$$$reportNull$$$0(1);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element2);
        if (tokenizer == null) {
            JsonPathSpellcheckerStrategy.$$$reportNull$$$0(2);
        }
        return tokenizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsonpath/JsonPathSpellcheckerStrategy", "getTokenizer"));
    }
}

