/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.JsonBundle;
import com.intellij.jsonpath.JsonPathConstants;
import com.intellij.jsonpath.psi.JsonPathFunctionCall;
import com.intellij.jsonpath.psi.JsonPathId;
import com.intellij.jsonpath.psi.JsonPathVisitor;
import com.intellij.jsonpath.ui.JsonPathEvaluateManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class JsonPathUnknownFunctionInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JsonPathUnknownFunctionInspection.$$$reportNull$$$0(0);
        }
        return new JsonPathVisitor(){

            @Override
            public void visitFunctionCall(@NotNull JsonPathFunctionCall call) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitFunctionCall(call);
                JsonPathId functionId = call.getId();
                String functionName = functionId.getText();
                if (!JsonPathConstants.STANDARD_FUNCTIONS.containsKey(functionName)) {
                    boolean isEvaluateExpr = Boolean.TRUE.equals(holder.getFile().getUserData(JsonPathEvaluateManager.JSON_PATH_EVALUATE_EXPRESSION_KEY));
                    if (isEvaluateExpr) {
                        holder.registerProblem((PsiElement)functionId, JsonBundle.message("inspection.message.jsonpath.unsupported.jayway.function", functionName), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
                    } else {
                        holder.registerProblem((PsiElement)functionId, null, JsonBundle.message("inspection.message.jsonpath.unknown.function.name", functionName), new LocalQuickFix[0]);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/jsonpath/inspections/JsonPathUnknownFunctionInspection$1", "visitFunctionCall"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/jsonpath/inspections/JsonPathUnknownFunctionInspection", "buildVisitor"));
    }
}

