/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class SmartEnterProcessorWithFixers
extends SmartEnterProcessor {
    protected static final Logger LOG = Logger.getInstance(SmartEnterProcessorWithFixers.class);
    protected static final int MAX_ATTEMPTS = 20;
    protected static final Key<Long> SMART_ENTER_TIMESTAMP = Key.create((String)"smartEnterOriginalTimestamp");
    protected int myFirstErrorOffset = Integer.MAX_VALUE;
    protected int myAttempt = 0;
    private final List<Fixer<? extends SmartEnterProcessorWithFixers>> myFixers = new ArrayList<Fixer<? extends SmartEnterProcessorWithFixers>>();
    protected final List<FixEnterProcessor> myEnterProcessors = new ArrayList<FixEnterProcessor>();
    private final List<FixEnterProcessor> myAfterEnterProcessors = new ArrayList<FixEnterProcessor>();

    protected static void plainEnter(@NotNull Editor editor2) {
        if (editor2 == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(0);
        }
        SmartEnterProcessorWithFixers.getEnterHandler().execute(editor2, editor2.getCaretModel().getCurrentCaret(), EditorUtil.getEditorDataContext(editor2));
    }

    protected static EditorActionHandler getEnterHandler() {
        return EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
    }

    protected static boolean isModified(@NotNull Editor editor2) {
        if (editor2 == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(1);
        }
        Long timestamp = (Long)editor2.getUserData(SMART_ENTER_TIMESTAMP);
        assert (timestamp != null);
        return editor2.getDocument().getModificationStamp() != timestamp.longValue();
    }

    public boolean doNotStepInto(PsiElement element2) {
        return false;
    }

    public boolean process(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        if (project == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(3);
        }
        if (psiFile == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(4);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.complete.statement");
        return this.invokeProcessor(project, editor2, psiFile, false);
    }

    public boolean processAfterCompletion(@NotNull Editor editor2, @NotNull PsiFile psiFile) {
        if (editor2 == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(5);
        }
        if (psiFile == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(6);
        }
        return this.invokeProcessor(psiFile.getProject(), editor2, psiFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokeProcessor(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile, boolean afterCompletion) {
        if (project == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(7);
        }
        if (editor2 == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(8);
        }
        if (psiFile == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(9);
        }
        Document document = editor2.getDocument();
        CharSequence textForRollback = document.getImmutableCharSequence();
        try {
            editor2.putUserData(SMART_ENTER_TIMESTAMP, (Object)editor2.getDocument().getModificationStamp());
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            this.process(project, editor2, psiFile, 0, afterCompletion);
        }
        catch (TooManyAttemptsException e) {
            document.replaceString(0, document.getTextLength(), textForRollback);
        }
        finally {
            editor2.putUserData(SMART_ENTER_TIMESTAMP, null);
        }
        return true;
    }

    protected void process(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2, int attempt, boolean afterCompletion) throws TooManyAttemptsException {
        if (project == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(10);
        }
        if (editor2 == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(12);
        }
        if (attempt > 20) {
            throw new TooManyAttemptsException();
        }
        this.myAttempt = attempt;
        try {
            this.commit(editor2);
            if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
                editor2.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            }
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            PsiElement atCaret = this.getStatementAtCaret(editor2, file2);
            if (atCaret == null) {
                this.processDefaultEnter(project, editor2, file2);
                return;
            }
            OrderedSet queue2 = new OrderedSet();
            this.collectAllElements(atCaret, (OrderedSet<PsiElement>)queue2, this.collectChildrenRecursively(atCaret));
            queue2.add((Object)atCaret);
            for (PsiElement psiElement : queue2) {
                for (Fixer<? extends SmartEnterProcessorWithFixers> fixer : this.myFixers) {
                    fixer.apply(editor2, this, psiElement);
                    if (LookupManager.getInstance(project).getActiveLookup() != null) {
                        return;
                    }
                    if (!SmartEnterProcessorWithFixers.isUncommited((Project)project) && psiElement.isValid()) continue;
                    this.moveCaretInsideBracesIfAny(editor2, file2);
                    this.process(project, editor2, file2, attempt + 1, afterCompletion);
                    return;
                }
            }
            this.doEnter(atCaret, file2, editor2, afterCompletion);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    protected boolean collectChildrenRecursively(@NotNull PsiElement atCaret) {
        if (atCaret == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(13);
        }
        return true;
    }

    protected void processDefaultEnter(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(14);
        }
        if (editor2 == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(16);
        }
    }

    protected void collectAllElements(@NotNull PsiElement element2, @NotNull OrderedSet<PsiElement> result2, boolean recursive) {
        if (element2 == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(17);
        }
        if (result2 == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(18);
        }
        result2.add(0, (Object)element2);
        if (this.doNotStepInto(element2)) {
            if (!recursive) {
                return;
            }
            recursive = false;
        }
        this.collectAdditionalElements(element2, (List<PsiElement>)result2);
        for (PsiElement child2 : element2.getChildren()) {
            this.collectAllElements(child2, result2, recursive);
        }
    }

    protected void doEnter(@NotNull PsiElement atCaret, @NotNull PsiFile psiFile, @NotNull Editor editor2, boolean afterCompletion) throws IncorrectOperationException {
        if (atCaret == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(19);
        }
        if (psiFile == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(20);
        }
        if (editor2 == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(21);
        }
        if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
            editor2.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            this.reformat(atCaret);
            return;
        }
        RangeMarker rangeMarker = this.createRangeMarker(atCaret);
        if (this.reformatBeforeEnter(atCaret)) {
            this.reformat(atCaret);
        }
        this.commit(editor2);
        PsiElement actualAtCaret = this.restoreElementAtCaret(psiFile, atCaret, rangeMarker);
        int endOffset = rangeMarker.getEndOffset();
        rangeMarker.dispose();
        if (actualAtCaret != null) {
            for (FixEnterProcessor enterProcessor : this.myEnterProcessors) {
                if (!enterProcessor.doEnter(actualAtCaret, psiFile, editor2, SmartEnterProcessorWithFixers.isModified(editor2))) continue;
                return;
            }
        }
        if (!SmartEnterProcessorWithFixers.isModified(editor2) && !afterCompletion) {
            if (actualAtCaret != null) {
                SmartEnterProcessorWithFixers.plainEnter(editor2);
            }
        } else {
            editor2.getCaretModel().moveToOffset(this.myFirstErrorOffset == Integer.MAX_VALUE ? (actualAtCaret != null ? actualAtCaret.getTextRange().getEndOffset() : endOffset) : this.myFirstErrorOffset);
        }
    }

    protected PsiElement restoreElementAtCaret(PsiFile file2, PsiElement origElement, RangeMarker marker) {
        if (!origElement.isValid()) {
            LOG.warn("Please, override com.intellij.lang.SmartEnterProcessorWithFixers.restoreElementAtCaret for your language!");
        }
        return origElement;
    }

    protected boolean reformatBeforeEnter(@NotNull PsiElement atCaret) {
        if (atCaret == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(22);
        }
        return true;
    }

    protected void addEnterProcessors(FixEnterProcessor ... processors) {
        ContainerUtil.addAllNotNull(this.myEnterProcessors, (Object[])processors);
    }

    protected void addAfterEnterProcessors(FixEnterProcessor ... processors) {
        ContainerUtil.addAllNotNull(this.myAfterEnterProcessors, (Object[])processors);
    }

    @SafeVarargs
    protected final void addFixers(Fixer<? extends SmartEnterProcessorWithFixers> ... fixers) {
        if (fixers == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(23);
        }
        ContainerUtil.addAllNotNull(this.myFixers, (Object[])fixers);
    }

    protected void collectAdditionalElements(@NotNull PsiElement element2, @NotNull List<PsiElement> result2) {
        if (element2 == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(24);
        }
        if (result2 == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(25);
        }
    }

    protected void moveCaretInsideBracesIfAny(@NotNull Editor editor2, @NotNull PsiFile file2) throws IncorrectOperationException {
        if (editor2 == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(26);
        }
        if (file2 == null) {
            SmartEnterProcessorWithFixers.$$$reportNull$$$0(27);
        }
    }

    public void registerUnresolvedError(int offset) {
        if (this.myFirstErrorOffset > offset) {
            this.myFirstErrorOffset = offset;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 12: 
            case 16: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "atCaret";
                break;
            }
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixers";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/SmartEnterProcessorWithFixers";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "plainEnter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processAfterCompletion";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeProcessor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "collectChildrenRecursively";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "processDefaultEnter";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "collectAllElements";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "doEnter";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatBeforeEnter";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "addFixers";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "collectAdditionalElements";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "moveCaretInsideBracesIfAny";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class FixEnterProcessor {
        public abstract boolean doEnter(PsiElement var1, PsiFile var2, @NotNull Editor var3, boolean var4);

        protected void plainEnter(@NotNull Editor editor2) {
            if (editor2 == null) {
                FixEnterProcessor.$$$reportNull$$$0(0);
            }
            SmartEnterProcessorWithFixers.plainEnter(editor2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers$FixEnterProcessor", "plainEnter"));
        }
    }

    public static abstract class Fixer<P extends SmartEnterProcessorWithFixers> {
        public abstract void apply(@NotNull Editor var1, @NotNull P var2, @NotNull PsiElement var3) throws IncorrectOperationException;
    }

    public static class TooManyAttemptsException
    extends Exception {
    }
}

