/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation.ide.ui;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationHintEditorPane;
import com.intellij.codeInsight.documentation.DocumentationHtmlEditorKit;
import com.intellij.codeInsight.documentation.DocumentationHtmlFactory;
import com.intellij.codeInsight.documentation.DocumentationLinkHandler;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.DocumentationScrollPane;
import com.intellij.codeInsight.documentation.FontSizeMouseWheelListener;
import com.intellij.ide.DataManager;
import com.intellij.lang.documentation.DocumentationData;
import com.intellij.lang.documentation.DocumentationImageResolver;
import com.intellij.lang.documentation.ide.actions.ActionsKt;
import com.intellij.lang.documentation.ide.impl.BrowserStateListener;
import com.intellij.lang.documentation.ide.impl.DocumentationBrowser;
import com.intellij.lang.documentation.ide.ui.ScrollingPosition;
import com.intellij.lang.documentation.ide.ui.UiKt;
import com.intellij.lang.documentation.impl.DocumentationRequest;
import com.intellij.navigation.TargetPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.PopupHandler;
import com.intellij.util.SmartList;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.EditorKit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010 \u001a\u00020\u00022\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u001a\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J \u0010'\u001a\u00020\r2\u0006\u0010#\u001a\u00020$2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010&0)H\u0002J\b\u0010*\u001a\u00020\rH\u0016J\b\u0010+\u001a\u00020\rH\u0002J\b\u0010,\u001a\u00020\rH\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u000200H\u0016J\u000e\u00101\u001a\u00020\u00022\u0006\u00102\u001a\u000203J\u0015\u00104\u001a\u00020\r2\u000b\u00105\u001a\u000700\u00a2\u0006\u0002\b6H\u0002J\u0010\u00107\u001a\f\u0012\u0004\u0012\u00020\r0\fj\u0002`8J\u001b\u00109\u001a\u00020\r2\u000b\u0010:\u001a\u000700\u00a2\u0006\u0002\b62\u0006\u0010;\u001a\u00020<R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006="}, d2={"Lcom/intellij/lang/documentation/ide/ui/DocumentationUI;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "browser", "Lcom/intellij/lang/documentation/ide/impl/DocumentationBrowser;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/documentation/ide/impl/DocumentationBrowser;)V", "getBrowser", "()Lcom/intellij/lang/documentation/ide/impl/DocumentationBrowser;", "contentListeners", "", "Lkotlin/Function0;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "editorPane", "Lcom/intellij/codeInsight/documentation/DocumentationHintEditorPane;", "getEditorPane", "()Lcom/intellij/codeInsight/documentation/DocumentationHintEditorPane;", "htmlFactory", "Lcom/intellij/codeInsight/documentation/DocumentationHtmlFactory;", "getHtmlFactory", "()Lcom/intellij/codeInsight/documentation/DocumentationHtmlFactory;", "imageResolver", "Lcom/intellij/lang/documentation/DocumentationImageResolver;", "linkHandler", "Lcom/intellij/codeInsight/documentation/DocumentationLinkHandler;", "scrollPane", "Ljavax/swing/JScrollPane;", "getScrollPane", "()Ljavax/swing/JScrollPane;", "addContentListener", "listener", "applyState", "request", "Lcom/intellij/lang/documentation/impl/DocumentationRequest;", "data", "Lcom/intellij/lang/documentation/DocumentationData;", "applyStateLater", "asyncData", "Lkotlinx/coroutines/Deferred;", "dispose", "fetchingProgress", "fireContentChanged", "getData", "", "dataId", "", "setBackground", "color", "Ljava/awt/Color;", "showMessage", "message", "Lorg/jetbrains/annotations/Nls;", "uiSnapshot", "Lcom/intellij/lang/documentation/ide/ui/UISnapshot;", "update", "text", "scrollingPosition", "Lcom/intellij/lang/documentation/ide/ui/ScrollingPosition;", "intellij.platform.lang.impl"})
public final class DocumentationUI
implements DataProvider,
Disposable {
    @NotNull
    private final JScrollPane scrollPane;
    @NotNull
    private final DocumentationHintEditorPane editorPane;
    private DocumentationImageResolver imageResolver;
    private final DocumentationLinkHandler linkHandler;
    private final CoroutineScope cs;
    private final List<Function0<Unit>> contentListeners;
    @NotNull
    private final DocumentationBrowser browser;

    @NotNull
    public final JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @NotNull
    public final DocumentationHintEditorPane getEditorPane() {
        return this.editorPane;
    }

    private final DocumentationHtmlFactory getHtmlFactory() {
        EditorKit editorKit = this.editorPane.getEditorKit();
        if (editorKit == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.codeInsight.documentation.DocumentationHtmlEditorKit");
        }
        DocumentationHtmlFactory documentationHtmlFactory = ((DocumentationHtmlEditorKit)((Object)editorKit)).getViewFactory();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)documentationHtmlFactory), (String)"(editorPane.editorKit as\u2026tmlEditorKit).viewFactory");
        return documentationHtmlFactory;
    }

    public void dispose() {
        this.getHtmlFactory().clearIcons();
        this.imageResolver = null;
        CoroutineScopeKt.cancel$default((CoroutineScope)this.cs, null, (int)1, null);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (ActionsKt.DOCUMENTATION_BROWSER.is(dataId)) {
            object = this.browser;
        } else if (DocumentationManager.SELECTED_QUICK_DOC_TEXT.is(dataId)) {
            String string = this.editorPane.getSelectedText();
            object = string != null ? StringsKt.replace$default((String)string, (char)((char)160), (char)' ', (boolean)false, (int)4, null) : null;
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public final Disposable setBackground(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Color editorBG = this.editorPane.getBackground();
        this.editorPane.setBackground(color);
        return new Disposable(this, editorBG){
            final /* synthetic */ DocumentationUI this$0;
            final /* synthetic */ Color $editorBG;

            public final void dispose() {
                this.this$0.getEditorPane().setBackground(this.$editorBG);
            }
            {
                this.this$0 = documentationUI;
                this.$editorBG = color;
            }
        };
    }

    @NotNull
    public final Disposable addContentListener(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        EDT.assertIsEdt();
        this.contentListeners.add(listener2);
        return new Disposable(this, listener2){
            final /* synthetic */ DocumentationUI this$0;
            final /* synthetic */ Function0 $listener;

            public final void dispose() {
                EDT.assertIsEdt();
                DocumentationUI.access$getContentListeners$p(this.this$0).remove(this.$listener);
            }
            {
                this.this$0 = documentationUI;
                this.$listener = function0;
            }
        };
    }

    private final void fireContentChanged() {
        for (Function0<Unit> listener2 : this.contentListeners) {
            listener2.invoke();
        }
    }

    private final void applyStateLater(DocumentationRequest request2, Deferred<DocumentationData> asyncData) {
        Job fetchingMessage2 = BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DocumentationUI this$0;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay((long)300L, (Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        DocumentationUI.access$fetchingProgress(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = documentationUI;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        asyncData.invokeOnCompletion((Function1)new Function1<Throwable, Unit>(fetchingMessage2){
            final /* synthetic */ Job $fetchingMessage;

            public final void invoke(@Nullable Throwable it) {
                Job.DefaultImpls.cancel$default((Job)this.$fetchingMessage, null, (int)1, null);
            }
            {
                this.$fetchingMessage = job2;
                super(1);
            }
        });
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, asyncData, request2, null){
            int label;
            final /* synthetic */ DocumentationUI this$0;
            final /* synthetic */ Deferred $asyncData;
            final /* synthetic */ DocumentationRequest $request;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.$asyncData.await((Continuation)this);
                        ** if (v0 != var5_2) goto lbl11
lbl10:
                        // 1 sources

                        return var5_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            var3_3 = (DocumentationData)v0;
                        }
                        catch (IndexNotReadyException e) {
                            var3_3 = null;
                        }
                        data = var3_3;
                        DocumentationUI.access$applyState(this.this$0, this.$request, data);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = documentationUI;
                this.$asyncData = deferred2;
                this.$request = documentationRequest;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void applyState(DocumentationRequest request2, DocumentationData data2) {
        ScrollingPosition scrollingPosition;
        Icon icon2;
        TargetPresentation presentation2;
        block7: {
            block5: {
                String locationText;
                block6: {
                    this.getHtmlFactory().clearIcons();
                    this.imageResolver = null;
                    if (data2 == null) {
                        String string = CodeInsightBundle.message((String)"no.documentation.found", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CodeInsightBundle.messag\u2026\"no.documentation.found\")");
                        this.showMessage(string);
                        return;
                    }
                    this.imageResolver = data2.getImageResolver();
                    presentation2 = request2.getPresentation();
                    String string = presentation2.getLocationText();
                    if (string == null) break block5;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    locationText = string2;
                    boolean bl3 = false;
                    icon2 = presentation2.getLocationIcon();
                    if (icon2 == null) break block6;
                    Icon icon3 = icon2;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Icon locationIcon = icon3;
                    boolean bl6 = false;
                    String string3 = this.getHtmlFactory().registerIcon(locationIcon);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"htmlFactory.registerIcon(locationIcon)");
                    String iconKey = string3;
                    icon2 = HtmlChunk.fragment((HtmlChunk[])new HtmlChunk[]{(HtmlChunk)HtmlChunk.tag((String)"icon").attr("src", iconKey), HtmlChunk.nbsp(), HtmlChunk.text((String)locationText)});
                    if (icon2 != null) break block7;
                }
                icon2 = HtmlChunk.text((String)locationText);
                break block7;
            }
            icon2 = null;
        }
        Icon locationChunk = icon2;
        HtmlChunk linkChunk = UiKt.linkChunk(presentation2.getPresentableText(), data2);
        String decorated = DocumentationManager.decorate(data2.getHtml(), (HtmlChunk)locationChunk, linkChunk);
        String string = data2.getAnchor();
        if (string != null) {
            String string4 = string;
            boolean bl = false;
            boolean bl7 = false;
            String p1 = string4;
            boolean bl8 = false;
            scrollingPosition = new ScrollingPosition.Anchor(p1);
        } else {
            scrollingPosition = ScrollingPosition.Reset.INSTANCE;
        }
        ScrollingPosition scrollingPosition2 = scrollingPosition;
        String string5 = decorated;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"decorated");
        this.update(string5, scrollingPosition2);
    }

    private final void fetchingProgress() {
        String string = CodeInsightBundle.message((String)"javadoc.fetching.progress", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CodeInsightBundle.messag\u2026vadoc.fetching.progress\")");
        this.showMessage(string);
    }

    private final void showMessage(String message2) {
        HtmlChunk.Element element2 = HtmlChunk.div().setClass("content-only").addText(message2).wrapWith("body").wrapWith("html");
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"HtmlChunk.div()\n      .s\u2026)\n      .wrapWith(\"html\")");
        HtmlChunk.Element element3 = element2;
        String string = element3.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.toString()");
        this.update(string, ScrollingPosition.Reset.INSTANCE);
    }

    public final void update(@NotNull String text2, @NotNull ScrollingPosition scrollingPosition) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)scrollingPosition, (String)"scrollingPosition");
        EDT.assertIsEdt();
        if (Intrinsics.areEqual((Object)this.editorPane.getText(), (Object)text2)) {
            return;
        }
        this.editorPane.setText(text2);
        this.fireContentChanged();
        SwingUtilities.invokeLater(new Runnable(this, scrollingPosition){
            final /* synthetic */ DocumentationUI this$0;
            final /* synthetic */ ScrollingPosition $scrollingPosition;

            public final void run() {
                block0: {
                    ScrollingPosition scrollingPosition;
                    block1: {
                        scrollingPosition = this.$scrollingPosition;
                        if (Intrinsics.areEqual((Object)scrollingPosition, (Object)ScrollingPosition.Keep.INSTANCE)) break block0;
                        if (!Intrinsics.areEqual((Object)scrollingPosition, (Object)ScrollingPosition.Reset.INSTANCE)) break block1;
                        this.this$0.getEditorPane().scrollRectToVisible(new Rectangle(0, 0));
                        if (!ScreenReader.isActive()) break block0;
                        this.this$0.getEditorPane().setCaretPosition(0);
                        break block0;
                    }
                    if (!(scrollingPosition instanceof ScrollingPosition.Anchor)) break block0;
                    UIUtil.scrollToReference((JEditorPane)this.this$0.getEditorPane(), (String)((ScrollingPosition.Anchor)this.$scrollingPosition).getAnchor());
                }
            }
            {
                this.this$0 = documentationUI;
                this.$scrollingPosition = scrollingPosition;
            }
        });
    }

    @NotNull
    public final Function0<Unit> uiSnapshot() {
        JViewport jViewport = this.scrollPane.getViewport();
        Intrinsics.checkNotNullExpressionValue((Object)jViewport, (String)"scrollPane.viewport");
        Rectangle viewRect = jViewport.getViewRect();
        int highlightedLink = this.linkHandler.getHighlightedLink();
        return (Function0)new Function0<Unit>(this, highlightedLink, viewRect){
            final /* synthetic */ DocumentationUI this$0;
            final /* synthetic */ int $highlightedLink;
            final /* synthetic */ Rectangle $viewRect;

            public final void invoke() {
                DocumentationUI.access$getLinkHandler$p(this.this$0).highlightLink(this.$highlightedLink);
                this.this$0.getEditorPane().scrollRectToVisible(this.$viewRect);
                if (ScreenReader.isActive()) {
                    this.this$0.getEditorPane().setCaretPosition(0);
                }
            }
            {
                this.this$0 = documentationUI;
                this.$highlightedLink = n;
                this.$viewRect = rectangle;
                super(0);
            }
        };
    }

    @NotNull
    public final DocumentationBrowser getBrowser() {
        return this.browser;
    }

    public DocumentationUI(@NotNull Project project, @NotNull DocumentationBrowser browser2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)browser2, (String)"browser");
        this.browser = browser2;
        this.cs = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)CoroutinesKt.getEDT(Dispatchers.INSTANCE)));
        this.contentListeners = (List)new SmartList();
        this.scrollPane = (JScrollPane)((Object)new DocumentationScrollPane());
        this.editorPane = new DocumentationHintEditorPane(project, DocumentationScrollPane.keyboardActions(this.scrollPane), new DocumentationImageResolver(){

            @Override
            @Nullable
            public final Image resolveImage(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DocumentationImageResolver documentationImageResolver = imageResolver;
                return documentationImageResolver != null ? documentationImageResolver.resolveImage(it) : null;
            }
        });
        this.editorPane.applyFontProps(DocumentationComponent.getQuickDocFontSize());
        this.scrollPane.setViewportView(this.editorPane);
        Function1 function1 = (Function1)new Function1<FontSize, Unit>(this.editorPane){

            public final void invoke(@NotNull FontSize p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((DocumentationHintEditorPane)this.receiver).applyFontProps(p1);
            }
        };
        this.scrollPane.addMouseWheelListener(new FontSizeMouseWheelListener(new Consumer(function1){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            public final /* synthetic */ void accept(Object p0) {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
            }
        }));
        Function1 function12 = (Function1)new Function1<String, Unit>(this.browser){

            public final void invoke(@NotNull String p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((DocumentationBrowser)this.receiver).navigateByLink(p1);
            }
        };
        DocumentationLinkHandler documentationLinkHandler = DocumentationLinkHandler.createAndRegister(this.editorPane, this, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)documentationLinkHandler, (String)"DocumentationLinkHandler\u2026 browser::navigateByLink)");
        this.linkHandler = documentationLinkHandler;
        this.browser.setUi(this);
        Disposer.register((Disposable)this, (Disposable)this.browser);
        Disposer.register((Disposable)this, (Disposable)this.browser.addStateListener(new BrowserStateListener(){

            @Override
            public final void stateChanged(@NotNull DocumentationRequest request2, @NotNull Deferred<DocumentationData> result2, boolean $noName_2) {
                Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                Intrinsics.checkNotNullParameter(result2, (String)"result");
                this.applyStateLater(request2, (Deferred<DocumentationData>)result2);
            }
        }));
        for (AnAction anAction2 : this.linkHandler.createLinkActions()) {
            anAction2.registerCustomShortcutSet((JComponent)this.editorPane, (Disposable)this);
        }
        ActionsKt.registerBackForwardActions(this.editorPane);
        PopupHandler popupHandler2 = PopupHandler.installPopupMenu((JComponent)this.editorPane, (String)"Documentation.PrimaryGroup", (String)"documentation.pane.content.menu");
        Intrinsics.checkNotNullExpressionValue((Object)popupHandler2, (String)"PopupHandler.installPopu\u2026.pane.content.menu\"\n    )");
        final PopupHandler popupHandler3 = popupHandler2;
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public final void dispose() {
                this.getEditorPane().removeMouseListener((MouseListener)popupHandler3);
            }
        });
        DataManager.registerDataProvider((JComponent)this.editorPane, (DataProvider)this);
        this.fetchingProgress();
    }

    public static final /* synthetic */ List access$getContentListeners$p(DocumentationUI $this) {
        return $this.contentListeners;
    }

    public static final /* synthetic */ void access$fetchingProgress(DocumentationUI $this) {
        $this.fetchingProgress();
    }

    public static final /* synthetic */ void access$applyState(DocumentationUI $this, DocumentationRequest request2, DocumentationData data2) {
        $this.applyState(request2, data2);
    }

    public static final /* synthetic */ DocumentationLinkHandler access$getLinkHandler$p(DocumentationUI $this) {
        return $this.linkHandler;
    }

    public static final /* synthetic */ void access$setImageResolver$p(DocumentationUI $this, DocumentationImageResolver documentationImageResolver) {
        $this.imageResolver = documentationImageResolver;
    }
}

