/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation.ide.ui;

import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a:\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a*\u0010\f\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\b\u0010\u0011\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"drawMultiLineSelection", "", "bounds", "Ljava/awt/Shape;", "rec0", "Ljava/awt/Rectangle;", "rec1", "g2d", "Ljava/awt/Graphics2D;", "backgroundColor", "Ljava/awt/Color;", "borderColor", "drawRectangle", "target", "getBackgroundColor", "current", "", "getBorderColor", "intellij.platform.lang.impl"})
public final class SearchHighlighterPainterKt {
    private static final void drawRectangle(Graphics2D g2d, Rectangle target2, Color backgroundColor, Color borderColor) {
        if (backgroundColor != null) {
            g2d.setColor(backgroundColor);
            g2d.fillRect(target2.x, target2.y, target2.width, target2.height - 1);
        }
        g2d.setColor(borderColor);
        g2d.drawRect(target2.x, target2.y, target2.width, target2.height - 1);
    }

    private static final void drawMultiLineSelection(Shape bounds2, Rectangle rec0, Rectangle rec1, Graphics2D g2d, Color backgroundColor, Color borderColor) {
        boolean multiline;
        Rectangle area = bounds2.getBounds();
        int rec0ToMarginWidth = area.x + area.width - rec0.x;
        int secondLineY = rec0.y + rec0.height;
        Rectangle firstLineRectangle = new Rectangle(rec0.x, rec0.y, rec0ToMarginWidth, rec0.height);
        Rectangle lastLineRectangle = new Rectangle(area.x, rec1.y, rec1.x - area.x, rec1.height);
        SearchHighlighterPainterKt.drawRectangle(g2d, firstLineRectangle, backgroundColor, borderColor);
        boolean bl = multiline = secondLineY != rec1.y;
        if (multiline) {
            SearchHighlighterPainterKt.drawRectangle(g2d, new Rectangle(area.x, secondLineY, area.width, rec1.y - secondLineY), backgroundColor, borderColor);
            g2d.setColor(backgroundColor);
            g2d.fillRect(firstLineRectangle.x, firstLineRectangle.y + firstLineRectangle.height - 2, firstLineRectangle.width - 1, 5);
        }
        SearchHighlighterPainterKt.drawRectangle(g2d, lastLineRectangle, backgroundColor, borderColor);
        g2d.setColor(backgroundColor);
        if (multiline) {
            g2d.fillRect(lastLineRectangle.x + 1, lastLineRectangle.y - 2, lastLineRectangle.width - 1, 5);
        } else {
            int lastMaxX = lastLineRectangle.x + lastLineRectangle.width;
            if (firstLineRectangle.x + 1 <= lastMaxX - 1) {
                g2d.fillRect(firstLineRectangle.x + 1, lastLineRectangle.y - 2, lastMaxX - firstLineRectangle.x - 1, 5);
            }
        }
    }

    private static final Color getBackgroundColor(boolean current2) {
        Color color;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        EditorColorsScheme globalScheme = editorColorsScheme;
        if (current2) {
            if (ColorUtil.isDark((Color)globalScheme.getDefaultBackground())) {
                EditorColorsManager editorColorsManager2 = EditorColorsManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager2, (String)"EditorColorsManager.getInstance()");
                color = editorColorsManager2.getGlobalScheme().getColor(EditorColors.SELECTION_BACKGROUND_COLOR);
            } else {
                TextAttributes textAttributes = globalScheme.getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
                Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"globalScheme.getAttribut\u2026SEARCH_RESULT_ATTRIBUTES)");
                color = textAttributes.getBackgroundColor();
            }
        } else {
            TextAttributes textAttributes = globalScheme.getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"globalScheme.getAttribut\u2026SEARCH_RESULT_ATTRIBUTES)");
            color = textAttributes.getBackgroundColor();
        }
        return color;
    }

    private static final Color getBorderColor() {
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        Color color = editorColorsScheme.getDefaultForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"EditorColorsManager.getI\u2026lScheme.defaultForeground");
        return color;
    }

    public static final /* synthetic */ Color access$getBorderColor() {
        return SearchHighlighterPainterKt.getBorderColor();
    }

    public static final /* synthetic */ Color access$getBackgroundColor(boolean current2) {
        return SearchHighlighterPainterKt.getBackgroundColor(current2);
    }

    public static final /* synthetic */ void access$drawRectangle(Graphics2D g2d, Rectangle target2, Color backgroundColor, Color borderColor) {
        SearchHighlighterPainterKt.drawRectangle(g2d, target2, backgroundColor, borderColor);
    }

    public static final /* synthetic */ void access$drawMultiLineSelection(Shape bounds2, Rectangle rec0, Rectangle rec1, Graphics2D g2d, Color backgroundColor, Color borderColor) {
        SearchHighlighterPainterKt.drawMultiLineSelection(bounds2, rec0, rec1, g2d, backgroundColor, borderColor);
    }
}

