/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.html.structureView.Html5SectionTreeElement;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.SortedList;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Html5SectionsProcessor {
    private static final String[] SECTIONING_ROOT_ELEMENTS = new String[]{"blockquote", "body", "details", "fieldset", "figure", "td"};
    private static final String[] SECTIONING_CONTENT_ELEMENTS = new String[]{"article", "aside", "nav", "section"};
    private static final String[] HEADER_ELEMENTS = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
    private static final String HGROUP_ELEMENT = "hgroup";
    private final Collection<SectionHolder> myRootSectionHolders = new SortedList(Comparator.comparingInt(holder -> holder.getTag().getTextRange().getStartOffset()));
    private SectionHolder myCurrentOutlinee = null;
    private Section myCurrentSection = null;
    private final Stack<SectionHolder> myStack = new Stack();

    Html5SectionsProcessor() {
    }

    public static Collection<Html5SectionTreeElement> processAndGetRootSections(XmlTag rootTag) {
        Html5SectionsProcessor processor2 = new Html5SectionsProcessor();
        Html5SectionsProcessor.processRecursively(rootTag, processor2);
        return processor2.getRootSections();
    }

    private static void processRecursively(XmlTag tag2, Html5SectionsProcessor processor2) {
        if (tag2.getAttribute("hidden") != null) {
            return;
        }
        processor2.tagEntered(tag2);
        if (!Html5SectionsProcessor.isHeader(tag2)) {
            for (XmlTag subTag : tag2.getSubTags()) {
                Html5SectionsProcessor.processRecursively(subTag, processor2);
            }
        }
        processor2.tagExited(tag2);
    }

    private void tagEntered(XmlTag tag2) {
        if (Html5SectionsProcessor.isSectioningContentElement(tag2) || Html5SectionsProcessor.isSectioningRootElement(tag2)) {
            if (this.myCurrentOutlinee != null) {
                this.myStack.push((Object)this.myCurrentOutlinee);
            }
            this.myCurrentOutlinee = new SectionHolder(tag2);
            this.myCurrentSection = new Section(tag2);
            this.myCurrentOutlinee.addChildSection(this.myCurrentSection);
        } else if (this.myCurrentOutlinee != null && Html5SectionsProcessor.isHeader(tag2)) {
            if (this.myCurrentSection.getHeader() == null) {
                this.myCurrentSection.setHeader(tag2);
            } else if (this.myCurrentOutlinee.getChildren().getLast().getHeader() == null || Html5SectionsProcessor.compareHeaderRanks(tag2, this.myCurrentOutlinee.getChildren().getLast().getHeader()) >= 0) {
                this.myCurrentSection = new Section(tag2);
                this.myCurrentSection.setHeader(tag2);
                this.myCurrentOutlinee.addChildSection(this.myCurrentSection);
            } else {
                Section candidateSection = this.myCurrentSection;
                while (true) {
                    if (Html5SectionsProcessor.compareHeaderRanks(tag2, candidateSection.getHeader()) < 0) {
                        this.myCurrentSection = new Section(tag2);
                        this.myCurrentSection.setHeader(tag2);
                        candidateSection.addChildSection(this.myCurrentSection);
                        break;
                    }
                    candidateSection = candidateSection.getParent();
                }
            }
        }
    }

    private void tagExited(XmlTag tag2) {
        if (!this.myStack.isEmpty() && ((SectionHolder)this.myStack.peek()).getTag() == tag2) {
            assert (false);
        } else if (this.myStack.isEmpty() || !Html5SectionsProcessor.isHeader(tag2)) {
            if (!this.myStack.isEmpty() && Html5SectionsProcessor.isSectioningContentElement(tag2)) {
                SectionHolder exitedSectioningContent = this.myCurrentOutlinee;
                assert (exitedSectioningContent.getTag() == tag2);
                this.myCurrentOutlinee = (SectionHolder)this.myStack.pop();
                this.myCurrentSection = this.myCurrentOutlinee.getChildren().getLast();
                for (Section section : exitedSectioningContent.getChildren()) {
                    this.myCurrentSection.addChildSection(section);
                }
            } else if (!this.myStack.isEmpty() && Html5SectionsProcessor.isSectioningRootElement(tag2)) {
                SectionHolder exitedSectioningRoot = this.myCurrentOutlinee;
                assert (exitedSectioningRoot.getTag() == tag2);
                this.myRootSectionHolders.add(exitedSectioningRoot);
                this.myCurrentOutlinee = (SectionHolder)this.myStack.pop();
                this.myCurrentSection = this.myCurrentOutlinee.getChildren().getLast();
                while (!this.myCurrentSection.getChildren().isEmpty()) {
                    this.myCurrentSection = this.myCurrentSection.getChildren().getLast();
                }
            } else if (Html5SectionsProcessor.isSectioningContentElement(tag2) || Html5SectionsProcessor.isSectioningRootElement(tag2)) {
                assert (this.myStack.isEmpty());
                assert (this.myCurrentOutlinee.getTag() == tag2);
                this.myRootSectionHolders.add(this.myCurrentOutlinee);
                this.myCurrentOutlinee = null;
                this.myCurrentSection = null;
            }
        }
    }

    private Collection<Html5SectionTreeElement> getRootSections() {
        ArrayList<Html5SectionTreeElement> result2 = new ArrayList<Html5SectionTreeElement>();
        for (SectionHolder sectionHolder : this.myRootSectionHolders) {
            for (Section section : sectionHolder.getChildren()) {
                if ("td".equalsIgnoreCase(section.getTag().getName()) && section.getHeader() == null && section.getChildren().isEmpty()) continue;
                result2.add(Html5SectionsProcessor.createHtml5SectionTreeElement(section));
            }
        }
        return result2;
    }

    private static Html5SectionTreeElement createHtml5SectionTreeElement(Section section) {
        return new Html5SectionTreeElement(section.getTag(), Html5SectionsProcessor.createChildrenComputable(section.getChildren()), Html5SectionsProcessor.getHeaderText(section.getHeader()));
    }

    private static Computable<Collection<StructureViewTreeElement>> createChildrenComputable(Collection<Section> children2) {
        return () -> {
            ArrayList<Html5SectionTreeElement> result2 = new ArrayList<Html5SectionTreeElement>();
            for (Section section : children2) {
                result2.add(Html5SectionsProcessor.createHtml5SectionTreeElement(section));
            }
            return result2;
        };
    }

    private static String getHeaderText(@Nullable XmlTag header2) {
        if (header2 == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (HGROUP_ELEMENT.equalsIgnoreCase(header2.getLocalName())) {
            for (XmlTag subTag : header2.getSubTags()) {
                if (!ArrayUtil.contains((String)StringUtil.toLowerCase((String)subTag.getLocalName()), (String[])HEADER_ELEMENTS)) continue;
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                Html5SectionsProcessor.appendTextRecursively(subTag, buf, 100);
            }
        } else {
            Html5SectionsProcessor.appendTextRecursively(header2, buf, 100);
        }
        return buf.toString();
    }

    private static void appendTextRecursively(XmlTag tag2, StringBuilder buf, int maximumTextLength) {
        if (buf.length() >= maximumTextLength) {
            return;
        }
        String text2 = tag2.getValue().getTrimmedText();
        if (!text2.isEmpty()) {
            buf.append(text2);
        } else {
            for (XmlTag subTag : tag2.getSubTags()) {
                Html5SectionsProcessor.appendTextRecursively(subTag, buf, maximumTextLength);
            }
        }
    }

    private static boolean isSectioningRootElement(XmlTag tag2) {
        return ArrayUtil.contains((String)StringUtil.toLowerCase((String)tag2.getLocalName()), (String[])SECTIONING_ROOT_ELEMENTS);
    }

    private static boolean isSectioningContentElement(XmlTag tag2) {
        return ArrayUtil.contains((String)StringUtil.toLowerCase((String)tag2.getLocalName()), (String[])SECTIONING_CONTENT_ELEMENTS);
    }

    private static boolean isHeader(XmlTag tag2) {
        return ArrayUtil.contains((String)StringUtil.toLowerCase((String)tag2.getLocalName()), (String[])HEADER_ELEMENTS) || HGROUP_ELEMENT.equalsIgnoreCase(tag2.getLocalName());
    }

    private static int compareHeaderRanks(@NotNull XmlTag header1, @NotNull XmlTag header2) {
        if (header1 == null) {
            Html5SectionsProcessor.$$$reportNull$$$0(0);
        }
        if (header2 == null) {
            Html5SectionsProcessor.$$$reportNull$$$0(1);
        }
        return Html5SectionsProcessor.getHeaderRank(header2) - Html5SectionsProcessor.getHeaderRank(header1);
    }

    private static int getHeaderRank(XmlTag header2) {
        if (HGROUP_ELEMENT.equalsIgnoreCase(header2.getLocalName())) {
            XmlTag subTag;
            int index2;
            int minIndex = HEADER_ELEMENTS.length;
            XmlTag[] xmlTagArray = header2.getSubTags();
            int n = xmlTagArray.length;
            for (int j = 0; j < n && ((index2 = ArrayUtilRt.indexOf((Object[])HEADER_ELEMENTS, (Object)StringUtil.toLowerCase((String)(subTag = xmlTagArray[j]).getLocalName()), (int)0, (int)HEADER_ELEMENTS.length)) >= minIndex || (minIndex = index2) != 0); ++j) {
            }
            if (minIndex == HEADER_ELEMENTS.length) {
                minIndex = 0;
            }
            return minIndex + 1;
        }
        int index3 = ArrayUtilRt.indexOf((Object[])HEADER_ELEMENTS, (Object)StringUtil.toLowerCase((String)header2.getLocalName()), (int)0, (int)HEADER_ELEMENTS.length);
        if (index3 < 0) {
            throw new IllegalArgumentException(header2.getName());
        }
        return index3 + 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "header1";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "header2";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/html/structureView/Html5SectionsProcessor";
        objectArray[2] = "compareHeaderRanks";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Section
    extends SectionHolder {
        private Section myParent = null;
        private XmlTag myHeader = null;

        Section(XmlTag tag2) {
            super(tag2);
        }

        @Override
        public void addChildSection(Section section) {
            section.myParent = this;
            super.addChildSection(section);
        }

        public XmlTag getHeader() {
            return this.myHeader;
        }

        public void setHeader(XmlTag header2) {
            this.myHeader = header2;
        }

        public Section getParent() {
            return this.myParent;
        }
    }

    private static class SectionHolder {
        private final XmlTag myTag;
        private final LinkedList<Section> myChildren = new LinkedList();

        private SectionHolder(XmlTag tag2) {
            this.myTag = tag2;
        }

        public void addChildSection(Section section) {
            this.myChildren.add(section);
        }

        public LinkedList<Section> getChildren() {
            return this.myChildren;
        }

        public XmlTag getTag() {
            return this.myTag;
        }
    }
}

