/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.impl.ComponentEventHandler;
import com.intellij.notification.impl.NotificationComponent;
import com.intellij.notification.impl.NotificationGroupComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.Alarm;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000q\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\u0015\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000fJ\u0006\u0010$\u001a\u00020\u000bJ\b\u0010%\u001a\u00020\u000bH\u0002J\u0006\u0010&\u001a\u00020\u000bJ\b\u0010'\u001a\u00020\u000bH\u0002J\b\u0010(\u001a\u00020\u0005H\u0016J\b\u0010)\u001a\u00020\u0005H\u0016J\u0010\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,H\u0014J\u000e\u0010-\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000fJ \u0010.\u001a\u00020\u000b2\u0018\u0010/\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u000b0\rJ\b\u00100\u001a\u00020\u000bH\u0002J\b\u00101\u001a\u00020\u000bH\u0002R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u000b0\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u001dj\b\u0012\u0004\u0012\u00020\u001e`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/notification/impl/NotificationGroupComponent;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/ui/NullableComponent;", "myMainPanel", "mySuggestionType", "", "myProject", "Lcom/intellij/openapi/project/Project;", "(Ljavax/swing/JPanel;ZLcom/intellij/openapi/project/Project;)V", "myClearAllVisibleCallback", "Lkotlin/Function0;", "", "myClearCallback", "Lkotlin/Function1;", "", "Lcom/intellij/notification/Notification;", "myEventHandler", "Lcom/intellij/notification/impl/ComponentEventHandler;", "myList", "myMouseInside", "myScrollPane", "com/intellij/notification/impl/NotificationGroupComponent$myScrollPane$1", "Lcom/intellij/notification/impl/NotificationGroupComponent$myScrollPane$1;", "myScrollValue", "", "mySuggestionGotItPanel", "myTimeAlarm", "Lcom/intellij/util/Alarm;", "myTimeComponents", "Ljava/util/ArrayList;", "Ljavax/swing/JLabel;", "Lkotlin/collections/ArrayList;", "myTitle", "Lcom/intellij/ui/components/JBLabel;", "add", "notification", "clear", "clearAll", "clearNewState", "fullRepaint", "isNull", "isVisible", "paintComponent", "g", "Ljava/awt/Graphics;", "remove", "setClearCallback", "callback", "updateContent", "updateLayout", "intellij.platform.ide.impl"})
final class NotificationGroupComponent
extends JPanel
implements NullableComponent {
    private final JBLabel myTitle;
    private final JPanel myList;
    private final myScrollPane.1 myScrollPane;
    private int myScrollValue;
    private boolean myMouseInside;
    private final Function0<Unit> myClearAllVisibleCallback;
    private final ComponentEventHandler myEventHandler;
    private final ArrayList<JLabel> myTimeComponents;
    private final Alarm myTimeAlarm;
    private final JPanel mySuggestionGotItPanel;
    private Function1<? super List<? extends Notification>, Unit> myClearCallback;
    private final JPanel myMainPanel;
    private final boolean mySuggestionType;
    private final Project myProject;

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        if (this.myScrollValue > 0) {
            g.setColor(JBColor.border());
            int y = this.myScrollPane.getY() - 1;
            g.drawLine(0, y, this.getWidth(), y);
        }
    }

    public final void add(@NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        NotificationComponent component2 = new NotificationComponent(notification, this.myTimeComponents);
        component2.setNew(true);
        this.myList.add((Component)component2, 0);
        this.updateLayout();
        this.myEventHandler.add(component2);
        if (this.mySuggestionType && !PropertiesComponent.getInstance().getBoolean("notification.suggestion.dont.show.gotit")) {
            PropertiesComponent.getInstance().setValue("notification.suggestion.dont.show.gotit", true);
            this.mySuggestionGotItPanel.setVisible(true);
            this.myTitle.setVisible(false);
        }
        this.updateContent();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateLayout() {
        LayoutManager layout = this.myList.getLayout();
        int count = this.myList.getComponentCount();
        int n = 0;
        int n2 = count;
        while (n < n2) {
            void i2;
            Component component2 = this.myList.getComponent((int)i2);
            layout.removeLayoutComponent(component2);
            layout.addLayoutComponent(null, component2);
            ++i2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void remove(@NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        int count = this.myList.getComponentCount();
        int n = 0;
        int n2 = count;
        while (n < n2) {
            void i2;
            Component component2 = this.myList.getComponent((int)i2);
            if (component2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.notification.impl.NotificationComponent");
            }
            NotificationComponent component3 = (NotificationComponent)component2;
            if (component3.getNotification() == notification) {
                this.myList.remove((int)i2);
                break;
            }
            ++i2;
        }
        this.updateContent();
    }

    public final void setClearCallback(@NotNull Function1<? super List<? extends Notification>, Unit> callback2) {
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        this.myClearCallback = callback2;
    }

    /*
     * WARNING - void declaration
     */
    private final void clearAll() {
        IdeFrame ideFrame;
        IdeFrame ideFrame2 = ideFrame = WindowManager.getInstance().getIdeFrame(this.myProject);
        Intrinsics.checkNotNull((Object)ideFrame2);
        BalloonLayout balloonLayout = ideFrame2.getBalloonLayout();
        if (balloonLayout == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.BalloonLayoutImpl");
        }
        BalloonLayoutImpl balloonLayout2 = (BalloonLayoutImpl)balloonLayout;
        balloonLayout2.closeAll();
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        int count = this.myList.getComponentCount();
        int n = 0;
        int n2 = count;
        while (n < n2) {
            void i2;
            Component component2 = this.myList.getComponent((int)i2);
            if (component2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.notification.impl.NotificationComponent");
            }
            NotificationComponent component3 = (NotificationComponent)component2;
            notifications.add(component3.getNotification());
            ++i2;
        }
        this.clear();
        Function1<? super List<? extends Notification>, Unit> function1 = this.myClearCallback;
        if (function1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myClearCallback");
        }
        function1.invoke(notifications);
    }

    public final void clear() {
        this.myList.removeAll();
        this.updateContent();
    }

    /*
     * WARNING - void declaration
     */
    public final void clearNewState() {
        int count = this.myList.getComponentCount();
        int n = 0;
        int n2 = count;
        while (n < n2) {
            void i2;
            Component component2 = this.myList.getComponent((int)i2);
            if (component2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.notification.impl.NotificationComponent");
            }
            NotificationComponent component3 = (NotificationComponent)component2;
            component3.setNew(false);
            ++i2;
        }
    }

    private final void updateContent() {
        Function0<Unit> function0 = this.myClearAllVisibleCallback;
        if (function0 != null) {
            Unit cfr_ignored_0 = (Unit)function0.invoke();
        }
        if (!this.mySuggestionType) {
            this.myTimeAlarm.cancelAllRequests();
            new Runnable(this){
                final /* synthetic */ NotificationGroupComponent this$0;

                public void run() {
                    Iterator<E> iterator2 = NotificationGroupComponent.access$getMyTimeComponents$p(this.this$0).iterator();
                    while (iterator2.hasNext()) {
                        JLabel timeComponent;
                        JLabel jLabel = timeComponent = (JLabel)iterator2.next();
                        Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"timeComponent");
                        Object object = timeComponent.getClientProperty("TimestampKey");
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        jLabel.setText(DateFormatUtil.formatPrettyDateTime((long)((Long)object)));
                    }
                    Collection collection = NotificationGroupComponent.access$getMyTimeComponents$p(this.this$0);
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        NotificationGroupComponent.access$getMyTimeAlarm$p(this.this$0).addRequest((Runnable)this, 30000);
                    }
                }
                {
                    this.this$0 = this$0;
                }
            }.run();
        }
        this.fullRepaint();
    }

    private final void fullRepaint() {
        this.myMainPanel.doLayout();
        this.myMainPanel.revalidate();
        this.myMainPanel.repaint();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.myList.getComponentCount() > 0;
    }

    public boolean isNull() {
        return !this.isVisible();
    }

    public NotificationGroupComponent(@NotNull JPanel myMainPanel, boolean mySuggestionType, @NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myMainPanel, (String)"myMainPanel");
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        super(new BorderLayout());
        this.myMainPanel = myMainPanel;
        this.mySuggestionType = mySuggestionType;
        this.myProject = myProject;
        this.myTitle = new JBLabel(IdeBundle.message((String)(this.mySuggestionType ? "notifications.toolwindow.suggestions" : "notifications.toolwindow.timeline"), (Object[])new Object[0]));
        this.myList = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)18)));
        this.myScrollPane = new JBScrollPane(this, this.myList, 20, 31){
            final /* synthetic */ NotificationGroupComponent this$0;

            protected void setupCorners() {
                super.setupCorners();
                this.setBorder(null);
            }

            public void updateUI() {
                super.updateUI();
                this.setBorder(null);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        this.myEventHandler = new ComponentEventHandler(this);
        this.myTimeComponents = new ArrayList();
        this.myTimeAlarm = new Alarm((Disposable)this.myProject);
        this.mySuggestionGotItPanel = new JPanel(new BorderLayout());
        this.setBackground(NotificationComponent.Companion.getBG_COLOR());
        JPanel mainPanel2 = new JPanel(new BorderLayout(0, JBUI.scale((int)8)));
        mainPanel2.setOpaque(false);
        mainPanel2.setBorder((Border)JBUI.Borders.empty((int)8, (int)8, (int)0, (int)0));
        this.add(mainPanel2);
        this.myTitle.setFont((Font)JBFont.medium());
        this.myTitle.setForeground((Color)NotificationComponent.Companion.getINFO_COLOR());
        if (this.mySuggestionType) {
            this.mySuggestionGotItPanel.setBackground((Color)new JBColor(15134455, 15134455));
            this.mySuggestionGotItPanel.setVisible(false);
            this.mySuggestionGotItPanel.setBorder(JBUI.Borders.customLineBottom((Color)JBColor.border()));
            this.add((Component)this.mySuggestionGotItPanel, "North");
            MultiLineLabel gotItTitle = new MultiLineLabel(IdeBundle.message((String)"notifications.toolwindow.suggestion.gotit.title", (Object[])new Object[0]));
            gotItTitle.setFont((Font)JBFont.medium());
            gotItTitle.setBorder((Border)JBUI.Borders.empty((int)7, (int)12, (int)7, (int)0));
            this.mySuggestionGotItPanel.add((Component)gotItTitle, "West");
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setOpaque(false);
            panel2.setBorder((Border)JBUI.Borders.empty((int)7, (int)0, (int)0, (int)12));
            this.mySuggestionGotItPanel.add((Component)panel2, "East");
            panel2.add((Component)new LinkLabel(IdeBundle.message((String)"notifications.toolwindow.suggestion.gotit.link", (Object[])new Object[0]), null, new LinkListener(){

                public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                    mySuggestionGotItPanel.setVisible(false);
                    myTitle.setVisible(true);
                    this.fullRepaint();
                }
            }), "North");
            this.myTitle.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
            mainPanel2.add((Component)this.myTitle, "North");
            this.myClearAllVisibleCallback = null;
        } else {
            JPanel panel3 = new JPanel(new BorderLayout());
            panel3.setOpaque(false);
            panel3.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
            panel3.add((Component)this.myTitle, "West");
            final LinkLabel clearAll2 = new LinkLabel(IdeBundle.message((String)"notifications.toolwindow.timeline.clear.all", (Object[])new Object[0]), null, new LinkListener(this){
                final /* synthetic */ NotificationGroupComponent this$0;

                public final void linkSelected(@NotNull LinkLabel<Unit> $noName_0, @Nullable Unit $noName_1) {
                    Intrinsics.checkNotNullParameter($noName_0, (String)"<anonymous parameter 0>");
                    NotificationGroupComponent.access$clearAll(this.this$0);
                }
                {
                    this.this$0 = notificationGroupComponent;
                }
            });
            clearAll2.setFont((Font)JBFont.medium());
            clearAll2.setBorder((Border)JBUI.Borders.emptyRight((int)20));
            clearAll2.setVisible(false);
            panel3.add((Component)clearAll2, "East");
            this.myClearAllVisibleCallback = (Function0)new Function0<Unit>(){

                public final void invoke() {
                    clearAll2.setVisible(myMouseInside && myList.getComponentCount() > 0);
                }
            };
            this.myEventHandler.mouseEnter((Function0<Unit>)((Function0)new Function0<Unit>(){

                public final void invoke() {
                    if (!myMouseInside) {
                        myMouseInside = true;
                        myClearAllVisibleCallback.invoke();
                    }
                }
            }));
            this.myEventHandler.mouseExit((Function0<Unit>)((Function0)new Function0<Unit>(){

                public final void invoke() {
                    if (myMouseInside) {
                        myMouseInside = false;
                        myClearAllVisibleCallback.invoke();
                    }
                }
            }));
            mainPanel2.add((Component)panel3, "North");
        }
        this.myList.setOpaque(true);
        this.myList.setBackground(NotificationComponent.Companion.getBG_COLOR());
        this.myList.setBorder((Border)JBUI.Borders.emptyRight((int)10));
        this.myScrollPane.setBorder(null);
        mainPanel2.add((Component)((Object)this.myScrollPane));
        this.myScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public final void adjustmentValueChanged(AdjustmentEvent it) {
                AdjustmentEvent adjustmentEvent = it;
                Intrinsics.checkNotNullExpressionValue((Object)adjustmentEvent, (String)"it");
                int value2 = adjustmentEvent.getValue();
                if (myScrollValue == 0 && value2 > 0 || myScrollValue > 0 && value2 == 0) {
                    myScrollValue = value2;
                    this.repaint();
                } else {
                    myScrollValue = value2;
                }
            }
        });
        this.myEventHandler.add(this);
    }

    public static final /* synthetic */ ArrayList access$getMyTimeComponents$p(NotificationGroupComponent $this) {
        return $this.myTimeComponents;
    }

    public static final /* synthetic */ Alarm access$getMyTimeAlarm$p(NotificationGroupComponent $this) {
        return $this.myTimeAlarm;
    }

    public static final /* synthetic */ void access$clearAll(NotificationGroupComponent $this) {
        $this.clearAll();
    }
}

