/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

final class ReadMostlyRWLock {
    @NotNull
    final Thread writeThread;
    @VisibleForTesting
    volatile boolean writeRequested;
    private final AtomicBoolean writeIntent;
    private volatile boolean writeAcquired;
    private final ConcurrentList<Reader> readers;
    private volatile boolean writeSuspended;
    private volatile long deadReadersGCStamp;
    private final ThreadLocal<Reader> R;
    private static final int SPIN_TO_WAIT_FOR_LOCK = 100;

    ReadMostlyRWLock(@NotNull Thread writeThread) {
        if (writeThread == null) {
            ReadMostlyRWLock.$$$reportNull$$$0(0);
        }
        this.writeIntent = new AtomicBoolean(false);
        this.readers = ContainerUtil.createConcurrentList();
        this.R = ThreadLocal.withInitial(() -> {
            Reader status = new Reader(Thread.currentThread());
            boolean added2 = this.readers.addIfAbsent((Object)status);
            assert (added2) : this.readers + "; " + Thread.currentThread();
            return status;
        });
        this.writeThread = writeThread;
    }

    boolean isWriteThread() {
        return Thread.currentThread() == this.writeThread;
    }

    boolean isReadLockedByThisThread() {
        this.checkReadThreadAccess();
        Reader status = this.R.get();
        return status.readRequested;
    }

    Reader startRead() {
        if (Thread.currentThread() == this.writeThread) {
            return null;
        }
        Reader status = this.R.get();
        this.throwIfImpatient(status);
        if (status.readRequested) {
            return null;
        }
        if (!this.tryReadLock(status)) {
            ProgressIndicator progress2 = ProgressIndicatorProvider.getGlobalProgressIndicator();
            int iter2 = 0;
            while (!this.tryReadLock(status)) {
                if (progress2 != null && progress2.isCanceled() && !ProgressManager.getInstance().isInNonCancelableSection()) {
                    throw new ProcessCanceledException();
                }
                this.waitABit(status, iter2);
                ++iter2;
            }
        }
        return status;
    }

    Reader startTryRead() {
        if (Thread.currentThread() == this.writeThread) {
            return null;
        }
        Reader status = this.R.get();
        this.throwIfImpatient(status);
        if (status.readRequested) {
            return null;
        }
        this.tryReadLock(status);
        return status;
    }

    void endRead(Reader status) {
        this.checkReadThreadAccess();
        status.readRequested = false;
        if (this.writeRequested) {
            LockSupport.unpark(this.writeThread);
        }
    }

    private void waitABit(Reader status, int iteration) {
        if (iteration > 100) {
            status.blocked = true;
            try {
                this.throwIfImpatient(status);
                LockSupport.parkNanos(this, 1000000L);
            }
            finally {
                status.blocked = false;
            }
        } else {
            Thread.yield();
        }
    }

    private void throwIfImpatient(Reader status) throws ApplicationUtil.CannotRunReadActionException {
        if (status.impatientReads && this.writeRequested && !ProgressManager.getInstance().isInNonCancelableSection() && CoreProgressManager.ENABLED) {
            throw ApplicationUtil.CannotRunReadActionException.create();
        }
    }

    boolean isInImpatientReader() {
        return this.R.get().impatientReads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeByImpatientReader(@NotNull Runnable runnable2) throws ApplicationUtil.CannotRunReadActionException {
        if (runnable2 == null) {
            ReadMostlyRWLock.$$$reportNull$$$0(1);
        }
        this.checkReadThreadAccess();
        Reader status = this.R.get();
        boolean old = status.impatientReads;
        try {
            status.impatientReads = true;
            runnable2.run();
        }
        finally {
            status.impatientReads = old;
        }
    }

    private boolean tryReadLock(Reader status) {
        this.throwIfImpatient(status);
        if (!this.writeRequested) {
            status.readRequested = true;
            if (!this.writeRequested) {
                return true;
            }
            status.readRequested = false;
        }
        return false;
    }

    void writeIntentLock() {
        this.checkWriteThreadAccess();
        int iter2 = 0;
        while (true) {
            if (this.writeIntent.compareAndSet(false, true)) {
                assert (!this.writeRequested);
                assert (!this.writeAcquired);
                break;
            }
            if (iter2 > 100) {
                LockSupport.parkNanos(this, 1000000L);
            } else {
                Thread.yield();
            }
            ++iter2;
        }
    }

    void writeIntentUnlock() {
        this.checkWriteThreadAccess();
        assert (!this.writeAcquired);
        assert (!this.writeRequested);
        this.writeIntent.set(false);
        LockSupport.unpark(this.writeThread);
    }

    void writeLock() {
        this.checkWriteThreadAccess();
        assert (!this.writeRequested);
        assert (!this.writeAcquired);
        this.writeRequested = true;
        int iter2 = 0;
        while (true) {
            if (this.areAllReadersIdle()) break;
            if (iter2 > 100) {
                LockSupport.parkNanos(this, 1000000L);
            } else {
                Thread.yield();
            }
            ++iter2;
        }
        this.writeAcquired = true;
    }

    void writeSuspendWhilePumpingIdeEventQueueHopingForTheBest(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ReadMostlyRWLock.$$$reportNull$$$0(2);
        }
        boolean prev2 = this.writeSuspended;
        this.writeSuspended = true;
        this.writeUnlock();
        try {
            runnable2.run();
        }
        finally {
            ProgressIndicatorUtils.cancelActionsToBeCancelledBeforeWrite();
            this.writeLock();
            this.writeSuspended = prev2;
        }
    }

    void writeUnlock() {
        ArrayList<Reader> dead;
        this.checkWriteThreadAccess();
        this.writeAcquired = false;
        this.writeRequested = false;
        long current2 = System.nanoTime();
        if (current2 - this.deadReadersGCStamp > 1000000L) {
            dead = new ArrayList<Reader>(this.readers.size());
            this.deadReadersGCStamp = current2;
        } else {
            dead = null;
        }
        for (Reader reader : this.readers) {
            if (reader.blocked) {
                LockSupport.unpark(reader.thread);
                continue;
            }
            if (dead == null || reader.thread.isAlive()) continue;
            dead.add(reader);
        }
        if (dead != null) {
            this.readers.removeAll(dead);
        }
    }

    private void checkWriteThreadAccess() {
        if (Thread.currentThread() != this.writeThread) {
            throw new IllegalStateException("Current thread: " + Thread.currentThread() + "; expected: " + this.writeThread);
        }
    }

    private void checkReadThreadAccess() {
        if (Thread.currentThread() == this.writeThread) {
            throw new IllegalStateException("Must not start read from the write thread: " + Thread.currentThread());
        }
    }

    private boolean areAllReadersIdle() {
        for (Reader reader : this.readers) {
            if (!reader.readRequested) continue;
            return false;
        }
        return true;
    }

    boolean isWriteLocked() {
        return this.writeAcquired;
    }

    public String toString() {
        return "ReadMostlyRWLock{writeThread=" + this.writeThread + ", writeRequested=" + this.writeRequested + ", writeAcquired=" + this.writeAcquired + ", readers=" + this.readers + ", writeSuspended=" + this.writeSuspended + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/application/impl/ReadMostlyRWLock";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "executeByImpatientReader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "writeSuspendWhilePumpingIdeEventQueueHopingForTheBest";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class Reader {
        @NotNull
        private final Thread thread;
        volatile boolean readRequested;
        private volatile boolean blocked;
        private boolean impatientReads;

        Reader(@NotNull Thread readerThread) {
            if (readerThread == null) {
                Reader.$$$reportNull$$$0(0);
            }
            this.thread = readerThread;
        }

        @NonNls
        public String toString() {
            return "Reader{thread=" + this.thread + ", readRequested=" + this.readRequested + ", blocked=" + this.blocked + ", impatientReads=" + this.impatientReads + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readerThread", "com/intellij/openapi/application/impl/ReadMostlyRWLock$Reader", "<init>"));
        }
    }
}

