/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.undo.ActionChangeRange;
import com.intellij.openapi.command.undo.AdjustableUndoableAction;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionChangeRangeImpl
implements ActionChangeRange {
    private static final AtomicInteger idCounter = new AtomicInteger();
    private int myOffset;
    private final int myOldLength;
    private final int myNewLength;
    private int myOldDocumentLength;
    private int myNewDocumentLength;
    private final WeakReference<AdjustableUndoableAction> myActionReference;
    private boolean myMoved;
    private final int myId;
    private final int myOriginatorId;

    public ActionChangeRangeImpl(int offset, int oldLength, int newLength, int oldDocumentLength, int newDocumentLength, @Nullable AdjustableUndoableAction action2) {
        this(offset, oldLength, newLength, oldDocumentLength, newDocumentLength, action2, 0);
    }

    private ActionChangeRangeImpl(int offset, int oldLength, int newLength, int oldDocumentLength, int newDocumentLength, @Nullable AdjustableUndoableAction action2, int originatorId) {
        this.myOffset = offset;
        this.myOldLength = oldLength;
        this.myNewLength = newLength;
        this.myOldDocumentLength = oldDocumentLength;
        this.myNewDocumentLength = newDocumentLength;
        this.myActionReference = new WeakReference<AdjustableUndoableAction>(action2);
        this.myId = idCounter.incrementAndGet();
        this.myOriginatorId = originatorId != 0 ? originatorId : this.myId;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getOldLength() {
        return this.myOldLength;
    }

    public int getNewLength() {
        return this.myNewLength;
    }

    public int getOldDocumentLength() {
        return this.myOldDocumentLength;
    }

    public int getNewDocumentLength() {
        return this.myNewDocumentLength;
    }

    public boolean isValid() {
        return this.myActionReference.get() != null;
    }

    public int getId() {
        return this.myId;
    }

    public int getOriginatorId() {
        return this.myOriginatorId;
    }

    public boolean isMoved() {
        return this.myMoved;
    }

    public void invalidate() {
        this.myActionReference.clear();
    }

    @NotNull
    public ActionChangeRange asInverted() {
        return new Inverted();
    }

    @NotNull
    public ActionChangeRange createIndependentCopy(boolean invalidate2) {
        AdjustableUndoableAction action2 = invalidate2 ? null : (AdjustableUndoableAction)this.myActionReference.get();
        return new ActionChangeRangeImpl(this.myOffset, this.myOldLength, this.myNewLength, this.myOldDocumentLength, this.myNewDocumentLength, action2, this.myOriginatorId);
    }

    public boolean moveAfter(@NotNull ActionChangeRange other, boolean preferBefore) {
        if (other == null) {
            ActionChangeRangeImpl.$$$reportNull$$$0(0);
        }
        return this.moveAfter(other, preferBefore, false);
    }

    private boolean moveAfter(@NotNull ActionChangeRange other, boolean preferBefore, boolean isInverted) {
        if (other == null) {
            ActionChangeRangeImpl.$$$reportNull$$$0(1);
        }
        int adjustment = other.getNewLength() - other.getOldLength();
        if (preferBefore) {
            if (this.moveRight(other, adjustment)) {
                return true;
            }
            if (this.moveLeft(other, adjustment, isInverted)) {
                return true;
            }
        } else {
            if (this.moveLeft(other, adjustment, isInverted)) {
                return true;
            }
            if (this.moveRight(other, adjustment)) {
                return true;
            }
        }
        return false;
    }

    private boolean moveRight(@NotNull ActionChangeRange other, int adjustment) {
        if (other == null) {
            ActionChangeRangeImpl.$$$reportNull$$$0(2);
        }
        if (other.getOffset() + other.getOldLength() <= this.myOffset) {
            this.myOffset += adjustment;
            this.onMove(adjustment);
            return true;
        }
        return false;
    }

    private boolean moveLeft(@NotNull ActionChangeRange other, int adjustment, boolean isInverted) {
        int newLength;
        if (other == null) {
            ActionChangeRangeImpl.$$$reportNull$$$0(3);
        }
        int n = newLength = isInverted ? this.myOldLength : this.myNewLength;
        if (other.getOffset() >= this.myOffset + newLength) {
            this.onMove(adjustment);
            return true;
        }
        return false;
    }

    private void onMove(int adjustment) {
        this.myOldDocumentLength += adjustment;
        this.myNewDocumentLength += adjustment;
        this.myMoved = true;
    }

    public String toString() {
        AdjustableUndoableAction action2 = (AdjustableUndoableAction)this.myActionReference.get();
        Object info2 = action2 == null ? "" : " for " + action2;
        return String.format("(%d, %d, %d, %d, %d)%s", this.myOffset, this.myOldLength, this.myNewLength, this.myOldDocumentLength, this.myNewDocumentLength, info2);
    }

    public int hashCode() {
        return this.myId;
    }

    public boolean equals(Object obj2) {
        if (obj2 instanceof ActionChangeRangeImpl) {
            return this.myId == ((ActionChangeRangeImpl)obj2).myId;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "other";
        objectArray2[1] = "com/intellij/openapi/command/impl/ActionChangeRangeImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "moveAfter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "moveRight";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "moveLeft";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class Inverted
    implements ActionChangeRange {
        private Inverted() {
        }

        public int getOffset() {
            return ActionChangeRangeImpl.this.myOffset;
        }

        public int getOldLength() {
            return ActionChangeRangeImpl.this.myNewLength;
        }

        public int getNewLength() {
            return ActionChangeRangeImpl.this.myOldLength;
        }

        public boolean isValid() {
            return ActionChangeRangeImpl.this.isValid();
        }

        public int getId() {
            return -ActionChangeRangeImpl.this.myId;
        }

        public int getOriginatorId() {
            return ActionChangeRangeImpl.this.myOriginatorId;
        }

        @NotNull
        public ActionChangeRange asInverted() {
            ActionChangeRangeImpl actionChangeRangeImpl = ActionChangeRangeImpl.this;
            if (actionChangeRangeImpl == null) {
                Inverted.$$$reportNull$$$0(0);
            }
            return actionChangeRangeImpl;
        }

        @NotNull
        public ActionChangeRange createIndependentCopy(boolean invalidate2) {
            AdjustableUndoableAction action2 = invalidate2 ? null : (AdjustableUndoableAction)ActionChangeRangeImpl.this.myActionReference.get();
            return new ActionChangeRangeImpl(ActionChangeRangeImpl.this.myOffset, ActionChangeRangeImpl.this.myNewLength, ActionChangeRangeImpl.this.myOldLength, ActionChangeRangeImpl.this.myNewDocumentLength, ActionChangeRangeImpl.this.myOldDocumentLength, action2, ActionChangeRangeImpl.this.myOriginatorId);
        }

        public boolean moveAfter(@NotNull ActionChangeRange other, boolean preferBefore) {
            if (other == null) {
                Inverted.$$$reportNull$$$0(1);
            }
            return ActionChangeRangeImpl.this.moveAfter(other, preferBefore, true);
        }

        public String toString() {
            return "INV" + ActionChangeRangeImpl.this;
        }

        public int hashCode() {
            return -ActionChangeRangeImpl.this.myId;
        }

        public boolean equals(Object obj2) {
            if (obj2 instanceof Inverted) {
                return this.getId() == ((Inverted)obj2).getId();
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/command/impl/ActionChangeRangeImpl$Inverted";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asInverted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/command/impl/ActionChangeRangeImpl$Inverted";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "moveAfter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

