/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.extensions.PluginId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentCategorizer {
    private ComponentCategorizer() {
    }

    @NotNull
    public static SettingsCategory getCategory(@NotNull PersistentStateComponent<?> component2) {
        PluginId pluginId;
        if (component2 == null) {
            ComponentCategorizer.$$$reportNull$$$0(0);
        }
        if ((pluginId = ComponentCategorizer.getPluginId(component2)) != null) {
            ComponentCategorizer.getPluginCategory(component2.getClass(), pluginId);
        }
        return ComponentCategorizer.getFromAnnotationOrDefault(component2.getClass(), SettingsCategory.OTHER);
    }

    @NotNull
    public static SettingsCategory getPluginCategory(@NotNull Class<? extends PersistentStateComponent> componentClass, @NotNull PluginId pluginId) {
        IdeaPluginDescriptor pluginDescriptor;
        if (componentClass == null) {
            ComponentCategorizer.$$$reportNull$$$0(1);
        }
        if (pluginId == null) {
            ComponentCategorizer.$$$reportNull$$$0(2);
        }
        if ((pluginDescriptor = PluginManager.getInstance().findEnabledPlugin(pluginId)) != null && pluginDescriptor.isBundled()) {
            return ComponentCategorizer.getFromAnnotationOrDefault(componentClass, SettingsCategory.PLUGINS);
        }
        SettingsCategory settingsCategory = SettingsCategory.PLUGINS;
        if (settingsCategory == null) {
            ComponentCategorizer.$$$reportNull$$$0(3);
        }
        return settingsCategory;
    }

    @NotNull
    private static SettingsCategory getFromAnnotationOrDefault(@NotNull Class<? extends PersistentStateComponent> componentClass, @NotNull SettingsCategory defaultCategory) {
        State state;
        if (componentClass == null) {
            ComponentCategorizer.$$$reportNull$$$0(4);
        }
        if (defaultCategory == null) {
            ComponentCategorizer.$$$reportNull$$$0(5);
        }
        SettingsCategory settingsCategory = (state = componentClass.getAnnotation(State.class)) != null && !SettingsCategory.OTHER.equals((Object)state.category()) ? state.category() : defaultCategory;
        if (settingsCategory == null) {
            ComponentCategorizer.$$$reportNull$$$0(6);
        }
        return settingsCategory;
    }

    @Nullable
    public static PluginId getPluginId(@NotNull PersistentStateComponent<?> component2) {
        if (component2 == null) {
            ComponentCategorizer.$$$reportNull$$$0(7);
        }
        return PluginManager.getPluginByClassName(component2.getClass().getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/ComponentCategorizer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCategory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/ComponentCategorizer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginCategory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromAnnotationOrDefault";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCategory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPluginCategory";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFromAnnotationOrDefault";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPluginId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

