/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.intellij.CommonBundle;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.diff.AsyncDiffElement;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DiffType;
import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.ide.diff.VirtualFileDiffElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.dir.DTree;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.diff.impl.dir.DirDiffModelListener;
import com.intellij.openapi.diff.impl.dir.DirDiffPanel;
import com.intellij.openapi.diff.impl.dir.actions.popup.WarnOnDeletion;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.TableUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirDiffTableModel
extends AbstractTableModel
implements DirDiffModel,
Disposable {
    private static final Logger LOG = Logger.getInstance(DirDiffTableModel.class);
    public static final Key<JBLoadingPanel> DECORATOR_KEY = Key.create((String)"DIFF_TABLE_DECORATOR");
    public static final String EMPTY_STRING = StringUtil.repeatSymbol((char)' ', (int)50);
    @Nullable
    private final Project myProject;
    private final DirDiffSettings mySettings;
    private DiffElement mySource;
    private DiffElement myTarget;
    private DTree myTree;
    private final List<DirDiffElementImpl> myElements = new ArrayList<DirDiffElementImpl>();
    private final AtomicBoolean myUpdating = new AtomicBoolean(false);
    private JBTable myTable;
    private final AtomicReference<@Nls String> text = new AtomicReference<String>(DirDiffTableModel.prepareText(""));
    private volatile Updater myUpdater;
    private final List<DirDiffModelListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private TableSelectionConfig mySelectionConfig;
    private final Map<String, BiMap<String, String>> mySourceToReplacingTarget = HashBiMap.create();
    private DirDiffPanel myPanel;
    private volatile boolean myDisposed;

    public DirDiffTableModel(@Nullable Project project, DiffElement<?> source, DiffElement<?> target2, DirDiffSettings settings) {
        this.myProject = project;
        this.mySettings = settings;
        this.mySource = source;
        this.myTarget = target2;
    }

    public void stopUpdating() {
        if (this.myUpdating.get()) {
            this.myUpdating.set(false);
        }
    }

    public void applyRemove() {
        int index2;
        List<DirDiffElementImpl> selectedElements = this.getSelectedElements();
        this.myUpdating.set(true);
        Iterator<DirDiffElementImpl> i2 = this.myElements.iterator();
        while (i2.hasNext()) {
            DiffType type = i2.next().getType();
            switch (type) {
                case SOURCE: {
                    if (this.mySettings.showNewOnSource) break;
                    i2.remove();
                    break;
                }
                case TARGET: {
                    if (this.mySettings.showNewOnTarget) break;
                    i2.remove();
                    break;
                }
                case SEPARATOR: {
                    break;
                }
                case CHANGED: {
                    if (this.mySettings.showDifferent) break;
                    i2.remove();
                    break;
                }
                case EQUAL: {
                    if (this.mySettings.showEqual) break;
                    i2.remove();
                    break;
                }
            }
        }
        boolean sep = true;
        for (int j = this.myElements.size() - 1; j >= 0; --j) {
            if (this.myElements.get(j).isSeparator()) {
                if (sep) {
                    this.myElements.remove(j);
                    continue;
                }
                sep = true;
                continue;
            }
            sep = false;
        }
        this.fireTableDataChanged();
        this.myUpdating.set(false);
        if (!selectedElements.isEmpty() && (index2 = this.myElements.indexOf(selectedElements.get(0))) != -1) {
            this.myTable.getSelectionModel().setSelectionInterval(index2, index2);
            TableUtil.scrollSelectionToVisible((JTable)this.myTable);
        } else {
            this.selectFirstRow();
        }
        this.myPanel.update(true);
    }

    public void selectFirstRow() {
        if (this.myElements.size() > 0) {
            int row2;
            int n = row2 = this.myElements.get(0).isSeparator() ? 1 : 0;
            if (row2 < this.myTable.getRowCount()) {
                this.myTable.getSelectionModel().setSelectionInterval(row2, row2);
                TableUtil.scrollSelectionToVisible((JTable)this.myTable);
            }
        }
    }

    public void setPanel(DirDiffPanel panel2) {
        this.myPanel = panel2;
    }

    public void updateFromUI() {
        this.getSettings().setFilter(this.myPanel.getFilter());
        this.myPanel.update(false);
    }

    public boolean isOperationsEnabled() {
        return !this.myDisposed && this.mySettings.enableOperations && this.mySource.isOperationsEnabled() && this.myTarget.isOperationsEnabled();
    }

    public List<DirDiffElementImpl> getElements() {
        return this.myElements;
    }

    public void setReplacement(DirDiffElementImpl source, @Nullable DirDiffElementImpl target2) {
        this.setReplacement(source.getParentNode().getPath(), source.getSourceName(), target2 == null ? null : target2.getTargetName());
    }

    public void setReplacement(@NotNull String path2, @Nullable String sourceName, @Nullable String targetName) {
        if (path2 == null) {
            DirDiffTableModel.$$$reportNull$$$0(0);
        }
        BiMap map2 = this.mySourceToReplacingTarget.computeIfAbsent(path2, p -> HashBiMap.create());
        if (targetName != null) {
            map2.forcePut((Object)sourceName, (Object)targetName);
        } else {
            map2.remove((Object)sourceName);
        }
    }

    public String getReplacementName(DirDiffElementImpl source) {
        BiMap<String, String> map2 = this.mySourceToReplacingTarget.get(source.getParentNode().getPath());
        return map2 != null ? (String)map2.get((Object)source.getSourceName()) : null;
    }

    @Nls
    private static String prepareText(String text2) {
        int LEN = EMPTY_STRING.length();
        Object right = text2 == null ? EMPTY_STRING : (text2.length() == LEN ? text2 : (text2.length() < LEN ? text2 + EMPTY_STRING.substring(0, LEN - text2.length()) : "..." + text2.substring(text2.length() - LEN + 2)));
        return DiffBundle.message((String)"label.dirdiff.loading.file", (Object[])new Object[]{right});
    }

    void fireUpdateStarted() {
        for (DirDiffModelListener listener2 : this.myListeners) {
            listener2.updateStarted();
        }
    }

    void fireUpdateFinished() {
        for (DirDiffModelListener listener2 : this.myListeners) {
            listener2.updateFinished();
        }
    }

    void addModelListener(DirDiffModelListener listener2) {
        this.myListeners.add(listener2);
    }

    public void reloadModel(boolean userForcedRefresh) {
        this.fireUpdateStarted();
        this.myUpdating.set(true);
        this.myTable.getEmptyText().setText(StatusText.getDefaultEmptyText());
        JBLoadingPanel loadingPanel = this.getLoadingPanel();
        loadingPanel.startLoading();
        ModalityState modalityState = ModalityState.current();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            EmptyProgressIndicator indicator2 = new EmptyProgressIndicator(modalityState);
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                try {
                    if (this.myDisposed) {
                        return;
                    }
                    this.startAndSetUpdater(new Updater(loadingPanel, 100));
                    this.text.set(CommonBundle.getLoadingTreeNodeText());
                    this.myTree = new DTree(null, "", true);
                    this.mySource.refresh(userForcedRefresh);
                    this.myTarget.refresh(userForcedRefresh);
                    this.scan(this.mySource, this.myTree, true);
                    this.scan(this.myTarget, this.myTree, false);
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    this.reportException(DiffBundle.message((String)"refresh.failed.message", (Object[])new Object[]{StringUtil.decapitalize((String)e.getLocalizedMessage())}));
                }
                finally {
                    if (this.myTree != null) {
                        this.myTree.setSource(this.mySource);
                        this.myTree.setTarget(this.myTarget);
                        this.myTree.update(this.mySettings);
                        ApplicationManager.getApplication().invokeLater(this::fireUpdateFinished, ModalityState.any());
                        this.applySettings();
                    }
                }
            }, (ProgressIndicator)indicator2);
        });
    }

    public void reloadModelSynchronously() {
        this.myUpdating.set(true);
        try {
            this.fireUpdateStarted();
            this.myTree = new DTree(null, "", true);
            this.mySource.refresh(true);
            this.myTarget.refresh(true);
            this.scan(this.mySource, this.myTree, true);
            this.scan(this.myTarget, this.myTree, false);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            this.reportException(DiffBundle.message((String)"refresh.failed.message", (Object[])new Object[]{StringUtil.decapitalize((String)e.getLocalizedMessage())}));
        }
        finally {
            this.myTree.setSource(this.mySource);
            this.myTree.setTarget(this.myTarget);
            this.myTree.update(this.mySettings);
            ArrayList<DirDiffElementImpl> elements = new ArrayList<DirDiffElementImpl>();
            this.fillElements(this.myTree, elements);
            this.myElements.clear();
            this.myElements.addAll(elements);
            this.myUpdating.set(false);
            this.fireUpdateFinished();
        }
    }

    private void reportException(@Nullable @Nls String htmlContent) {
        if (this.myDisposed || htmlContent == null) {
            return;
        }
        Runnable balloonShower = () -> {
            Balloon balloon2 = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(htmlContent, MessageType.WARNING, null).setShowCallout(false).setHideOnClickOutside(true).setHideOnAction(true).setHideOnFrameResize(true).setHideOnKeyOutside(true).createBalloon();
            Rectangle rect = this.myPanel.getPanel().getBounds();
            Point p = new Point(rect.x + rect.width - 100, rect.y + 50);
            RelativePoint point = new RelativePoint((Component)this.myPanel.getPanel(), p);
            balloon2.show(point, Balloon.Position.below);
            Disposer.register((Disposable)(this.myProject != null ? this.myProject : ApplicationManager.getApplication()), (Disposable)balloon2);
        };
        ApplicationManager.getApplication().invokeLater(balloonShower, o -> this.myProject != null && !this.myProject.isDefault() && !this.myProject.isOpen());
    }

    private JBLoadingPanel getLoadingPanel() {
        return (JBLoadingPanel)ComponentUtil.getClientProperty((JComponent)this.myTable, DECORATOR_KEY);
    }

    public void applySettings() {
        JBLoadingPanel loadingPanel;
        if (!this.myUpdating.get()) {
            this.myUpdating.set(true);
        }
        if (!(loadingPanel = this.getLoadingPanel()).isLoading()) {
            loadingPanel.startLoading();
            if (this.myUpdater == null) {
                this.startAndSetUpdater(new Updater(loadingPanel, 100));
            }
        }
        Application app2 = ApplicationManager.getApplication();
        app2.executeOnPooledThread(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myTree.updateVisibility(this.mySettings);
            ArrayList<DirDiffElementImpl> elements = new ArrayList<DirDiffElementImpl>();
            this.fillElements(this.myTree, elements);
            Runnable uiThread = () -> {
                if (this.myDisposed) {
                    return;
                }
                this.clear();
                this.myElements.addAll(elements);
                this.myUpdating.set(false);
                this.fireTableDataChanged();
                this.text.set("");
                if (loadingPanel.isLoading()) {
                    loadingPanel.stopLoading();
                }
                if (this.mySelectionConfig == null) {
                    this.selectFirstRow();
                } else {
                    this.mySelectionConfig.restore();
                }
                this.myPanel.update(true);
            };
            if (this.myProject == null || this.myProject.isDefault()) {
                SwingUtilities.invokeLater(uiThread);
            } else {
                app2.invokeLater(uiThread, ModalityState.any());
            }
        });
    }

    private void fillElements(DTree tree, List<DirDiffElementImpl> elements) {
        if (!this.myUpdating.get()) {
            return;
        }
        boolean separatorAdded = tree.getParent() == null;
        this.text.set(DirDiffTableModel.prepareText(tree.getPath()));
        for (DTree child2 : tree.getChildren()) {
            if (!this.myUpdating.get()) {
                return;
            }
            if (!child2.isContainer()) {
                DiffType type;
                if (!child2.isVisible()) continue;
                if (!separatorAdded) {
                    elements.add(DirDiffElementImpl.createDirElement(tree, tree.getSource(), tree.getTarget(), tree.getPath()));
                    separatorAdded = true;
                }
                if ((type = child2.getType()) != null) {
                    switch (type) {
                        case SOURCE: {
                            elements.add(DirDiffElementImpl.createSourceOnly(child2, child2.getSource()));
                            break;
                        }
                        case TARGET: {
                            elements.add(DirDiffElementImpl.createTargetOnly(child2, child2.getTarget()));
                            break;
                        }
                        case CHANGED: {
                            elements.add(DirDiffElementImpl.createChange(child2, child2.getSource(), child2.getTarget(), this.mySettings.customSourceChooser));
                            break;
                        }
                        case EQUAL: {
                            elements.add(DirDiffElementImpl.createEqual(child2, child2.getSource(), child2.getTarget()));
                            break;
                        }
                        case ERROR: {
                            elements.add(DirDiffElementImpl.createError(child2, child2.getSource(), child2.getTarget()));
                        }
                    }
                    continue;
                }
                LOG.error(String.format("Element's type is null [Name: %s, Container: %s, Source: %s, Target: %s] ", child2.getName(), child2.isContainer(), child2.getSource(), child2.getTarget()));
                continue;
            }
            this.fillElements(child2, elements);
        }
    }

    public void clear() {
        if (!this.myElements.isEmpty()) {
            int size = this.myElements.size();
            this.myElements.clear();
            this.fireTableRowsDeleted(0, size - 1);
        }
    }

    private void scan(DiffElement<?> element2, DTree root2, boolean source) throws IOException {
        if (!this.myUpdating.get()) {
            return;
        }
        if (element2.isContainer()) {
            DiffElement[] children2;
            this.text.set(DirDiffTableModel.prepareText(element2.getPath()));
            for (DiffElement child2 : children2 = element2.getChildren()) {
                if (!this.myUpdating.get()) {
                    return;
                }
                this.text.set(DirDiffTableModel.prepareText(child2.getPath()));
                BiMap<String, String> replacing = this.mySourceToReplacingTarget.get(root2.getPath());
                String replacementName = replacing != null ? (source ? (String)replacing.get((Object)child2.getName()) : (String)replacing.inverse().get((Object)child2.getName())) : null;
                DTree el = root2.addChild(child2, source, replacementName);
                this.scan(child2, el, source);
            }
        }
    }

    @NlsContexts.DialogTitle
    public String getTitle() {
        if (this.myDisposed) {
            return DiffBundle.message((String)"diff.files.dialog.title", (Object[])new Object[0]);
        }
        if (this.mySource instanceof VirtualFileDiffElement && this.myTarget instanceof VirtualFileDiffElement) {
            VirtualFile srcFile = ((VirtualFileDiffElement)this.mySource).getValue();
            VirtualFile trgFile = ((VirtualFileDiffElement)this.myTarget).getValue();
            return DiffRequestFactory.getInstance().getTitle(srcFile, trgFile);
        }
        return IdeBundle.message((String)"diff.dialog.title", (Object[])new Object[]{this.mySource.getPresentablePath(), this.myTarget.getPresentablePath()});
    }

    @Nullable
    public DirDiffElementImpl getElementAt(int index2) {
        return 0 <= index2 && index2 < this.myElements.size() ? this.myElements.get(index2) : null;
    }

    public DiffElement getSourceDir() {
        return this.mySource;
    }

    public DiffElement getTargetDir() {
        return this.myTarget;
    }

    public void setSourceDir(DiffElement src) {
        this.mySource = src;
    }

    public void setTargetDir(DiffElement trg) {
        this.myTarget = trg;
    }

    @Override
    public int getRowCount() {
        return this.myElements.size();
    }

    @Override
    public int getColumnCount() {
        int count = 3;
        if (this.mySettings.showDate) {
            count += 2;
        }
        if (this.mySettings.showSize) {
            count += 2;
        }
        return count;
    }

    public JBTable getTable() {
        return this.myTable;
    }

    public void setTable(JBTable table) {
        this.myTable = table;
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            boolean isSrc;
            DirDiffElementImpl element2 = this.myElements.get(rowIndex);
            if (element2.isSeparator()) {
                return columnIndex == 0 ? element2.getName() : null;
            }
            ColumnType columnType = this.getColumnType(columnIndex);
            boolean bl = isSrc = columnIndex < this.getColumnCount() / 2;
            if (columnType == ColumnType.NAME) {
                return isSrc ? element2.getSourcePresentableName() : element2.getTargetPresentableName();
            }
            if (columnType == ColumnType.SIZE) {
                return isSrc ? element2.getSourceSize() : element2.getTargetSize();
            }
            if (columnType == ColumnType.DATE) {
                return isSrc ? element2.getSourceModificationDate() : element2.getTargetModificationDate();
            }
            return "";
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(() -> {
                this.myElements.clear();
                this.fireTableDataChanged();
                this.myTable.getEmptyText().setText(DiffBundle.message((String)"data.has.been.changed.externally.reloading.data", (Object[])new Object[0]));
                this.reloadModel(true);
                this.myTable.repaint();
            });
            return "";
        }
    }

    public List<DirDiffElementImpl> getSelectedElements() {
        int[] rows = this.myTable.getSelectedRows();
        ArrayList<DirDiffElementImpl> elements = new ArrayList<DirDiffElementImpl>();
        for (int row2 : rows) {
            DirDiffElementImpl element2 = this.getElementAt(row2);
            if (element2 == null || element2.isSeparator()) continue;
            elements.add(element2);
        }
        return elements;
    }

    @NotNull
    public ColumnType getColumnType(int column2) {
        int count = (this.getColumnCount() - 1) / 2;
        if (column2 == count) {
            ColumnType columnType = ColumnType.OPERATION;
            if (columnType == null) {
                DirDiffTableModel.$$$reportNull$$$0(1);
            }
            return columnType;
        }
        if (column2 > count) {
            column2 = this.getColumnCount() - 1 - column2;
        }
        switch (column2) {
            case 0: {
                ColumnType columnType = ColumnType.NAME;
                if (columnType == null) {
                    DirDiffTableModel.$$$reportNull$$$0(2);
                }
                return columnType;
            }
            case 1: {
                ColumnType columnType = this.mySettings.showSize ? ColumnType.SIZE : ColumnType.DATE;
                if (columnType == null) {
                    DirDiffTableModel.$$$reportNull$$$0(3);
                }
                return columnType;
            }
            case 2: {
                ColumnType columnType = ColumnType.DATE;
                if (columnType == null) {
                    DirDiffTableModel.$$$reportNull$$$0(4);
                }
                return columnType;
            }
        }
        throw new IllegalArgumentException(String.valueOf(column2));
    }

    @Override
    public String getColumnName(int column2) {
        ColumnType type = this.getColumnType(column2);
        switch (type) {
            case OPERATION: {
                return "*";
            }
            case NAME: {
                return DiffBundle.message((String)"column.dirdiff.name", (Object[])new Object[0]);
            }
            case SIZE: {
                return DiffBundle.message((String)"column.dirdiff.size", (Object[])new Object[0]);
            }
            case DATE: {
                return DiffBundle.message((String)"column.dirdiff.date", (Object[])new Object[0]);
            }
        }
        throw new IllegalArgumentException(type.name());
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public boolean isShowEqual() {
        return this.mySettings.showEqual;
    }

    public void setShowEqual(boolean show2) {
        this.mySettings.showEqual = show2;
    }

    public boolean isShowDifferent() {
        return this.mySettings.showDifferent;
    }

    public void setShowDifferent(boolean show2) {
        this.mySettings.showDifferent = show2;
    }

    public boolean isShowNewOnSource() {
        return this.mySettings.showNewOnSource;
    }

    public void setShowNewOnSource(boolean show2) {
        this.mySettings.showNewOnSource = show2;
    }

    public boolean isShowNewOnTarget() {
        return this.mySettings.showNewOnTarget;
    }

    public void setShowNewOnTarget(boolean show2) {
        this.mySettings.showNewOnTarget = show2;
    }

    public boolean isUpdating() {
        return this.myUpdating.get();
    }

    public DirDiffSettings.CompareMode getCompareMode() {
        return this.mySettings.compareMode;
    }

    public void setCompareMode(DirDiffSettings.CompareMode mode) {
        this.mySettings.compareMode = mode;
    }

    public void dispose() {
        this.myDisposed = true;
        this.myListeners.clear();
        this.myElements.clear();
        this.mySource = null;
        this.myTarget = null;
        this.myTree = null;
    }

    public DirDiffSettings getSettings() {
        return this.mySettings;
    }

    public void performCopyTo(DirDiffElementImpl element2) {
        DiffElement source = element2.getSource();
        if (source != null) {
            String path2 = element2.getParentNode().getPath();
            if (source instanceof AsyncDiffElement) {
                ((AsyncDiffElement)source).copyToAsync(this.myTarget, element2.getTarget(), path2).onError(error -> this.reportException(error == null ? null : error.getMessage())).onSuccess(newElement -> {
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    if (this.myDisposed) {
                        return;
                    }
                    if (newElement == null && element2.getTarget() != null) {
                        int row2 = this.myElements.indexOf(element2);
                        element2.updateTargetData();
                        this.fireTableRowsUpdated(row2, row2);
                    }
                    this.refreshElementAfterCopyTo((DiffElement<?>)newElement, element2);
                });
            } else {
                WriteAction.run(() -> {
                    DiffElement diffElement = source.copyTo(this.myTarget, path2);
                    this.refreshElementAfterCopyTo(diffElement, element2);
                });
            }
        }
    }

    private void refreshElementAfterCopyTo(DiffElement<?> newElement, DirDiffElementImpl element2) {
        if (newElement != null) {
            DTree node2 = element2.getNode();
            node2.setType(DiffType.EQUAL);
            node2.setTarget(newElement);
            int row2 = this.myElements.indexOf(element2);
            if (this.getSettings().showEqual) {
                element2.updateSourceFromTarget(newElement);
                this.fireTableRowsUpdated(row2, row2);
            } else {
                this.removeElement(element2, false);
            }
        }
    }

    public void performCopyFrom(@NotNull DirDiffElementImpl element2) {
        DiffElement target2;
        if (element2 == null) {
            DirDiffTableModel.$$$reportNull$$$0(5);
        }
        if ((target2 = element2.getTarget()) != null) {
            String path2 = element2.getParentNode().getPath();
            if (target2 instanceof AsyncDiffElement) {
                ((AsyncDiffElement)target2).copyToAsync(this.mySource, element2.getSource(), path2).onError(error -> this.reportException(error == null ? null : error.getMessage())).onSuccess(newElement -> {
                    if (this.myDisposed) {
                        return;
                    }
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    this.refreshElementAfterCopyFrom(element2, (DiffElement<?>)newElement);
                });
            } else {
                WriteAction.run(() -> {
                    DiffElement diffElement = target2.copyTo(this.mySource, path2);
                    this.refreshElementAfterCopyFrom(element2, diffElement);
                });
            }
        }
    }

    private void refreshElementAfterCopyFrom(DirDiffElementImpl element2, DiffElement<?> newElement) {
        if (newElement != null) {
            DTree node2 = element2.getNode();
            node2.setType(DiffType.EQUAL);
            node2.setSource(newElement);
            int row2 = this.myElements.indexOf(element2);
            if (this.getSettings().showEqual) {
                element2.updateTargetFromSource(newElement);
                this.fireTableRowsUpdated(row2, row2);
            } else {
                this.removeElement(element2, false);
            }
        }
    }

    private void removeElement(DirDiffElementImpl element2, boolean removeFromTree) {
        int row2 = this.myElements.indexOf(element2);
        if (row2 != -1) {
            DTree node2 = element2.getNode();
            if (removeFromTree) {
                DTree parentNode = element2.getParentNode();
                parentNode.remove(node2);
            }
            this.myElements.remove(row2);
            int start2 = row2;
            if (row2 > 0 && row2 == this.myElements.size() && this.myElements.get(row2 - 1).isSeparator() || row2 != this.myElements.size() && this.myElements.get(row2).isSeparator() && row2 > 0 && this.myElements.get(row2 - 1).isSeparator()) {
                DirDiffElementImpl el = this.myElements.get(row2 - 1);
                if (removeFromTree) {
                    el.getParentNode().remove(el.getNode());
                }
                this.myElements.remove(row2 - 1);
                start2 = row2 - 1;
            }
            this.fireTableRowsDeleted(start2, row2);
        }
    }

    public void performDelete(@NotNull DirDiffElementImpl element2) {
        if (element2 == null) {
            DirDiffTableModel.$$$reportNull$$$0(6);
        }
        DiffElement source = element2.getSource();
        DiffElement target2 = element2.getTarget();
        LOG.assertTrue(source == null || target2 == null);
        if (source instanceof AsyncDiffElement || target2 instanceof AsyncDiffElement) {
            ((AsyncDiffElement)(source != null ? source : target2)).deleteAsync().onError(error -> this.reportException(error != null ? error.getMessage() : null)).onSuccess(result2 -> {
                if (!this.myDisposed && this.myElements.contains(element2)) {
                    this.removeElement(element2, true);
                }
            });
        } else {
            if (this.myElements.contains(element2)) {
                this.removeElement(element2, true);
            }
            WriteAction.run(() -> (source != null ? source : target2).delete());
        }
    }

    public void synchronizeSelected() {
        List<DirDiffElementImpl> selectedElements = this.getSelectedElements();
        if (!this.checkCanDelete(selectedElements)) {
            return;
        }
        this.rememberSelection();
        for (DirDiffElementImpl element2 : selectedElements) {
            this.syncElement(element2);
        }
        this.restoreSelection();
    }

    private void restoreSelection() {
        if (this.mySelectionConfig != null) {
            this.mySelectionConfig.restore();
        }
    }

    public void synchronizeAll() {
        ArrayList<DirDiffElementImpl> elements = new ArrayList<DirDiffElementImpl>(this.myElements);
        if (!this.checkCanDelete(elements)) {
            return;
        }
        for (DirDiffElementImpl element2 : elements) {
            this.syncElement(element2);
        }
        this.selectFirstRow();
    }

    private boolean checkCanDelete(List<DirDiffElementImpl> elements) {
        if (WarnOnDeletion.isWarnWhenDeleteItems()) {
            int count = 0;
            for (DirDiffElementImpl element2 : elements) {
                if (element2.getOperation() != DirDiffOperation.DELETE) continue;
                ++count;
            }
            if (count > 0 && !this.confirmDeletion(count)) {
                return false;
            }
        }
        return true;
    }

    private boolean confirmDeletion(int count) {
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)DiffBundle.message((String)"confirm.delete", (Object[])new Object[0]), (String)DiffBundle.message((String)"delete.0.items", (Object[])new Object[]{count})).yesText(CommonBundle.message((String)"button.delete", (Object[])new Object[0]))).noText(CommonBundle.getCancelButtonText())).doNotAsk(new DoNotAskOption(){

            public boolean isToBeShown() {
                return WarnOnDeletion.isWarnWhenDeleteItems();
            }

            public void setToBeShown(boolean value2, int exitCode) {
                WarnOnDeletion.setWarnWhenDeleteItems(value2);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = DiffBundle.message((String)"do.not.ask.me.again", (Object[])new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/dir/DirDiffTableModel$1", "getDoNotShowMessage"));
            }
        })).ask(this.myProject);
    }

    private void syncElement(DirDiffElementImpl element2) {
        DirDiffOperation operation = element2.getOperation();
        if (operation == null) {
            return;
        }
        switch (operation) {
            case COPY_TO: {
                this.performCopyTo(element2);
                break;
            }
            case COPY_FROM: {
                this.performCopyFrom(element2);
                break;
            }
            case DELETE: {
                this.performDelete(element2);
                break;
            }
        }
    }

    private void startAndSetUpdater(Updater updater) {
        updater.start();
        this.myUpdater = updater;
    }

    public void rememberSelection() {
        this.mySelectionConfig = new TableSelectionConfig();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/dir/DirDiffTableModel";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/dir/DirDiffTableModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setReplacement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performCopyFrom";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performDelete";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class TableSelectionConfig {
        private final int selectedRow;
        private final int rowCount;

        TableSelectionConfig() {
            this.selectedRow = DirDiffTableModel.this.myTable.getSelectedRow();
            this.rowCount = DirDiffTableModel.this.myTable.getRowCount();
        }

        void restore() {
            DirDiffElementImpl el;
            int newRowCount = DirDiffTableModel.this.myTable.getRowCount();
            if (newRowCount == 0) {
                return;
            }
            int row2 = Math.min(newRowCount < this.rowCount ? this.selectedRow : this.selectedRow + 1, newRowCount - 1);
            DirDiffElementImpl element2 = DirDiffTableModel.this.getElementAt(row2);
            if (element2 != null && element2.isSeparator()) {
                row2 = DirDiffTableModel.this.getElementAt(row2 + 1) != null ? ++row2 : --row2;
            }
            row2 = (el = DirDiffTableModel.this.getElementAt(row2)) == null || el.isSeparator() ? 0 : row2;
            DirDiffTableModel.this.myTable.getSelectionModel().setSelectionInterval(row2, row2);
            TableUtil.scrollSelectionToVisible((JTable)DirDiffTableModel.this.myTable);
        }
    }

    class Updater
    extends Thread {
        private final JBLoadingPanel myLoadingPanel;
        private final int mySleep;

        Updater(JBLoadingPanel loadingPanel, int sleep) {
            super("Loading Updater");
            this.myLoadingPanel = loadingPanel;
            this.mySleep = sleep;
        }

        @Override
        public void run() {
            if (!DirDiffTableModel.this.myDisposed && this.myLoadingPanel.isLoading()) {
                TimeoutUtil.sleep((long)this.mySleep);
                ApplicationManager.getApplication().invokeLater(() -> {
                    String s = DirDiffTableModel.this.text.get();
                    if (s != null && this.myLoadingPanel.isLoading()) {
                        this.myLoadingPanel.setLoadingText(s);
                    }
                }, ModalityState.stateForComponent((Component)this.myLoadingPanel));
                DirDiffTableModel.this.startAndSetUpdater(new Updater(this.myLoadingPanel, this.mySleep));
            } else {
                DirDiffTableModel.this.myUpdater = null;
            }
        }
    }

    public static enum ColumnType {
        OPERATION,
        NAME,
        SIZE,
        DATE;

    }
}

