/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.CombinedPopupLayout;
import com.intellij.openapi.editor.DocumentationHoverInfo;
import com.intellij.openapi.editor.DocumentationPsiHoverInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlightHoverInfo;
import com.intellij.openapi.editor.PopupBridge;
import com.intellij.openapi.editor.ex.TooltipAction;
import com.intellij.openapi.project.Project;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class EditorHoverInfo {
    @Nullable
    public final HighlightHoverInfo highlightHoverInfo;
    @Nullable
    public final DocumentationHoverInfo documentationHoverInfo;

    public EditorHoverInfo(@Nullable HighlightHoverInfo highlightHoverInfo, @Nullable DocumentationHoverInfo documentationHoverInfo) {
        assert (highlightHoverInfo != null || documentationHoverInfo != null);
        this.highlightHoverInfo = highlightHoverInfo;
        this.documentationHoverInfo = documentationHoverInfo;
    }

    @Nullable
    public JComponent createComponent(@NotNull Editor editor2, @NotNull PopupBridge popupBridge, boolean requestFocus) {
        JComponent c2;
        JComponent c1;
        boolean quickDocShownInPopup;
        if (editor2 == null) {
            EditorHoverInfo.$$$reportNull$$$0(0);
        }
        if (popupBridge == null) {
            EditorHoverInfo.$$$reportNull$$$0(1);
        }
        Project project = Objects.requireNonNull(editor2.getProject());
        boolean bl = quickDocShownInPopup = this.documentationHoverInfo != null && this.documentationHoverInfo.showInPopup(project);
        JComponent jComponent = this.highlightHoverInfo == null ? null : (c1 = this.highlightHoverInfo.createHighlightInfoComponent(editor2, !quickDocShownInPopup, popupBridge, requestFocus));
        JComponent jComponent2 = this.documentationHoverInfo == null ? null : (c2 = this.documentationHoverInfo.createQuickDocComponent(editor2, c1 != null, popupBridge));
        assert (quickDocShownInPopup == (c2 != null));
        if (c1 == null && c2 == null) {
            return null;
        }
        JPanel p = new JPanel(new CombinedPopupLayout(c1, c2));
        p.setBorder(null);
        if (c1 != null) {
            p.add(c1);
        }
        if (c2 != null) {
            p.add(c2);
        }
        return p;
    }

    @NotNull
    public EditorHoverInfo withQuickDoc(@Nullable DocumentationPsiHoverInfo documentationPsiHoverInfo) {
        return new EditorHoverInfo(this.highlightHoverInfo, documentationPsiHoverInfo);
    }

    @NotNull
    public EditorHoverInfo withTooltip(@NotNull TooltipAction tooltipAction) {
        if (tooltipAction == null) {
            EditorHoverInfo.$$$reportNull$$$0(2);
        }
        if (this.highlightHoverInfo == null) {
            EditorHoverInfo editorHoverInfo = this;
            if (editorHoverInfo == null) {
                EditorHoverInfo.$$$reportNull$$$0(3);
            }
            return editorHoverInfo;
        }
        return new EditorHoverInfo(this.highlightHoverInfo.override(tooltipAction), this.documentationHoverInfo);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupBridge";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/EditorHoverInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/EditorHoverInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createComponent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withTooltip";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

