/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.tooltips.TooltipActionProvider;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorMouseHoverPopupManager;
import com.intellij.openapi.editor.PopupBridge;
import com.intellij.openapi.editor.WrapperPanel;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.ex.TooltipAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.WidthBasedLayout;
import com.intellij.ui.popup.AbstractPopup;
import java.awt.Point;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HighlightHoverInfo {
    private static final Key<Boolean> DISABLE_BINDING = Key.create((String)"EditorMouseHoverPopupManager.disable.binding");
    private static final TooltipGroup EDITOR_INFO_GROUP = new TooltipGroup("EDITOR_INFO_GROUP", 0);
    @NotNull
    private final HighlightInfo highlightInfo;
    @Nullable
    private final TooltipAction tooltipAction;

    private HighlightHoverInfo(@NotNull HighlightInfo highlightInfo, @Nullable TooltipAction tooltipAction) {
        if (highlightInfo == null) {
            HighlightHoverInfo.$$$reportNull$$$0(0);
        }
        this.highlightInfo = highlightInfo;
        this.tooltipAction = tooltipAction;
    }

    @Nullable
    JComponent createHighlightInfoComponent(@NotNull Editor editor2, boolean highlightActions, @NotNull PopupBridge popupBridge, boolean requestFocus) {
        ErrorStripTooltipRendererProvider provider2;
        TooltipRenderer tooltipRenderer;
        if (editor2 == null) {
            HighlightHoverInfo.$$$reportNull$$$0(1);
        }
        if (popupBridge == null) {
            HighlightHoverInfo.$$$reportNull$$$0(2);
        }
        if (!((tooltipRenderer = (provider2 = ((EditorMarkupModel)editor2.getMarkupModel()).getErrorStripTooltipRendererProvider()).calcTooltipRenderer(Objects.requireNonNull(this.highlightInfo.getToolTip()), this.tooltipAction, -1)) instanceof LineTooltipRenderer)) {
            return null;
        }
        return HighlightHoverInfo.createHighlightInfoComponent(editor2, (LineTooltipRenderer)tooltipRenderer, highlightActions, popupBridge, requestFocus);
    }

    @Nullable
    private static JComponent createHighlightInfoComponent(@NotNull Editor editor2, @NotNull LineTooltipRenderer renderer2, boolean highlightActions, @NotNull PopupBridge popupBridge, boolean requestFocus) {
        if (editor2 == null) {
            HighlightHoverInfo.$$$reportNull$$$0(3);
        }
        if (renderer2 == null) {
            HighlightHoverInfo.$$$reportNull$$$0(4);
        }
        if (popupBridge == null) {
            HighlightHoverInfo.$$$reportNull$$$0(5);
        }
        Ref wrapperPanelRef = new Ref();
        Ref mockHintRef = new Ref();
        HintHint hintHint = new HintHint().setAwtTooltip(true).setRequestFocus(requestFocus);
        LightweightHint hint = renderer2.createHint(editor2, new Point(), false, EDITOR_INFO_GROUP, hintHint, highlightActions, false, expand -> {
            LineTooltipRenderer newRenderer = renderer2.createRenderer(renderer2.getText(), expand ? 1 : 0);
            JComponent newComponent = HighlightHoverInfo.createHighlightInfoComponent(editor2, newRenderer, highlightActions, popupBridge, requestFocus);
            AbstractPopup popup2 = popupBridge.getPopup();
            WrapperPanel wrapper2 = (WrapperPanel)wrapperPanelRef.get();
            if (newComponent != null && popup2 != null && wrapper2 != null) {
                LightweightHint mockHint = (LightweightHint)mockHintRef.get();
                if (mockHint != null) {
                    HighlightHoverInfo.closeHintIgnoreBinding(mockHint);
                }
                wrapper2.setContent(newComponent);
                EditorMouseHoverPopupManager.validatePopupSize(popup2);
            }
        });
        if (hint == null) {
            return null;
        }
        mockHintRef.set((Object)hint);
        HighlightHoverInfo.bindHintHiding(hint, popupBridge);
        JComponent component2 = hint.getComponent();
        EditorMouseHoverPopupManager.LOG.assertTrue(component2 instanceof WidthBasedLayout, (Object)("Unexpected type of tooltip component: " + component2.getClass()));
        WrapperPanel wrapper2 = new WrapperPanel(component2);
        wrapperPanelRef.set((Object)wrapper2);
        wrapper2.setBackground(hintHint.getTextBackground());
        wrapper2.setOpaque(true);
        return wrapper2;
    }

    private static void bindHintHiding(@NotNull LightweightHint hint, @NotNull PopupBridge popupBridge) {
        if (hint == null) {
            HighlightHoverInfo.$$$reportNull$$$0(6);
        }
        if (popupBridge == null) {
            HighlightHoverInfo.$$$reportNull$$$0(7);
        }
        AtomicBoolean inProcess = new AtomicBoolean();
        hint.addHintListener(e -> {
            if (hint.getUserData(DISABLE_BINDING) == null && inProcess.compareAndSet(false, true)) {
                try {
                    AbstractPopup popup2 = popupBridge.getPopup();
                    if (popup2 != null) {
                        popup2.cancel();
                    }
                }
                finally {
                    inProcess.set(false);
                }
            }
        });
        popupBridge.performOnCancel(() -> {
            if (hint.getUserData(DISABLE_BINDING) == null && inProcess.compareAndSet(false, true)) {
                try {
                    hint.hide();
                }
                finally {
                    inProcess.set(false);
                }
            }
        });
    }

    private static void closeHintIgnoreBinding(@NotNull LightweightHint hint) {
        if (hint == null) {
            HighlightHoverInfo.$$$reportNull$$$0(8);
        }
        hint.putUserData(DISABLE_BINDING, Boolean.TRUE);
        hint.hide();
    }

    @NotNull
    HighlightHoverInfo override(@NotNull TooltipAction tooltipAction) {
        if (tooltipAction == null) {
            HighlightHoverInfo.$$$reportNull$$$0(9);
        }
        return new HighlightHoverInfo(this.highlightInfo, tooltipAction);
    }

    @Nullable
    static HighlightHoverInfo highlightHoverInfo(@NotNull Editor editor2, @Nullable HighlightInfo info2) {
        if (editor2 == null) {
            HighlightHoverInfo.$$$reportNull$$$0(10);
        }
        if (info2 == null || info2.getToolTip() == null) {
            return null;
        }
        try {
            TooltipAction tooltipAction = (TooltipAction)ReadAction.nonBlocking(() -> TooltipActionProvider.calcTooltipAction(info2, editor2)).executeSynchronously();
            return new HighlightHoverInfo(info2, tooltipAction);
        }
        catch (IndexNotReadyException tooltipAction) {
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            EditorMouseHoverPopupManager.LOG.warn((Throwable)e);
        }
        return new HighlightHoverInfo(info2, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfo";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupBridge";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipAction";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/HighlightHoverInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightInfoComponent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "bindHintHiding";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "closeHintIgnoreBinding";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "override";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightHoverInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

