/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.SettingsImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.project.DumbAware;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractToggleUseSoftWrapsAction
extends ToggleAction
implements DumbAware,
LightEditCompatible {
    private final SoftWrapAppliancePlaces myAppliancePlace;
    private final boolean myGlobal;

    public AbstractToggleUseSoftWrapsAction(@NotNull SoftWrapAppliancePlaces appliancePlace, boolean global) {
        if (appliancePlace == null) {
            AbstractToggleUseSoftWrapsAction.$$$reportNull$$$0(0);
        }
        this.myAppliancePlace = appliancePlace;
        this.myGlobal = global;
    }

    public void update(@NotNull AnActionEvent e) {
        EditorSettings settings;
        Editor editor2;
        if (e == null) {
            AbstractToggleUseSoftWrapsAction.$$$reportNull$$$0(1);
        }
        if (this.myGlobal && (editor2 = this.getEditor(e)) != null && (settings = editor2.getSettings()) instanceof SettingsImpl && ((SettingsImpl)settings).getSoftWrapAppliancePlace() != this.myAppliancePlace) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        super.update(e);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractToggleUseSoftWrapsAction.$$$reportNull$$$0(2);
        }
        Editor editor2 = this.getEditor(e);
        if (this.myGlobal) {
            boolean selected2 = EditorSettingsExternalizable.getInstance().isUseSoftWraps(this.myAppliancePlace);
            return selected2 |= editor2 != null && Boolean.TRUE.equals(editor2.getUserData(EditorImpl.FORCED_SOFT_WRAPS));
        }
        return editor2 != null && editor2.getSettings().isUseSoftWraps();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Editor editor2;
        if (e == null) {
            AbstractToggleUseSoftWrapsAction.$$$reportNull$$$0(3);
        }
        if ((editor2 = this.getEditor(e)) == null) {
            return;
        }
        AbstractToggleUseSoftWrapsAction.toggleSoftWraps(editor2, this.myGlobal && !Boolean.TRUE.equals(editor2.getUserData(EditorImpl.FORCED_SOFT_WRAPS)) ? this.myAppliancePlace : null, state);
    }

    public static void toggleSoftWraps(@NotNull Editor editor2, @Nullable SoftWrapAppliancePlaces places, boolean state) {
        if (editor2 == null) {
            AbstractToggleUseSoftWrapsAction.$$$reportNull$$$0(4);
        }
        Point point = editor2.getScrollingModel().getVisibleArea().getLocation();
        LogicalPosition anchorPosition = editor2.xyToLogicalPosition(point);
        int intraLineShift = point.y - editor2.logicalPositionToXY((LogicalPosition)anchorPosition).y;
        if (places != null) {
            EditorSettingsExternalizable.getInstance().setUseSoftWraps(state, places);
            EditorFactory.getInstance().refreshAllEditors();
        }
        if (editor2.getSettings().isUseSoftWraps() != state) {
            editor2.getSettings().setUseSoftWraps(state);
            if (!state && Boolean.TRUE.equals(editor2.getUserData(EditorImpl.FORCED_SOFT_WRAPS))) {
                editor2.putUserData(EditorImpl.FORCED_SOFT_WRAPS, (Object)Boolean.FALSE);
            }
        }
        editor2.getScrollingModel().disableAnimation();
        editor2.getScrollingModel().scrollVertically(editor2.logicalPositionToXY((LogicalPosition)anchorPosition).y + intraLineShift);
        editor2.getScrollingModel().enableAnimation();
    }

    @Nullable
    protected Editor getEditor(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractToggleUseSoftWrapsAction.$$$reportNull$$$0(5);
        }
        return (Editor)e.getData(CommonDataKeys.EDITOR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliancePlace";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/actions/AbstractToggleUseSoftWrapsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "toggleSoftWraps";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

