/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.KillRingUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KillRingSaveAction
extends TextComponentEditorAction {
    public KillRingSaveAction() {
        super(new Handler(false));
    }

    static class Handler
    extends EditorActionHandler {
        private final boolean myRemove;

        Handler(boolean remove2) {
            this.myRemove = remove2;
        }

        public void doExecute(final @NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext) {
            int end;
            SelectionModel selectionModel;
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (!(selectionModel = editor2.getSelectionModel()).hasSelection()) {
                return;
            }
            final int start2 = selectionModel.getSelectionStart();
            if (start2 >= (end = selectionModel.getSelectionEnd())) {
                return;
            }
            KillRingUtil.copyToKillRing(editor2, start2, end, false);
            if (this.myRemove) {
                DocumentRunnable runnable2 = new DocumentRunnable(editor2.getDocument(), editor2.getProject()){

                    public void run() {
                        editor2.getDocument().deleteString(start2, end);
                    }
                };
                if (editor2 instanceof TextComponentEditor) {
                    runnable2.run();
                } else {
                    ApplicationManager.getApplication().runWriteAction((Runnable)runnable2);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/KillRingSaveAction$Handler", "doExecute"));
        }
    }
}

