/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class SelectWordAtCaretAction
extends TextComponentEditorAction
implements DumbAware {
    public SelectWordAtCaretAction() {
        super((EditorActionHandler)new DefaultHandler());
        this.setInjectedContext(true);
    }

    public static class Handler
    extends EditorActionHandler.ForEachCaret {
        private final EditorActionHandler myDefaultHandler;

        public Handler(EditorActionHandler defaultHandler) {
            this.myDefaultHandler = defaultHandler;
        }

        public void doExecute(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
            IndentGuideDescriptor guide;
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            if ((guide = editor2.getIndentsModel().getCaretIndentGuide()) != null && !caret.hasSelection() && Handler.isWhitespaceAtCaret(caret)) {
                Handler.selectWithGuide(caret, guide);
            } else {
                this.myDefaultHandler.execute(editor2, caret, dataContext);
            }
        }

        private static boolean isWhitespaceAtCaret(Caret caret) {
            Document doc = caret.getEditor().getDocument();
            int offset = caret.getOffset();
            if (offset >= doc.getTextLength()) {
                return false;
            }
            char c = doc.getCharsSequence().charAt(offset);
            return c == ' ' || c == '\t' || c == '\n';
        }

        private static void selectWithGuide(Caret caret, IndentGuideDescriptor guide) {
            Editor editor2 = caret.getEditor();
            Document doc = editor2.getDocument();
            int startOffset = editor2.logicalPositionToOffset(new LogicalPosition(guide.startLine, 0));
            int endOffset = guide.endLine >= doc.getLineCount() ? doc.getTextLength() : doc.getLineStartOffset(guide.endLine);
            VirtualFile file2 = ((EditorEx)editor2).getVirtualFile();
            if (file2 != null) {
                CharSequence chars = doc.getCharsSequence();
                int nonWhitespaceOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)endOffset, (String)" \t\n");
                HighlighterIterator iterator2 = editor2.getHighlighter().createIterator(nonWhitespaceOffset);
                if (BraceMatchingUtil.isRBraceToken(iterator2, chars, file2.getFileType()) && editor2.offsetToLogicalPosition((int)iterator2.getStart()).column == guide.indentLevel) {
                    endOffset = iterator2.getEnd();
                    if ((endOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)endOffset, (String)" \t")) < chars.length() && chars.charAt(endOffset) == '\n') {
                        ++endOffset;
                    }
                }
            }
            caret.setSelection(startOffset, endOffset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "caret";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/actions/SelectWordAtCaretAction$Handler";
            objectArray[2] = "doExecute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DefaultHandler
    extends EditorActionHandler.ForEachCaret {
        private DefaultHandler() {
        }

        public void doExecute(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
            if (editor2 == null) {
                DefaultHandler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                DefaultHandler.$$$reportNull$$$0(1);
            }
            assert (caret != null);
            Document document = editor2.getDocument();
            if (EditorUtil.isPasswordEditor(editor2)) {
                caret.setSelection(0, document.getTextLength());
                return;
            }
            int lineNumber = caret.getLogicalPosition().line;
            int caretOffset = caret.getOffset();
            if (lineNumber >= document.getLineCount()) {
                return;
            }
            boolean camel = editor2.getSettings().isCamelWords();
            ArrayList<TextRange> ranges = new ArrayList<TextRange>();
            int textLength = document.getTextLength();
            if (caretOffset == textLength) {
                --caretOffset;
            }
            if (caretOffset < 0) {
                return;
            }
            SelectWordUtil.addWordOrLexemeSelection(camel, editor2, caretOffset, ranges);
            int line = document.getLineNumber(caretOffset);
            ranges.add(new TextRange(document.getLineStartOffset(line), document.getLineEndOffset(line)));
            TextRange selectionRange = new TextRange(caret.getSelectionStart(), caret.getSelectionEnd());
            TextRange minimumRange = new TextRange(0, document.getTextLength());
            for (TextRange range2 : ranges) {
                if (!range2.contains(selectionRange) || range2.equals((Object)selectionRange) || !minimumRange.contains(range2)) continue;
                minimumRange = range2;
            }
            caret.setSelection(minimumRange.getStartOffset(), minimumRange.getEndOffset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "caret";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/actions/SelectWordAtCaretAction$DefaultHandler";
            objectArray[2] = "doExecute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

