/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.textarea.TextComponentEditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextComponentEditorAction
extends EditorAction {
    private final boolean allowSpeedSearch;

    protected TextComponentEditorAction(@NotNull EditorActionHandler defaultHandler) {
        if (defaultHandler == null) {
            TextComponentEditorAction.$$$reportNull$$$0(0);
        }
        this(defaultHandler, true);
    }

    protected TextComponentEditorAction(@NotNull EditorActionHandler defaultHandler, boolean allowSpeedSearch) {
        if (defaultHandler == null) {
            TextComponentEditorAction.$$$reportNull$$$0(1);
        }
        super(defaultHandler);
        this.allowSpeedSearch = allowSpeedSearch;
    }

    @Nullable
    protected Editor getEditor(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            TextComponentEditorAction.$$$reportNull$$$0(2);
        }
        return TextComponentEditorAction.getEditorFromContext(dataContext, this.allowSpeedSearch);
    }

    @Nullable
    public static Editor getEditorFromContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            TextComponentEditorAction.$$$reportNull$$$0(3);
        }
        return TextComponentEditorAction.getEditorFromContext(dataContext, true);
    }

    @Nullable
    private static Editor getEditorFromContext(@NotNull DataContext dataContext, boolean allowSpeedSearch) {
        JTextField field;
        Editor editor2;
        if (dataContext == null) {
            TextComponentEditorAction.$$$reportNull$$$0(4);
        }
        if ((editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) != null) {
            return editor2;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Object data2 = PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        if (data2 instanceof EditorComponentImpl) {
            return null;
        }
        if (data2 instanceof JTextComponent) {
            return new TextComponentEditorImpl(project, (JTextComponent)data2);
        }
        if (allowSpeedSearch && data2 instanceof JComponent && (field = TextComponentEditorAction.findActiveSpeedSearchTextField((JComponent)data2)) != null) {
            return new TextComponentEditorImpl(project, field);
        }
        return null;
    }

    private static JTextField findActiveSpeedSearchTextField(JComponent c) {
        Object component2;
        SpeedSearchSupply supply2 = SpeedSearchSupply.getSupply((JComponent)c);
        if (supply2 instanceof SpeedSearchBase) {
            return ((SpeedSearchBase)supply2).getSearchField();
        }
        if (c instanceof DataProvider && (component2 = PlatformDataKeys.SPEED_SEARCH_COMPONENT.getData((DataProvider)((Object)c))) instanceof JTextField) {
            return (JTextField)component2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/actions/TextComponentEditorAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorFromContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

