/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions.lists;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.editor.actions.lists.JoinOrSplit;
import com.intellij.openapi.editor.actions.lists.ListSplitJoinContext;
import com.intellij.openapi.editor.actions.lists.ListWithElements;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b2\u0006\u0010\f\u001a\u00020\rH\u0014J2\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b2\u0006\u0010\f\u001a\u00020\rH\u0014J*\u0010\u000f\u001a\u00020\u00042\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b2\u0006\u0010\u0010\u001a\u00020\rH\u0002J2\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b2\u0006\u0010\u0012\u001a\u00020\rH\u0014J2\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b2\u0006\u0010\u0012\u001a\u00020\rH\u0014J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\rH&J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\rH\u0004J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\rH\u0014J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\rH\u0004J\u0010\u0010#\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010$\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\rH&J\u0010\u0010%\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010&\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\rH\u0016J \u0010'\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010(\u001a\u00020)H\u0016J \u0010*\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010(\u001a\u00020)H\u0016J\u001a\u0010+\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\rH\u0016J\"\u0010,\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010-\u001a\u00020\"H\u0002J\u001a\u0010.\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\rH\u0016J \u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\n2\u0006\u00103\u001a\u00020)H\u0016J\u0018\u00104\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00105\u001a\u00020\rH\u0002J\u0018\u00106\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\rH\u0004J\u0018\u00107\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00108\u001a\u00020\rH\u0014J \u00109\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010-\u001a\u00020\"H\u0002J\u0010\u0010:\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010;\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010<\u001a\u00020\rH\u0014\u00a8\u0006="}, d2={"Lcom/intellij/openapi/editor/actions/lists/DefaultListSplitJoinContext;", "Lcom/intellij/openapi/editor/actions/lists/ListSplitJoinContext;", "()V", "addHeadReplacementsForJoining", "", "data", "Lcom/intellij/openapi/editor/actions/lists/ListWithElements;", "replacements", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/TextRange;", "", "firstElement", "Lcom/intellij/psi/PsiElement;", "addHeadReplacementsForSplitting", "addSiblingWhitespaceReplacement", "lineBreak", "addTailReplacementsForJoining", "lastElement", "addTailReplacementsForSplitting", "extractData", "context", "extractRange", "", "findOffsetForBreakAfter", "", "element", "getHeadBreakJoinReplacement", "getJoinText", "getReplacementsForJoining", "getReplacementsForSplitting", "getSplitText", "getTailBreakJoinReplacement", "hasSeparatorAfter", "", "isJoinAvailable", "isSeparator", "isSplitAvailable", "isValidIntermediateElement", "needHeadBreak", "mode", "Lcom/intellij/openapi/editor/actions/lists/JoinOrSplit;", "needTailBreak", "nextBreak", "nextPrevBreak", "next", "prevBreak", "reformatRange", "file", "Lcom/intellij/psi/PsiFile;", "rangeToAdjust", "split", "separatorOrNewLineComment", "separator", "skipAcceptableElements", "validateHeadElement", "head", "validateHeadOrTail", "validateRange", "validateTailElement", "tail", "intellij.platform.lang.impl"})
public abstract class DefaultListSplitJoinContext
implements ListSplitJoinContext {
    public abstract boolean isSeparator(@NotNull PsiElement var1);

    @Override
    @Nullable
    public abstract ListWithElements extractData(@NotNull PsiElement var1);

    public boolean isValidIntermediateElement(@NotNull ListWithElements data2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return element2 instanceof PsiWhiteSpace;
    }

    public boolean needHeadBreak(@NotNull ListWithElements data2, @NotNull PsiElement firstElement, @NotNull JoinOrSplit mode) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)firstElement, (String)"firstElement");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return false;
    }

    public boolean needTailBreak(@NotNull ListWithElements data2, @NotNull PsiElement lastElement, @NotNull JoinOrSplit mode) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)lastElement, (String)"lastElement");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return false;
    }

    @Nullable
    public PsiElement prevBreak(@NotNull ListWithElements data2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.nextPrevBreak(data2, element2, false);
    }

    @Nullable
    public PsiElement nextBreak(@NotNull ListWithElements data2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.nextPrevBreak(data2, element2, true);
    }

    @Override
    @NotNull
    public String getSplitText(@NotNull ListWithElements data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        String string = CodeInsightBundle.message((String)"intention.family.name.split.values", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CodeInsightBundle.messag\u2026amily.name.split.values\")");
        return string;
    }

    @Override
    @NotNull
    public String getJoinText(@NotNull ListWithElements data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        String string = CodeInsightBundle.message((String)"intention.family.name.join.values", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CodeInsightBundle.messag\u2026family.name.join.values\")");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSplitAvailable(@NotNull ListWithElements data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (data2.getElements().size() <= 1) return false;
        if (!this.validateRange(data2)) return false;
        Collection collection = this.getReplacementsForSplitting(data2);
        boolean bl = false;
        if (collection.isEmpty()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isJoinAvailable(@NotNull ListWithElements data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (data2.getElements().size() <= 1) return false;
        if (!this.validateRange(data2)) return false;
        Collection collection = this.getReplacementsForJoining(data2);
        boolean bl = false;
        if (collection.isEmpty()) return false;
        return true;
    }

    @Override
    public void reformatRange(@NotNull PsiFile file2, @NotNull TextRange rangeToAdjust, @NotNull JoinOrSplit split2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)rangeToAdjust, (String)"rangeToAdjust");
        Intrinsics.checkNotNullParameter((Object)((Object)split2), (String)"split");
        CodeStyleManager.getInstance((Project)file2.getProject()).adjustLineIndent(file2, rangeToAdjust);
    }

    @Override
    @NotNull
    public List<Pair<TextRange, String>> getReplacementsForSplitting(@NotNull ListWithElements data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        List<PsiElement> elements = data2.getElements();
        boolean bl = false;
        List replacements = new ArrayList();
        PsiElement firstElement = (PsiElement)CollectionsKt.first(elements);
        PsiElement lastElement = (PsiElement)CollectionsKt.last(elements);
        this.addHeadReplacementsForSplitting(data2, replacements, firstElement);
        boolean hasInnerReplacement = false;
        for (PsiElement el : CollectionsKt.dropLast(elements, (int)1)) {
            if (this.nextBreak(data2, el) != null) continue;
            int offset = this.findOffsetForBreakAfter(data2, el);
            TextRange textRange = new TextRange(offset, offset);
            replacements.add(TuplesKt.to((Object)textRange, (Object)"\n"));
            hasInnerReplacement = true;
        }
        if (!hasInnerReplacement) {
            return CollectionsKt.emptyList();
        }
        this.addTailReplacementsForSplitting(data2, replacements, lastElement);
        return replacements;
    }

    @Override
    @NotNull
    public List<Pair<TextRange, String>> getReplacementsForJoining(@NotNull ListWithElements data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        List<PsiElement> elements = data2.getElements();
        boolean bl = false;
        List replacements = new ArrayList();
        PsiElement firstElement = (PsiElement)CollectionsKt.first(elements);
        PsiElement lastElement = (PsiElement)CollectionsKt.last(elements);
        this.addHeadReplacementsForJoining(data2, replacements, firstElement);
        for (PsiElement current2 : CollectionsKt.dropLast(elements, (int)1)) {
            PsiElement nextBreak;
            if (this.nextBreak(data2, current2) == null) {
                continue;
            }
            replacements.add(TuplesKt.to((Object)nextBreak.getTextRange(), (Object)" "));
            this.addSiblingWhitespaceReplacement(replacements, nextBreak);
        }
        this.addTailReplacementsForJoining(data2, replacements, lastElement);
        return replacements;
    }

    protected void addHeadReplacementsForSplitting(@NotNull ListWithElements data2, @NotNull List<Pair<TextRange, String>> replacements, @NotNull PsiElement firstElement) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
        Intrinsics.checkNotNullParameter((Object)firstElement, (String)"firstElement");
        if (this.needHeadBreak(data2, firstElement, JoinOrSplit.SPLIT) && this.prevBreak(data2, firstElement) == null) {
            TextRange textRange = firstElement.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"firstElement.textRange");
            int offset = textRange.getStartOffset();
            replacements.add((Pair<TextRange, String>)TuplesKt.to((Object)new TextRange(offset, offset), (Object)"\n"));
        }
    }

    protected void addHeadReplacementsForJoining(@NotNull ListWithElements data2, @NotNull List<Pair<TextRange, String>> replacements, @NotNull PsiElement firstElement) {
        PsiElement prevBreak;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
        Intrinsics.checkNotNullParameter((Object)firstElement, (String)"firstElement");
        if (!this.needHeadBreak(data2, firstElement, JoinOrSplit.JOIN) && (prevBreak = this.prevBreak(data2, firstElement)) != null) {
            replacements.add((Pair<TextRange, String>)TuplesKt.to((Object)prevBreak.getTextRange(), (Object)this.getHeadBreakJoinReplacement(firstElement)));
            this.addSiblingWhitespaceReplacement(replacements, prevBreak);
        }
    }

    protected void addTailReplacementsForSplitting(@NotNull ListWithElements data2, @NotNull List<Pair<TextRange, String>> replacements, @NotNull PsiElement lastElement) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
        Intrinsics.checkNotNullParameter((Object)lastElement, (String)"lastElement");
        if (this.nextBreak(data2, lastElement) == null && this.needTailBreak(data2, lastElement, JoinOrSplit.SPLIT)) {
            int offset = this.findOffsetForBreakAfter(data2, lastElement);
            replacements.add((Pair<TextRange, String>)TuplesKt.to((Object)new TextRange(offset, offset), (Object)"\n"));
        }
    }

    protected void addTailReplacementsForJoining(@NotNull ListWithElements data2, @NotNull List<Pair<TextRange, String>> replacements, @NotNull PsiElement lastElement) {
        PsiElement nextBreak;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
        Intrinsics.checkNotNullParameter((Object)lastElement, (String)"lastElement");
        if (!this.needTailBreak(data2, lastElement, JoinOrSplit.JOIN) && (nextBreak = this.nextBreak(data2, lastElement)) != null) {
            replacements.add((Pair<TextRange, String>)TuplesKt.to((Object)nextBreak.getTextRange(), (Object)this.getTailBreakJoinReplacement(lastElement)));
            this.addSiblingWhitespaceReplacement(replacements, nextBreak);
        }
    }

    @NotNull
    protected String getTailBreakJoinReplacement(@NotNull PsiElement lastElement) {
        Intrinsics.checkNotNullParameter((Object)lastElement, (String)"lastElement");
        return "";
    }

    @NotNull
    protected String getHeadBreakJoinReplacement(@NotNull PsiElement firstElement) {
        Intrinsics.checkNotNullParameter((Object)firstElement, (String)"firstElement");
        return "";
    }

    protected final int findOffsetForBreakAfter(@NotNull ListWithElements data2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement after2 = this.skipAcceptableElements(data2, element2);
        if (this.isSeparator(after2)) {
            TextRange textRange = this.separatorOrNewLineComment(data2, after2).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"separatorOrNewLineComment(data, after).textRange");
            return textRange.getEndOffset();
        }
        TextRange textRange = after2.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"after.textRange");
        return textRange.getEndOffset();
    }

    protected final boolean hasSeparatorAfter(@NotNull ListWithElements data2, @NotNull PsiElement lastElement) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)lastElement, (String)"lastElement");
        PsiElement afterWhitespaces = this.skipAcceptableElements(data2, lastElement);
        return this.isSeparator(afterWhitespaces);
    }

    @NotNull
    protected final PsiElement skipAcceptableElements(@NotNull ListWithElements data2, @NotNull PsiElement element2) {
        PsiElement nextCandidate;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement curr = element2;
        while ((nextCandidate = curr.getNextSibling()) != null && this.isValidIntermediateElement(data2, nextCandidate)) {
            curr = nextCandidate;
        }
        PsiElement next = curr.getNextSibling();
        return next != null && this.isSeparator(next) ? next : curr;
    }

    private final void addSiblingWhitespaceReplacement(List<Pair<TextRange, String>> replacements, PsiElement lineBreak) {
        PsiElement nextSibling = lineBreak.getNextSibling();
        if (nextSibling instanceof PsiWhiteSpace) {
            replacements.add((Pair<TextRange, String>)TuplesKt.to((Object)((PsiWhiteSpace)nextSibling).getTextRange(), (Object)""));
        }
    }

    private final PsiElement nextPrevBreak(ListWithElements data2, PsiElement element2, boolean next) {
        PsiElement current2;
        PsiElement psiElement = current2 = next ? element2.getNextSibling() : element2.getPrevSibling();
        while (current2 != null && (this.isValidIntermediateElement(data2, current2) || this.isSeparator(current2))) {
            if (current2 instanceof PsiWhiteSpace && current2.textContains('\n')) {
                return current2;
            }
            current2 = next ? current2.getNextSibling() : current2.getPrevSibling();
        }
        return null;
    }

    private final boolean validateRange(ListWithElements data2) {
        boolean bl;
        block3: {
            Set elements = CollectionsKt.toSet((Iterable)data2.getElements());
            Iterable $this$all$iv = this.extractRange(data2);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (elements.contains(it) || this.isSeparator(it) || this.isValidIntermediateElement(data2, it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl && this.validateHeadElement(data2, (PsiElement)CollectionsKt.first(data2.getElements())) && this.validateTailElement(data2, (PsiElement)CollectionsKt.last(data2.getElements()));
    }

    protected boolean validateHeadElement(@NotNull ListWithElements data2, @NotNull PsiElement head) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        return this.validateHeadOrTail(data2, head, false);
    }

    protected boolean validateTailElement(@NotNull ListWithElements data2, @NotNull PsiElement tail) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)tail, (String)"tail");
        return this.validateHeadOrTail(data2, tail, true);
    }

    private final boolean validateHeadOrTail(ListWithElements data2, PsiElement element2, boolean next) {
        PsiElement psiElement;
        boolean bl = next;
        if (bl) {
            psiElement = element2.getNextSibling();
        } else if (!bl) {
            psiElement = element2.getPrevSibling();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        PsiElement current2 = psiElement;
        while (current2 != null) {
            PsiElement psiElement2;
            if (current2 instanceof PsiComment) {
                if (!this.isValidIntermediateElement(data2, current2)) {
                    return false;
                }
            } else if (!(current2 instanceof PsiWhiteSpace)) break;
            if (bl = next) {
                psiElement2 = current2.getNextSibling();
            } else if (!bl) {
                psiElement2 = current2.getPrevSibling();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            current2 = psiElement2;
        }
        return true;
    }

    private final List<PsiElement> extractRange(ListWithElements data2) {
        boolean bl = false;
        List mutableList = new ArrayList();
        boolean collectStart = false;
        PsiElement startElement = (PsiElement)CollectionsKt.first(data2.getElements());
        PsiElement endElement = (PsiElement)CollectionsKt.last(data2.getElements());
        for (PsiElement curr = data2.getList().getFirstChild(); curr != null; curr = curr.getNextSibling()) {
            if (!collectStart) {
                if (!Intrinsics.areEqual((Object)startElement, (Object)curr)) continue;
                collectStart = true;
                continue;
            }
            mutableList.add(curr);
            if (Intrinsics.areEqual((Object)curr, (Object)endElement)) break;
        }
        return mutableList;
    }

    private final PsiElement separatorOrNewLineComment(ListWithElements data2, PsiElement separator2) {
        PsiElement candidate;
        PsiElement next = separator2;
        while ((candidate = next.getNextSibling()) instanceof PsiWhiteSpace) {
            if (candidate.textContains('\n')) {
                return separator2;
            }
            next = candidate;
        }
        if (candidate instanceof PsiComment && this.isValidIntermediateElement(data2, candidate) && candidate.textContains('\n')) {
            return candidate;
        }
        return separator2;
    }
}

