/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions.lists;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actions.lists.JoinOrSplit;
import com.intellij.openapi.editor.actions.lists.ListSplitJoinContext;
import com.intellij.openapi.editor.actions.lists.ListSplitJoinContextKt;
import com.intellij.openapi.editor.actions.lists.ListWithElements;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH%J0\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J*\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00050\u000b0\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH$J#\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0019\u001a\u00020\u001aH$J\"\u0010\u001b\u001a\u00020\u00162\u0018\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00050\u000b0\u0013H\u0014\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/editor/actions/lists/SplitJoinIntention;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "getIntentionText", "", "splitJoinContext", "Lcom/intellij/openapi/editor/actions/lists/ListSplitJoinContext;", "data", "Lcom/intellij/openapi/editor/actions/lists/ListWithElements;", "getListSplitJoinContext", "Lkotlin/Pair;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "getReplacements", "", "Lcom/intellij/openapi/util/TextRange;", "invoke", "", "isAvailable", "", "operation", "Lcom/intellij/openapi/editor/actions/lists/JoinOrSplit;", "validateOrder", "replacements", "Companion", "intellij.platform.lang.impl"})
public abstract class SplitJoinIntention
extends PsiElementBaseIntentionAction
implements LowPriorityAction {
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @NotNull
    protected abstract JoinOrSplit operation();

    @IntentionName
    @NotNull
    protected abstract String getIntentionText(@NotNull ListSplitJoinContext var1, @NotNull ListWithElements var2);

    @NotNull
    protected abstract List<Pair<TextRange, String>> getReplacements(@NotNull ListSplitJoinContext var1, @NotNull ListWithElements var2);

    /*
     * WARNING - void declaration
     */
    public final boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element2) {
        void splitJoinContext;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Pair<ListSplitJoinContext, ListWithElements> pair = this.getListSplitJoinContext(project, editor2, element2);
        if (pair == null) {
            return false;
        }
        Pair<ListSplitJoinContext, ListWithElements> pair2 = pair;
        ListSplitJoinContext listSplitJoinContext = (ListSplitJoinContext)pair2.component1();
        ListWithElements data2 = (ListWithElements)pair2.component2();
        this.setText(this.getIntentionText((ListSplitJoinContext)splitJoinContext, data2));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element2) {
        void splitJoinContext;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Pair<ListSplitJoinContext, ListWithElements> pair = this.getListSplitJoinContext(project, editor2, element2);
        if (pair == null) {
            return;
        }
        Pair<ListSplitJoinContext, ListWithElements> pair2 = pair;
        ListSplitJoinContext listSplitJoinContext = (ListSplitJoinContext)pair2.component1();
        ListWithElements data2 = (ListWithElements)pair2.component2();
        PsiElement list2 = data2.getList();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = Companion.extractDocument(project, editor2, element2);
        if (document == null) {
            return;
        }
        Document document2 = document;
        RangeMarker rangeMarker = document2.createRangeMarker(list2.getTextRange());
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"document.createRangeMarker(list.textRange)");
        RangeMarker marker = rangeMarker;
        PsiFile containingFile = element2.getContainingFile();
        List<Pair<TextRange, String>> replacements = this.getReplacements((ListSplitJoinContext)splitJoinContext, data2);
        for (Pair pair3 : CollectionsKt.reversed((Iterable)replacements)) {
            void range2;
            TextRange textRange = (TextRange)pair3.component1();
            String text2 = (String)pair3.component2();
            document2.replaceString(range2.getStartOffset(), range2.getEndOffset(), (CharSequence)text2);
        }
        documentManager.commitDocument(document2);
        if (marker.isValid()) {
            PsiFile psiFile = containingFile;
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"containingFile");
            TextRange textRange = TextRange.create((Segment)((Segment)marker));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"TextRange.create(marker)");
            splitJoinContext.reformatRange(psiFile, textRange, this.operation());
        }
    }

    protected void validateOrder(@NotNull List<? extends Pair<? extends TextRange, String>> replacements) {
        Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
        TextRange prev2 = null;
        for (Pair<? extends TextRange, String> pair : replacements) {
            TextRange range2 = (TextRange)pair.component1();
            if (prev2 != null && range2.getStartOffset() < prev2.getEndOffset()) {
                logger.error("Incorrect replacements order. The ranges must be sorted");
                break;
            }
            prev2 = range2;
        }
    }

    @Nullable
    protected Pair<ListSplitJoinContext, ListWithElements> getListSplitJoinContext(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return ListSplitJoinContextKt.getListSplitJoinContext(element2, this.operation());
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(SplitJoinIntention.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(SplitJoinIntention::class.java)");
        SplitJoinIntention.logger = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/editor/actions/lists/SplitJoinIntention$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "extractDocument", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @Nullable
        public final Document extractDocument(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            Editor editor3 = editor2;
            if (editor3 == null || (editor3 = editor3.getDocument()) == null) {
                editor3 = documentManager.getDocument(element2.getContainingFile());
            }
            return editor3;
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

