/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.formatting.FormatConstants;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LanguageLineWrapPositionStrategy;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.util.EditorFacade;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.MathUtil;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EditorFacadeImpl
extends EditorFacade {
    private static final String WRAP_LINE_COMMAND_NAME = "AutoWrapLongLine";

    public void runWithAnimationDisabled(@NotNull Editor editor2, @NotNull Runnable taskWithScrolling) {
        if (editor2 == null) {
            EditorFacadeImpl.$$$reportNull$$$0(0);
        }
        if (taskWithScrolling == null) {
            EditorFacadeImpl.$$$reportNull$$$0(1);
        }
        EditorUtil.runWithAnimationDisabled(editor2, taskWithScrolling);
    }

    public void undo(@NotNull Project project, @NotNull FileEditor editor2, @NotNull Document document, long modificationStamp) {
        if (project == null) {
            EditorFacadeImpl.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            EditorFacadeImpl.$$$reportNull$$$0(3);
        }
        if (document == null) {
            EditorFacadeImpl.$$$reportNull$$$0(4);
        }
        UndoManager manager2 = UndoManager.getInstance((Project)project);
        while (manager2.isUndoAvailable(editor2) && document.getModificationStamp() != modificationStamp) {
            manager2.undo(editor2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrapLongLinesIfNecessary(@NotNull PsiFile file2, @NotNull Document document, int startOffset, int endOffset, List<? extends TextRange> enabledRanges, int rightMargin) {
        VirtualFile vFile;
        if (file2 == null) {
            EditorFacadeImpl.$$$reportNull$$$0(5);
        }
        if (document == null) {
            EditorFacadeImpl.$$$reportNull$$$0(6);
        }
        if (((vFile = FileDocumentManager.getInstance().getFile(document)) == null || vFile instanceof LightVirtualFile) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Editor editor2 = PsiEditorUtil.findEditor((PsiElement)file2);
        EditorFactory editorFactory = null;
        if (editor2 == null) {
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                return;
            }
            editorFactory = EditorFactory.getInstance();
            editor2 = editorFactory.createEditor(document, file2.getProject(), file2.getVirtualFile(), false);
        }
        try {
            Editor editorToUse = editor2;
            ApplicationManager.getApplication().runWriteAction(() -> {
                CaretModel caretModel = editorToUse.getCaretModel();
                int caretOffset = caretModel.getOffset();
                RangeMarker caretMarker = editorToUse.getDocument().createRangeMarker(caretOffset, caretOffset);
                this.doWrapLongLinesIfNecessary(editorToUse, file2.getProject(), editorToUse.getDocument(), startOffset, endOffset, enabledRanges, rightMargin);
                if (caretMarker.isValid() && caretModel.getOffset() != caretMarker.getStartOffset()) {
                    caretModel.moveToOffset(caretMarker.getStartOffset());
                }
            });
        }
        finally {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file2.getProject());
            if (documentManager.isUncommited(document)) {
                documentManager.commitDocument(document);
            }
            if (editorFactory != null) {
                editorFactory.releaseEditor(editor2);
            }
        }
    }

    public void doWrapLongLinesIfNecessary(@NotNull Editor editor2, @NotNull Project project, @NotNull Document document, int startOffset, int endOffset, List<? extends TextRange> enabledRanges, int rightMargin) {
        if (editor2 == null) {
            EditorFacadeImpl.$$$reportNull$$$0(7);
        }
        if (project == null) {
            EditorFacadeImpl.$$$reportNull$$$0(8);
        }
        if (document == null) {
            EditorFacadeImpl.$$$reportNull$$$0(9);
        }
        int startOffsetToUse = MathUtil.clamp((int)startOffset, (int)0, (int)document.getTextLength());
        int endOffsetToUse = MathUtil.clamp((int)endOffset, (int)0, (int)document.getTextLength());
        LineWrapPositionStrategy strategy = LanguageLineWrapPositionStrategy.INSTANCE.forEditor(editor2);
        CharSequence text2 = document.getCharsSequence();
        int startLine = document.getLineNumber(startOffsetToUse);
        int endLine = document.getLineNumber(Math.max(0, endOffsetToUse - 1));
        int maxLine = Math.min(document.getLineCount(), endLine + 1);
        int tabSize = EditorUtil.getTabSize(editor2);
        if (tabSize <= 0) {
            tabSize = 1;
        }
        int spaceSize = EditorUtil.getSpaceWidth(0, editor2);
        int[] shifts = new int[2];
        int cumulativeShift = 0;
        for (int line = startLine; line < maxLine; ++line) {
            int preferredWrapPosition;
            int startLineOffset = document.getLineStartOffset(line);
            int endLineOffset = document.getLineEndOffset(line);
            if (!EditorFacadeImpl.canWrapLine(Math.max(startOffsetToUse, startLineOffset), Math.min(endOffsetToUse, endLineOffset), cumulativeShift, enabledRanges) || (preferredWrapPosition = EditorFacadeImpl.calculatePreferredWrapPosition(editor2, text2, tabSize, spaceSize, startLineOffset, endLineOffset, endOffsetToUse, rightMargin)) < 0 || preferredWrapPosition >= endLineOffset) continue;
            if (preferredWrapPosition >= endOffsetToUse) {
                return;
            }
            int wrapOffset = strategy.calculateWrapPosition(document, editor2.getProject(), Math.max(startLineOffset, startOffsetToUse), Math.min(endLineOffset, endOffsetToUse), preferredWrapPosition, false, false);
            if (wrapOffset < 0 || CharArrayUtil.shiftBackward((CharSequence)text2, (int)startLineOffset, (int)(wrapOffset - 1), (String)" \t") < startLineOffset) continue;
            editor2.getCaretModel().moveToOffset(wrapOffset);
            EditorFacadeImpl.emulateEnter(editor2, project, shifts);
            if (shifts[1] - 1 >= wrapOffset - startLineOffset) {
                document.deleteString(wrapOffset, wrapOffset + shifts[1]);
                continue;
            }
            maxLine += shifts[0];
            endOffsetToUse += shifts[1];
            cumulativeShift += shifts[1];
        }
    }

    private static boolean canWrapLine(int startOffset, int endOffset, int offsetShift, @NotNull List<? extends TextRange> enabledRanges) {
        if (enabledRanges == null) {
            EditorFacadeImpl.$$$reportNull$$$0(10);
        }
        for (TextRange textRange : enabledRanges) {
            if (!textRange.containsOffset(startOffset - offsetShift) || !textRange.containsOffset(endOffset - offsetShift)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void emulateEnter(@NotNull Editor editor2, @NotNull Project project, int[] shifts) {
        if (editor2 == null) {
            EditorFacadeImpl.$$$reportNull$$$0(11);
        }
        if (project == null) {
            EditorFacadeImpl.$$$reportNull$$$0(12);
        }
        DataContext dataContext = EditorFacadeImpl.prepareContext(editor2.getComponent(), project);
        int caretOffset = editor2.getCaretModel().getOffset();
        Document document = editor2.getDocument();
        SelectionModel selectionModel = editor2.getSelectionModel();
        int startSelectionOffset = 0;
        int endSelectionOffset = 0;
        boolean restoreSelection = selectionModel.hasSelection();
        if (restoreSelection) {
            startSelectionOffset = selectionModel.getSelectionStart();
            endSelectionOffset = selectionModel.getSelectionEnd();
            selectionModel.removeSelection();
        }
        int textLengthBeforeWrap = document.getTextLength();
        int lineCountBeforeWrap = document.getLineCount();
        DataManager.getInstance().saveInDataContext(dataContext, WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY, (Object)true);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        try {
            Runnable command = () -> EditorActionManager.getInstance().getActionHandler("EditorEnter").execute(editor2, editor2.getCaretModel().getCurrentCaret(), dataContext);
            if (commandProcessor.getCurrentCommand() == null) {
                commandProcessor.executeCommand(editor2.getProject(), command, WRAP_LINE_COMMAND_NAME, null);
            } else {
                command.run();
            }
        }
        finally {
            DataManager.getInstance().saveInDataContext(dataContext, WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY, null);
        }
        int symbolsDiff = document.getTextLength() - textLengthBeforeWrap;
        if (restoreSelection) {
            int newSelectionStart = startSelectionOffset;
            int newSelectionEnd = endSelectionOffset;
            if (startSelectionOffset >= caretOffset) {
                newSelectionStart += symbolsDiff;
            }
            if (endSelectionOffset >= caretOffset) {
                newSelectionEnd += symbolsDiff;
            }
            selectionModel.setSelection(newSelectionStart, newSelectionEnd);
        }
        shifts[0] = document.getLineCount() - lineCountBeforeWrap;
        shifts[1] = symbolsDiff;
    }

    private static int calculatePreferredWrapPosition(@NotNull Editor editor2, @NotNull CharSequence text2, int tabSize, int spaceSize, int startLineOffset, int endLineOffset, int targetRangeEndOffset, int rightMargin) {
        if (editor2 == null) {
            EditorFacadeImpl.$$$reportNull$$$0(13);
        }
        if (text2 == null) {
            EditorFacadeImpl.$$$reportNull$$$0(14);
        }
        boolean hasTabs = false;
        boolean canOptimize = true;
        boolean hasNonSpaceSymbols = false;
        block4: for (int i2 = startLineOffset; i2 < Math.min(endLineOffset, targetRangeEndOffset); ++i2) {
            char c = text2.charAt(i2);
            switch (c) {
                case '\t': {
                    hasTabs = true;
                    if (hasNonSpaceSymbols) {
                        canOptimize = false;
                        break block4;
                    }
                }
                case ' ': {
                    continue block4;
                }
                default: {
                    hasNonSpaceSymbols = true;
                }
            }
        }
        int reservedWidthInColumns = FormatConstants.getReservedLineWrapWidthInColumns(editor2);
        if (!hasTabs) {
            return EditorFacadeImpl.wrapPositionForTextWithoutTabs(startLineOffset, endLineOffset, targetRangeEndOffset, reservedWidthInColumns, rightMargin);
        }
        if (canOptimize) {
            return EditorFacadeImpl.wrapPositionForTabbedTextWithOptimization(text2, tabSize, startLineOffset, endLineOffset, targetRangeEndOffset, reservedWidthInColumns, rightMargin);
        }
        return EditorFacadeImpl.wrapPositionForTabbedTextWithoutOptimization(editor2, text2, spaceSize, startLineOffset, endLineOffset, targetRangeEndOffset, reservedWidthInColumns, rightMargin);
    }

    private static int wrapPositionForTextWithoutTabs(int startLineOffset, int endLineOffset, int targetRangeEndOffset, int reservedWidthInColumns, int rightMargin) {
        if (Math.min(endLineOffset, targetRangeEndOffset) - startLineOffset > rightMargin) {
            return startLineOffset + rightMargin - reservedWidthInColumns;
        }
        return -1;
    }

    private static int wrapPositionForTabbedTextWithOptimization(@NotNull CharSequence text2, int tabSize, int startLineOffset, int endLineOffset, int targetRangeEndOffset, int reservedWidthInColumns, int rightMargin) {
        if (text2 == null) {
            EditorFacadeImpl.$$$reportNull$$$0(15);
        }
        int width = 0;
        int result2 = Integer.MAX_VALUE;
        boolean wrapLine = false;
        for (int i2 = startLineOffset; i2 < Math.min(endLineOffset, targetRangeEndOffset); ++i2) {
            int symbolWidth;
            char c = text2.charAt(i2);
            int n = symbolWidth = c == '\t' ? tabSize - width % tabSize : 1;
            if (width + symbolWidth + reservedWidthInColumns >= rightMargin && Math.min(endLineOffset, targetRangeEndOffset) - i2 >= reservedWidthInColumns) {
                result2 = i2 - 1;
            }
            if (width + symbolWidth >= rightMargin) {
                wrapLine = true;
                break;
            }
            width += symbolWidth;
        }
        return wrapLine ? result2 : -1;
    }

    private static int wrapPositionForTabbedTextWithoutOptimization(@NotNull Editor editor2, @NotNull CharSequence text2, int spaceSize, int startLineOffset, int endLineOffset, int targetRangeEndOffset, int reservedWidthInColumns, int rightMargin) {
        if (editor2 == null) {
            EditorFacadeImpl.$$$reportNull$$$0(16);
        }
        if (text2 == null) {
            EditorFacadeImpl.$$$reportNull$$$0(17);
        }
        int width = 0;
        int x = 0;
        int result2 = Integer.MAX_VALUE;
        boolean wrapLine = false;
        for (int i2 = startLineOffset; i2 < Math.min(endLineOffset, targetRangeEndOffset); ++i2) {
            int symbolWidth;
            int newX;
            char c = text2.charAt(i2);
            if (c == '\t') {
                newX = EditorUtil.nextTabStop(x, editor2);
                int diffInPixels = newX - x;
                symbolWidth = diffInPixels / spaceSize;
                if (diffInPixels % spaceSize > 0) {
                    ++symbolWidth;
                }
            } else {
                newX = x + EditorUtil.charWidth(c, 0, editor2);
                symbolWidth = 1;
            }
            if (width + symbolWidth + reservedWidthInColumns >= rightMargin && Math.min(endLineOffset, targetRangeEndOffset) - i2 >= reservedWidthInColumns) {
                result2 = i2 - 1;
            }
            if (width + symbolWidth >= rightMargin) {
                wrapLine = true;
                break;
            }
            x = newX;
            width += symbolWidth;
        }
        return wrapLine ? result2 : -1;
    }

    @NotNull
    private static DataContext prepareContext(@NotNull Component component2, final @NotNull Project project) {
        if (component2 == null) {
            EditorFacadeImpl.$$$reportNull$$$0(18);
        }
        if (project == null) {
            EditorFacadeImpl.$$$reportNull$$$0(19);
        }
        final DataContext baseDataContext = DataManager.getInstance().getDataContext(component2);
        return new DelegatingDataContext(baseDataContext){

            @Override
            public Object getData(@NotNull @NonNls String dataId) {
                Object result2;
                if (dataId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((result2 = baseDataContext.getData(dataId)) == null && CommonDataKeys.PROJECT.is(dataId)) {
                    result2 = project;
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/openapi/editor/ex/util/EditorFacadeImpl$1", "getData"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskWithScrolling";
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledRanges";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/ex/util/EditorFacadeImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithAnimationDisabled";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "undo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapLongLinesIfNecessary";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "doWrapLongLinesIfNecessary";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "canWrapLine";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "emulateEnter";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "calculatePreferredWrapPosition";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapPositionForTabbedTextWithOptimization";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapPositionForTabbedTextWithoutOptimization";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DelegatingDataContext
    implements DataContext,
    UserDataHolder {
        private final DataContext myDataContextDelegate;
        private final UserDataHolder myDataHolderDelegate;

        DelegatingDataContext(DataContext delegate2) {
            this.myDataContextDelegate = delegate2;
            this.myDataHolderDelegate = delegate2 instanceof UserDataHolder ? (UserDataHolder)delegate2 : null;
        }

        @Override
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                DelegatingDataContext.$$$reportNull$$$0(0);
            }
            return this.myDataContextDelegate.getData(dataId);
        }

        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                DelegatingDataContext.$$$reportNull$$$0(1);
            }
            return (T)(this.myDataHolderDelegate == null ? null : this.myDataHolderDelegate.getUserData(key));
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            if (key == null) {
                DelegatingDataContext.$$$reportNull$$$0(2);
            }
            if (this.myDataHolderDelegate != null) {
                this.myDataHolderDelegate.putUserData(key, value2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/ex/util/EditorFacadeImpl$DelegatingDataContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUserData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putUserData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

