/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

@Service
public final class EditorMouseHoverPopupControl {
    private static final Logger LOG = Logger.getInstance(EditorMouseHoverPopupControl.class);
    private static final Key<Integer> MOUSE_TRACKING_DISABLED_COUNT = Key.create((String)"MOUSE_TRACKING_DISABLED_COUNT");
    private final Collection<Runnable> listeners = new CopyOnWriteArrayList<Runnable>();

    public static EditorMouseHoverPopupControl getInstance() {
        return (EditorMouseHoverPopupControl)ApplicationManager.getApplication().getService(EditorMouseHoverPopupControl.class);
    }

    public static void disablePopups(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(0);
        }
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)editor2, true);
    }

    public static void enablePopups(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(1);
        }
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)editor2, false);
    }

    public static void disablePopups(@NotNull Document document) {
        if (document == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(2);
        }
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)document, true);
    }

    public static void enablePopups(@NotNull Document document) {
        if (document == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(3);
        }
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)document, false);
    }

    public static void disablePopups(@NotNull Project project) {
        if (project == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(4);
        }
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)project, true);
    }

    public static void enablePopups(@NotNull Project project) {
        if (project == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(5);
        }
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)project, false);
    }

    private static void setTrackingDisabled(@NotNull UserDataHolder holder, boolean value2) {
        EditorMouseHoverPopupControl instance2;
        if (holder == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Integer userData = (Integer)holder.getUserData(MOUSE_TRACKING_DISABLED_COUNT);
        int count = (userData == null ? 0 : userData) + (value2 ? 1 : -1);
        if (count < 0) {
            LOG.warn((Throwable)new IllegalStateException("Editor mouse hover popups weren't disabled previously"));
            count = 0;
        }
        holder.putUserData(MOUSE_TRACKING_DISABLED_COUNT, (Object)(count == 0 ? null : Integer.valueOf(count)));
        if (userData == null != (count == 0) && (instance2 = EditorMouseHoverPopupControl.getInstance()) != null) {
            instance2.listeners.forEach(Runnable::run);
        }
    }

    public static boolean arePopupsDisabled(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Project project = editor2.getProject();
        return editor2.getUserData(MOUSE_TRACKING_DISABLED_COUNT) != null || editor2.getDocument().getUserData(MOUSE_TRACKING_DISABLED_COUNT) != null || project != null && project.getUserData(MOUSE_TRACKING_DISABLED_COUNT) != null;
    }

    public void addListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(8);
        }
        this.listeners.add(listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMouseHoverPopupControl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "disablePopups";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "enablePopups";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setTrackingDisabled";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "arePopupsDisabled";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

