/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.impl.FontFamilyService;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.font.Font2D;

final class FontFamilyServiceImpl
extends FontFamilyService {
    private static final Logger LOG = Logger.getInstance(FontFamilyServiceImpl.class);
    private static final boolean VERBOSE_LOGGING = Boolean.getBoolean("font.family.service.verbose");
    private static final Method GET_FONT_2D_METHOD = ReflectionUtil.getDeclaredMethod(Font.class, (String)"getFont2D", (Class[])new Class[0]);
    private static final Method GET_TYPO_FAMILY_METHOD = FontFamilyServiceImpl.getFont2DMethod("getTypographicFamilyName");
    private static final Method GET_TYPO_SUBFAMILY_METHOD = FontFamilyServiceImpl.getFont2DMethod("getTypographicSubfamilyName");
    private static final Method GET_WEIGHT_METHOD = FontFamilyServiceImpl.getFont2DMethod("getWeight");
    private static final AffineTransform SYNTHETIC_ITALICS_TRANSFORM = AffineTransform.getShearInstance(-0.2, 0.0);
    private static final int PREFERRED_MAIN_WEIGHT = 400;
    private static final int PREFERRED_BOLD_WEIGHT_DIFF = 300;
    private static final String[] ITALIC_NAMES = new String[]{"italic", "oblique", "inclined"};
    private static final Map<String, String[]> FIRA_CODE_MIGRATION_MAP = Map.of("Fira Code Light", new String[]{"Fira Code", "Light", "Light"}, "Fira Code Medium", new String[]{"Fira Code", "Medium", "Medium"}, "Fira Code Retina", new String[]{"Fira Code", "Retina", "Retina"});
    private final SortedMap<String, FontFamily> myFamilies = new TreeMap<String, FontFamily>();

    private FontFamilyServiceImpl() {
        if (ApplicationManager.getApplication().isUnitTestMode() || !AppEditorFontOptions.NEW_FONT_SELECTOR) {
            return;
        }
        if (GET_FONT_2D_METHOD == null || GET_TYPO_FAMILY_METHOD == null || GET_TYPO_SUBFAMILY_METHOD == null || GET_WEIGHT_METHOD == null) {
            LOG.warn("Couldn't access required runtime API, will fall back to basic logic of font selection");
            return;
        }
        try {
            Font[] fonts;
            for (Font font : fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
                Font2D font2D = (Font2D)GET_FONT_2D_METHOD.invoke((Object)font, new Object[0]);
                String fontName = font.getName();
                String font2DName = font2D.getFontName(null);
                if (font2DName.startsWith("Dialog") && !fontName.startsWith("Dialog")) {
                    if (!VERBOSE_LOGGING) continue;
                    LOG.info("Skipping '" + fontName + "' as it's mapped to '" + font2DName + "' by the runtime");
                    continue;
                }
                String family = (String)GET_TYPO_FAMILY_METHOD.invoke((Object)font2D, new Object[0]);
                String subfamily = (String)GET_TYPO_SUBFAMILY_METHOD.invoke((Object)font2D, new Object[0]);
                FontFamily fontFamily = this.myFamilies.computeIfAbsent(family, x$0 -> new FontFamily((String)x$0));
                fontFamily.addFont(subfamily, font);
            }
        }
        catch (Throwable e) {
            LOG.error(e);
            this.myFamilies.clear();
        }
    }

    @Override
    protected boolean isSupportedImpl() {
        return !this.myFamilies.isEmpty();
    }

    @Override
    @NotNull
    protected List<String> getAvailableFamiliesImpl() {
        return this.myFamilies.isEmpty() ? super.getAvailableFamiliesImpl() : new ArrayList<String>(this.myFamilies.keySet());
    }

    @Override
    protected boolean isMonospacedImpl(@NotNull String family) {
        FontFamily fontFamily;
        if (family == null) {
            FontFamilyServiceImpl.$$$reportNull$$$0(0);
        }
        return (fontFamily = (FontFamily)this.myFamilies.get(family)) == null ? super.isMonospacedImpl(family) : fontFamily.isMonospaced();
    }

    @Override
    @NotNull
    protected @NotNull List<@NotNull String> getSubFamiliesImpl(@NotNull String family) {
        FontFamily fontFamily;
        if (family == null) {
            FontFamilyServiceImpl.$$$reportNull$$$0(1);
        }
        List<String> list2 = (fontFamily = (FontFamily)this.myFamilies.get(family)) == null ? super.getSubFamiliesImpl(family) : fontFamily.getBaseSubFamilies();
        if (list2 == null) {
            FontFamilyServiceImpl.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    @NotNull
    protected String getRecommendedSubFamilyImpl(@NotNull String family) {
        FontFamily fontFamily;
        if (family == null) {
            FontFamilyServiceImpl.$$$reportNull$$$0(3);
        }
        String string = (fontFamily = (FontFamily)this.myFamilies.get(family)) == null ? super.getRecommendedSubFamilyImpl(family) : fontFamily.getRecommendedSubFamily();
        if (string == null) {
            FontFamilyServiceImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getRecommendedBoldSubFamilyImpl(@NotNull String family, @NotNull String mainSubFamily) {
        FontFamily fontFamily;
        if (family == null) {
            FontFamilyServiceImpl.$$$reportNull$$$0(5);
        }
        if (mainSubFamily == null) {
            FontFamilyServiceImpl.$$$reportNull$$$0(6);
        }
        String string = (fontFamily = (FontFamily)this.myFamilies.get(family)) == null ? super.getRecommendedBoldSubFamilyImpl(family, mainSubFamily) : fontFamily.getRecommendedBoldSubFamily(mainSubFamily);
        if (string == null) {
            FontFamilyServiceImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    protected Font getFontImpl(@NotNull String family, @Nullable String regularSubFamily, @Nullable String boldSubFamily, @JdkConstants.FontStyle int style) {
        FontFamily fontFamily;
        if (family == null) {
            FontFamilyServiceImpl.$$$reportNull$$$0(8);
        }
        Font font = (fontFamily = (FontFamily)this.myFamilies.get(family)) == null ? super.getFontImpl(family, regularSubFamily, boldSubFamily, style) : fontFamily.getFont(regularSubFamily, boldSubFamily, style);
        if (font == null) {
            FontFamilyServiceImpl.$$$reportNull$$$0(9);
        }
        return font;
    }

    @Override
    protected String @NotNull [] migrateFontSettingImpl(@NotNull String family) {
        block17: {
            if (family == null) {
                FontFamilyServiceImpl.$$$reportNull$$$0(10);
            }
            if (!this.myFamilies.isEmpty()) {
                if (FIRA_CODE_MIGRATION_MAP.containsKey(family)) {
                    if (!this.myFamilies.containsKey(family)) {
                        String[] stringArray = FIRA_CODE_MIGRATION_MAP.get(family);
                        if (stringArray == null) {
                            FontFamilyServiceImpl.$$$reportNull$$$0(11);
                        }
                        return stringArray;
                    }
                } else {
                    String[] stringArray;
                    block18: {
                        try {
                            assert (GET_FONT_2D_METHOD != null);
                            assert (GET_TYPO_FAMILY_METHOD != null);
                            assert (GET_TYPO_SUBFAMILY_METHOD != null);
                            Font baseFont = new Font(family, 0, 1);
                            String baseFamily = baseFont.getFamily();
                            Font2D baseFont2D = (Font2D)GET_FONT_2D_METHOD.invoke((Object)baseFont, new Object[0]);
                            String baseTypoFamily = (String)GET_TYPO_FAMILY_METHOD.invoke((Object)baseFont2D, new Object[0]);
                            String baseTypoSubfamily = (String)GET_TYPO_SUBFAMILY_METHOD.invoke((Object)baseFont2D, new Object[0]);
                            Font boldFont = new Font(family, 1, 1);
                            String boldFamily = boldFont.getFamily();
                            Font2D boldFont2D = (Font2D)GET_FONT_2D_METHOD.invoke((Object)boldFont, new Object[0]);
                            String boldTypoFamily = (String)GET_TYPO_FAMILY_METHOD.invoke((Object)boldFont2D, new Object[0]);
                            String boldTypoSubfamily = (String)GET_TYPO_SUBFAMILY_METHOD.invoke((Object)boldFont2D, new Object[0]);
                            if (!family.equals(baseFamily) || !family.equals(boldFamily)) {
                                LOG.info("Cannot migrate " + family + ": unexpected resolved families - " + baseFamily + ", " + boldFamily);
                                break block17;
                            }
                            if (!Objects.equals(baseTypoFamily, boldTypoFamily)) {
                                LOG.info("Cannot migrate " + family + ": normal and bold variations resolve to different typographic families - " + baseTypoFamily + ", " + boldTypoFamily);
                                break block17;
                            }
                            FontFamily fontFamily = (FontFamily)this.myFamilies.get(baseTypoFamily);
                            if (fontFamily == null) {
                                LOG.info("Cannot migrate " + family + ": typographic font family not found - " + baseTypoFamily);
                                break block17;
                            }
                            if (!fontFamily.hasSubFamily(baseTypoSubfamily)) {
                                LOG.info("Cannot migrate " + family + ": subfamily " + baseTypoSubfamily + " not found in typographic font family " + baseTypoFamily);
                                break block17;
                            }
                            if (!fontFamily.hasSubFamily(boldTypoSubfamily)) {
                                LOG.info("Cannot migrate " + family + ": subfamily " + boldTypoSubfamily + " not found in typographic font family " + baseTypoFamily);
                                break block17;
                            }
                            stringArray = new String[]{baseTypoFamily, baseTypoSubfamily, Objects.equals(baseTypoSubfamily, boldTypoSubfamily) ? null : boldTypoSubfamily};
                            if (stringArray != null) break block18;
                        }
                        catch (Throwable e) {
                            LOG.error(e);
                        }
                        FontFamilyServiceImpl.$$$reportNull$$$0(12);
                    }
                    return stringArray;
                }
            }
        }
        String[] stringArray = super.migrateFontSettingImpl(family);
        if (stringArray == null) {
            FontFamilyServiceImpl.$$$reportNull$$$0(13);
        }
        return stringArray;
    }

    private static Method getFont2DMethod(String methodName) {
        try {
            return ReflectionUtil.getDeclaredMethod(Font2D.class, (String)methodName, (Class[])new Class[0]);
        }
        catch (Throwable e) {
            if (VERBOSE_LOGGING) {
                LOG.warn(e);
            }
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FontFamilyServiceImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainSubFamily";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FontFamilyServiceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubFamiliesImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecommendedSubFamilyImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecommendedBoldSubFamilyImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "migrateFontSettingImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMonospacedImpl";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSubFamiliesImpl";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRecommendedSubFamilyImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRecommendedBoldSubFamilyImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFontImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "migrateFontSettingImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OurWeightMap
    extends MultiMap<Integer, String> {
        private OurWeightMap() {
            super(new TreeMap());
        }

        private void forEach(BiConsumer<? super Integer, ? super String> action2) {
            this.myMap.forEach((? super K weight2, ? super V list2) -> list2.forEach((? super T subFamily) -> action2.accept((Integer)weight2, (String)subFamily)));
        }

        private void forEachDescending(BiConsumer<? super Integer, ? super String> action2) {
            ((TreeMap)this.myMap).descendingMap().forEach((? super K weight2, ? super V list2) -> list2.forEach((? super T subFamily) -> action2.accept((Integer)weight2, (String)subFamily)));
        }
    }

    private static final class FontFamily {
        private final String family;
        private final Map<String, Font> members;
        private String recommendedSubFamily;
        private Map<String, String> recommendedBoldSubFamilies;
        private Map<String, String> recommendedPlainSubFamilies;
        private Map<String, Font> italics;

        private FontFamily(@NotNull String family) {
            if (family == null) {
                FontFamily.$$$reportNull$$$0(0);
            }
            this.members = new LinkedHashMap<String, Font>();
            this.family = family;
        }

        private void addFont(@NotNull String subFamily, @NotNull Font font) {
            if (subFamily == null) {
                FontFamily.$$$reportNull$$$0(1);
            }
            if (font == null) {
                FontFamily.$$$reportNull$$$0(2);
            }
            if (VERBOSE_LOGGING) {
                LOG.info("Adding " + font.getName() + " as " + subFamily + " variant to " + this.family + " family");
            }
            this.members.put(subFamily, font);
        }

        private synchronized void initIfNeeded() {
            if (this.recommendedSubFamily == null) {
                this.recommendedPlainSubFamilies = new HashMap<String, String>();
                this.recommendedBoldSubFamilies = new HashMap<String, String>();
                this.italics = new LinkedHashMap<String, Font>();
                OurWeightMap nonItalicsByWeight = new OurWeightMap();
                OurWeightMap italicsByWeight = new OurWeightMap();
                for (Map.Entry<String, Font> e : this.members.entrySet()) {
                    String subFamily2 = e.getKey();
                    Font font = e.getValue();
                    int weight3 = FontFamily.getWeight(font);
                    boolean isItalic = FontFamily.isItalic(subFamily2);
                    if (VERBOSE_LOGGING) {
                        LOG.info(this.family + "(" + subFamily2 + "): weight=" + weight3 + (isItalic ? ", italic" : ""));
                    }
                    (isItalic ? italicsByWeight : nonItalicsByWeight).putValue(weight3, subFamily2);
                }
                OurWeightMap baseSet = nonItalicsByWeight.isEmpty() ? italicsByWeight : nonItalicsByWeight;
                class Candidate {
                    final int desiredWeight;
                    String bestSubFamily;
                    int bestDistance = Integer.MAX_VALUE;

                    private Candidate(String defaultSubFamily, int desiredWeight) {
                        this.bestSubFamily = defaultSubFamily;
                        this.desiredWeight = desiredWeight;
                    }

                    private void updateIfBetterMatch(int weight2, String subFamily) {
                        int newMetric = Math.abs(this.desiredWeight - weight2);
                        if (newMetric < this.bestDistance) {
                            this.bestDistance = newMetric;
                            this.bestSubFamily = subFamily;
                        }
                    }
                }
                Candidate preferred = new Candidate(null, 400);
                HashMap<String, Candidate> candidates = new HashMap<String, Candidate>();
                baseSet.forEach((weight2, subFamily) -> {
                    preferred.updateIfBetterMatch((int)weight2, (String)subFamily);
                    String italicSubFamily = null;
                    if (baseSet == italicsByWeight) {
                        italicSubFamily = subFamily;
                    } else {
                        Collection italicSubFamilyCandidates = italicsByWeight.get(weight2);
                        for (String italicCandidate : italicSubFamilyCandidates) {
                            if (italicSubFamily != null && !FontFamily.isMatchingItalic(subFamily, italicCandidate)) continue;
                            italicSubFamily = italicCandidate;
                        }
                    }
                    this.italics.put((String)subFamily, italicSubFamily == null ? this.members.get(subFamily).deriveFont(SYNTHETIC_ITALICS_TRANSFORM) : this.members.get(italicSubFamily));
                    candidates.forEach((original, candidate) -> candidate.updateIfBetterMatch((int)weight2, (String)subFamily));
                    candidates.put((String)subFamily, new Candidate((String)subFamily, weight2 + 300));
                });
                this.recommendedSubFamily = preferred.bestSubFamily;
                candidates.forEach((original, boldCandidate) -> this.recommendedBoldSubFamilies.put((String)original, boldCandidate.bestSubFamily));
                candidates.clear();
                baseSet.forEachDescending((weight2, subFamily) -> {
                    candidates.forEach((original, candidate) -> candidate.updateIfBetterMatch((int)weight2, (String)subFamily));
                    candidates.put((String)subFamily, new Candidate((String)subFamily, weight2 - 300));
                });
                candidates.forEach((original, plainCandidate) -> this.recommendedPlainSubFamilies.put((String)original, plainCandidate.bestSubFamily));
            }
        }

        private static boolean isItalic(String subFamily) {
            String name2 = subFamily.toLowerCase(Locale.ENGLISH);
            return ContainerUtil.exists((Object[])ITALIC_NAMES, name2::contains);
        }

        private static boolean isMatchingItalic(String mainSubFamily, String italicSubFamily) {
            String main2 = mainSubFamily.toLowerCase(Locale.ENGLISH);
            String candidate = italicSubFamily.toLowerCase(Locale.ENGLISH);
            for (String suffix : ITALIC_NAMES) {
                if (!candidate.endsWith(suffix)) continue;
                candidate = candidate.substring(0, candidate.length() - suffix.length()).trim();
                break;
            }
            return candidate.equals(main2) || "regular".equals(main2) && candidate.isEmpty();
        }

        private static int getWeight(Font font) {
            assert (GET_FONT_2D_METHOD != null);
            assert (GET_WEIGHT_METHOD != null);
            try {
                Font2D font2d = (Font2D)GET_FONT_2D_METHOD.invoke((Object)font, new Object[0]);
                return (Integer)GET_WEIGHT_METHOD.invoke((Object)font2d, new Object[0]);
            }
            catch (Throwable t) {
                LOG.error(t);
                return 400;
            }
        }

        private boolean isMonospaced() {
            Font font = this.members.entrySet().iterator().next().getValue();
            if (!font.canDisplay(' ') || !font.canDisplay('M')) {
                return false;
            }
            FontMetrics metrics = FontInfo.getFontMetrics(font.deriveFont((float)EditorFontsConstants.getDefaultEditorFontSize()), FontInfo.DEFAULT_CONTEXT);
            return metrics.charWidth(' ') == metrics.charWidth('M');
        }

        private List<String> getBaseSubFamilies() {
            this.initIfNeeded();
            return new ArrayList<String>(this.italics.keySet());
        }

        private String getRecommendedSubFamily() {
            this.initIfNeeded();
            return this.recommendedSubFamily;
        }

        private String getRecommendedBoldSubFamily(String mainSubFamily) {
            this.initIfNeeded();
            String result2 = this.recommendedBoldSubFamilies.get(mainSubFamily);
            return result2 == null ? this.recommendedBoldSubFamilies.get(this.recommendedSubFamily) : result2;
        }

        private Font getFont(String regularSubFamily, String boldSubFamily, int style) {
            this.initIfNeeded();
            if (!this.italics.containsKey(regularSubFamily)) {
                regularSubFamily = null;
            }
            if (!this.italics.containsKey(boldSubFamily)) {
                boldSubFamily = null;
            }
            if (regularSubFamily == null) {
                String string = regularSubFamily = boldSubFamily == null ? this.recommendedSubFamily : this.recommendedPlainSubFamilies.get(boldSubFamily);
            }
            if (boldSubFamily == null) {
                boldSubFamily = this.recommendedBoldSubFamilies.get(regularSubFamily);
            }
            String target2 = (style & 1) == 0 ? regularSubFamily : boldSubFamily;
            return (style & 2) == 0 ? this.members.get(target2) : this.italics.get(target2);
        }

        private boolean hasSubFamily(String subFamily) {
            this.initIfNeeded();
            return this.italics.containsKey(subFamily);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "family";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subFamily";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "font";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/FontFamilyServiceImpl$FontFamily";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addFont";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

