/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.colors.impl.EditorFontCacheImpl;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.util.SystemInfo;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import sun.font.FontDesignMetrics;

public final class FontInfo {
    public static final FontRenderContext DEFAULT_CONTEXT = new FontRenderContext(null, false, false);
    private static final Font DUMMY_FONT = new Font(null);
    private final Font myFont;
    private final int mySize;
    private final IntSet mySafeCharacters = new IntOpenHashSet();
    private final FontRenderContext myContext;
    private FontMetrics myFontMetrics = null;

    public FontInfo(String familyName, int size, @JdkConstants.FontStyle int style, boolean useLigatures, FontRenderContext fontRenderContext) {
        this.mySize = size;
        this.myFont = EditorFontCacheImpl.deriveFontWithLigatures(new Font(familyName, style, size), useLigatures);
        this.myContext = fontRenderContext;
    }

    public FontInfo(Font font, int size, boolean useLigatures, FontRenderContext fontRenderContext) {
        this.mySize = size;
        this.myFont = EditorFontCacheImpl.deriveFontWithLigatures(font.deriveFont((float)size), useLigatures);
        this.myContext = fontRenderContext;
    }

    public boolean canDisplay(int codePoint) {
        try {
            if (codePoint < 128) {
                return true;
            }
            if (this.mySafeCharacters.contains(codePoint)) {
                return true;
            }
            if (FontInfo.canDisplay(this.myFont, codePoint, false)) {
                this.mySafeCharacters.add(codePoint);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean canDisplay(@NotNull Font font, int codePoint, boolean disableFontFallback) {
        if (font == null) {
            FontInfo.$$$reportNull$$$0(0);
        }
        if (!Character.isValidCodePoint(codePoint)) {
            return false;
        }
        if (disableFontFallback && SystemInfo.isMac) {
            int glyphCode = font.createGlyphVector(DEFAULT_CONTEXT, new String(new int[]{codePoint}, 0, 1)).getGlyphCode(0);
            return (glyphCode & 0xFFFFFF) != 0 && (glyphCode & 0xFF000000) == 0;
        }
        return font.canDisplay(codePoint);
    }

    public Font getFont() {
        return this.myFont;
    }

    public int charWidth(int codePoint) {
        FontMetrics metrics = this.fontMetrics();
        return FontLayoutService.getInstance().charWidth(metrics, codePoint);
    }

    public float charWidth2D(int codePoint) {
        FontMetrics metrics = this.fontMetrics();
        return FontLayoutService.getInstance().charWidth2D(metrics, codePoint);
    }

    public synchronized FontMetrics fontMetrics() {
        if (this.myFontMetrics == null) {
            this.myFontMetrics = FontInfo.getFontMetrics(this.myFont, this.myContext == null ? FontInfo.getFontRenderContext(null) : this.myContext);
        }
        return this.myFontMetrics;
    }

    @NotNull
    public static FontMetrics getFontMetrics(@NotNull Font font, @NotNull FontRenderContext fontRenderContext) {
        if (font == null) {
            FontInfo.$$$reportNull$$$0(1);
        }
        if (fontRenderContext == null) {
            FontInfo.$$$reportNull$$$0(2);
        }
        FontDesignMetrics fontDesignMetrics = FontDesignMetrics.getMetrics(font, fontRenderContext);
        if (fontDesignMetrics == null) {
            FontInfo.$$$reportNull$$$0(3);
        }
        return fontDesignMetrics;
    }

    public static FontRenderContext getFontRenderContext(Component component2) {
        if (component2 == null) {
            return DEFAULT_CONTEXT;
        }
        return component2.getFontMetrics(DUMMY_FONT).getFontRenderContext();
    }

    public int getSize() {
        return this.mySize;
    }

    public FontRenderContext getFontRenderContext() {
        return this.myContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontInfo fontInfo = (FontInfo)o;
        return this.myFont.equals(fontInfo.myFont);
    }

    public int hashCode() {
        return this.myFont.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontRenderContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FontInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FontInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canDisplay";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFontMetrics";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

