/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap;

import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;

public final class SoftWrapHelper {
    private SoftWrapHelper() {
    }

    public static boolean isCaretAfterSoftWrap(CaretImpl caret) {
        int offset;
        if (!caret.isUpToDate()) {
            return false;
        }
        EditorImpl editor2 = caret.getEditor();
        SoftWrapModelImpl softWrapModel = editor2.getSoftWrapModel();
        SoftWrap softWrap = softWrapModel.getSoftWrap(offset = caret.getOffset());
        if (softWrap == null) {
            return false;
        }
        VisualPosition afterWrapPosition = editor2.offsetToVisualPosition(offset, false, false);
        VisualPosition caretPosition = caret.getVisualPosition();
        return caretPosition.line == afterWrapPosition.line && caretPosition.column <= afterWrapPosition.column;
    }
}

