/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.toolbar.floating;

import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.editor.toolbar.floating.VisibilityController;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\u0003H\u0014J\b\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0003H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/editor/toolbar/floating/ToolbarVisibilityController;", "Lcom/intellij/openapi/editor/toolbar/floating/VisibilityController;", "autoHide", "", "parentComponent", "Ljavax/swing/JComponent;", "actionToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "toolbarComponent", "(ZLjavax/swing/JComponent;Lcom/intellij/openapi/actionSystem/ActionToolbar;Ljavax/swing/JComponent;)V", "getAutoHide", "()Z", "isRetention", "repaint", "", "setVisible", "isVisible", "intellij.platform.ide.impl"})
public final class ToolbarVisibilityController
extends VisibilityController {
    private final boolean autoHide;
    private final JComponent parentComponent;
    private final ActionToolbar actionToolbar;
    private final JComponent toolbarComponent;

    @Override
    protected void setVisible(boolean isVisible2) {
        this.toolbarComponent.setVisible(this.actionToolbar.hasVisibleActions() && isVisible2);
    }

    @Override
    protected void repaint() {
        this.toolbarComponent.repaint();
    }

    @Override
    protected boolean isRetention() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            return false;
        }
        PointerInfo pointerInfo2 = pointerInfo;
        Point location = pointerInfo2.getLocation();
        SwingUtilities.convertPointFromScreen(location, this.parentComponent);
        Rectangle bounds2 = new Rectangle(0, 0, this.parentComponent.getWidth(), this.parentComponent.getHeight());
        return bounds2.contains(location);
    }

    @Override
    protected boolean getAutoHide() {
        return this.autoHide;
    }

    public ToolbarVisibilityController(boolean autoHide, @NotNull JComponent parentComponent, @NotNull ActionToolbar actionToolbar, @NotNull JComponent toolbarComponent) {
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter((Object)actionToolbar, (String)"actionToolbar");
        Intrinsics.checkNotNullParameter((Object)toolbarComponent, (String)"toolbarComponent");
        this.autoHide = autoHide;
        this.parentComponent = parentComponent;
        this.actionToolbar = actionToolbar;
        this.toolbarComponent = toolbarComponent;
    }
}

