/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.dependency.analyzer;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.UIComponentVirtualFile;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependenciesContributor;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerExtension;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerViewImpl;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/externalSystem/dependency/analyzer/AbstractAnalyzeDependenciesAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getDependency", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependenciesContributor$Dependency;", "getProjectId", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "getSystemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "update", "intellij.platform.externalSystem.impl"})
public abstract class AbstractAnalyzeDependenciesAction
extends AnAction
implements DumbAware {
    @Nullable
    public abstract ProjectSystemId getSystemId(@NotNull AnActionEvent var1);

    @Nullable
    public abstract ExternalSystemProjectId getProjectId(@NotNull AnActionEvent var1);

    @Nullable
    public abstract DependenciesContributor.Dependency getDependency(@NotNull AnActionEvent var1);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        ProjectSystemId projectSystemId = this.getSystemId(e);
        if (projectSystemId == null) {
            return;
        }
        ProjectSystemId systemId2 = projectSystemId;
        ExternalSystemProjectId projectId = this.getProjectId(e);
        DependenciesContributor.Dependency dependency = this.getDependency(e);
        DependenciesContributor dependenciesContributor = DependencyAnalyzerExtension.Companion.findContributor(project2, systemId2);
        if (dependenciesContributor == null) {
            return;
        }
        DependenciesContributor contributor = dependenciesContributor;
        DependencyAnalyzerViewImpl dependencyAnalyzerView = new DependencyAnalyzerViewImpl(contributor);
        if (projectId != null) {
            if (dependency != null) {
                dependencyAnalyzerView.setSelectedDependency(projectId, dependency);
            } else {
                dependencyAnalyzerView.setSelectedProjectId(projectId);
            }
        }
        String editorTabName = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.editor.tab.name", (Object[])new Object[0]);
        UIComponentVirtualFile file2 = new UIComponentVirtualFile(editorTabName, new UIComponentVirtualFile.Content(dependencyAnalyzerView){
            final /* synthetic */ DependencyAnalyzerViewImpl $dependencyAnalyzerView;

            @NotNull
            public Icon getIcon() {
                Icon icon2 = AllIcons.Actions.Find;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.Actions.Find");
                return icon2;
            }

            @NotNull
            public JComponent createComponent() {
                return this.$dependencyAnalyzerView.getComponent();
            }

            @Nullable
            public JComponent getPreferredFocusedComponent() {
                return null;
            }
            {
                this.$dependencyAnalyzerView = $captured_local_variable$0;
            }
        });
        FileEditorManager.getInstance((Project)project2).openFile((VirtualFile)file2, true);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabledAndVisible(Registry.is((String)"external.system.dependency.analyzer"));
    }

    public AbstractAnalyzeDependenciesAction() {
        Presentation presentation2 = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"templatePresentation");
        presentation2.setIcon(AllIcons.Actions.Find);
        Presentation presentation3 = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"templatePresentation");
        presentation3.setText(ExternalSystemBundle.message((String)"external.system.dependency.analyzer.action.name", (Object[])new Object[0]));
    }
}

