/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.dependency.analyzer;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependenciesContributor;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerView;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerViewImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.GraphPropertyImpl;
import com.intellij.openapi.observable.properties.ObservableClearableProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.layout.CellKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0006@ABCDEB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010#\u001a\u00070\u0017\u00a2\u0006\u0002\b\u001dH\u0002J!\u0010$\u001a\u00020\u00062\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060&\"\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010'J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000fH\u0016J!\u0010.\u001a\u00020/2\u0017\u00100\u001a\u0013\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020)01\u00a2\u0006\u0002\b2H\u0002J!\u00103\u001a\u0002042\u0017\u00100\u001a\u0013\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020)01\u00a2\u0006\u0002\b2H\u0002J\b\u00105\u001a\u00020)H\u0002J\b\u00106\u001a\u00020)H\u0002J\b\u00107\u001a\u00020)H\u0002J\b\u00108\u001a\u00020)H\u0002J#\u00109\u001a\u0002H:\"\b\b\u0000\u0010:*\u00020\u0006*\u00020;2\u0006\u0010\u0005\u001a\u0002H:H\u0002\u00a2\u0006\u0002\u0010<J.\u0010=\u001a\b\u0012\u0004\u0012\u0002H:0>\"\b\b\u0000\u0010:*\u00020\u0006*\u00070\u0017\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u0005\u001a\u0002H:H\u0002\u00a2\u0006\u0002\u0010?R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\b\u0012\u00060\u000bR\u00020\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0018\u00010\u000bR\u00020\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\f\u0012\b\u0012\u00060\u000bR\u00020\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001c\u001a\r\u0012\t\u0012\u00070\u0017\u00a2\u0006\u0002\b\u001d0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001e\u001a\u00070\u0017\u00a2\u0006\u0002\b\u001f*\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006F"}, d2={"Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerView;", "contributor", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependenciesContributor;", "(Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependenciesContributor;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "dependenciesModel", "Lcom/intellij/ui/CollectionListModel;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$DependencyItem;", "dependencyProperty", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "projectIdProperty", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "projectIdsModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "propertyGraph", "Lcom/intellij/openapi/observable/properties/PropertyGraph;", "scopesModel", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$Scope;", "searchRequestProperty", "", "searchScopeProperty", "showGroupIdProperty", "", "usagesModel", "usagesTitleProperty", "Lcom/intellij/openapi/util/NlsContexts$Label;", "displayText", "Lcom/intellij/openapi/util/NlsSafe;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependenciesContributor$Dependency$Data;", "getDisplayText", "(Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependenciesContributor$Dependency$Data;)Ljava/lang/String;", "getUsagesTitle", "horizontalFlow", "components", "", "([Ljavax/swing/JComponent;)Ljavax/swing/JComponent;", "setSelectedDependency", "", "projectId", "dependency", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependenciesContributor$Dependency;", "setSelectedProjectId", "toolWindowPanel", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "configure", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "toolbarPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "updateDependenciesModel", "updateProjectIdsModel", "updateScopesModel", "updateUsagesModel", "addOnLeft", "C", "Ljavax/swing/JPanel;", "(Ljavax/swing/JPanel;Ljavax/swing/JComponent;)Ljavax/swing/JComponent;", "labelFor", "Lcom/intellij/openapi/ui/LabeledComponent;", "(Ljava/lang/String;Ljavax/swing/JComponent;)Lcom/intellij/openapi/ui/LabeledComponent;", "AbstractDependencyRenderer", "DependenciesRenderer", "DependencyItem", "ProjectIdRenderer", "Scope", "UsagesRenderer", "intellij.platform.externalSystem.impl"})
public final class DependencyAnalyzerViewImpl
implements DependencyAnalyzerView {
    @NotNull
    private final JComponent component;
    private final PropertyGraph propertyGraph;
    private final GraphProperty<ExternalSystemProjectId> projectIdProperty;
    private final GraphProperty<String> searchRequestProperty;
    private final GraphProperty<Scope> searchScopeProperty;
    private final GraphProperty<DependencyItem> dependencyProperty;
    private final GraphProperty<Boolean> showGroupIdProperty;
    private final GraphProperty<String> usagesTitleProperty;
    private final CollectionComboBoxModel<ExternalSystemProjectId> projectIdsModel;
    private final CollectionComboBoxModel<Scope> scopesModel;
    private final CollectionListModel<DependencyItem> dependenciesModel;
    private final CollectionListModel<DependencyItem> usagesModel;
    private final DependenciesContributor contributor;

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void setSelectedProjectId(@NotNull ExternalSystemProjectId projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        this.projectIdProperty.set(projectId);
    }

    @Override
    public void setSelectedDependency(@NotNull ExternalSystemProjectId projectId, @NotNull DependenciesContributor.Dependency dependency) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        this.projectIdProperty.set(projectId);
        this.dependencyProperty.set(new DependencyItem(projectId, dependency));
    }

    private final void updateProjectIdsModel() {
        this.projectIdsModel.removeAll();
        Iterable $this$forEach$iv = this.contributor.getProjectIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExternalSystemProjectId it = (ExternalSystemProjectId)element$iv;
            boolean bl = false;
            this.projectIdsModel.add((Object)it);
        }
        ExternalSystemProjectId projectId = (ExternalSystemProjectId)this.projectIdProperty.get();
        if (projectId == null || !this.projectIdsModel.contains((Object)projectId)) {
            List list2 = this.projectIdsModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"projectIdsModel.items");
            this.projectIdProperty.set((ExternalSystemProjectId)CollectionsKt.firstOrNull((List)list2));
        }
    }

    private final void updateScopesModel() {
        Scope scope2;
        this.scopesModel.removeAll();
        this.scopesModel.add((Object)Scope.Any.INSTANCE);
        ExternalSystemProjectId projectId = (ExternalSystemProjectId)this.projectIdProperty.get();
        if (projectId != null) {
            Iterable $this$forEach$iv = this.contributor.getDependencyScopes(projectId);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.scopesModel.add((Object)new Scope.Just(it));
            }
        }
        if (!this.scopesModel.contains((Object)(scope2 = (Scope)this.searchScopeProperty.get()))) {
            this.searchScopeProperty.set(Scope.Any.INSTANCE);
        }
    }

    private final void updateDependenciesModel() {
        DependencyItem dependency;
        this.dependenciesModel.removeAll();
        ExternalSystemProjectId projectId = (ExternalSystemProjectId)this.projectIdProperty.get();
        if (projectId != null) {
            ArrayDeque queue2 = new ArrayDeque();
            queue2.addLast((Object)new DependencyItem(projectId, this.contributor.getRoot(projectId)));
            block0: while (true) {
                Collection collection = (Collection)queue2;
                boolean bl = false;
                if (!(!collection.isEmpty())) break;
                DependencyItem dependency2 = (DependencyItem)queue2.removeFirst();
                this.dependenciesModel.add((Object)dependency2);
                Iterable $this$forEach$iv = dependency2.getDependencies();
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (true) {
                    if (!iterator2.hasNext()) continue block0;
                    Object element$iv = iterator2.next();
                    DependenciesContributor.Dependency it = (DependenciesContributor.Dependency)element$iv;
                    boolean bl2 = false;
                    queue2.addLast((Object)new DependencyItem(projectId, it));
                }
                break;
            }
        }
        if ((dependency = (DependencyItem)this.dependencyProperty.get()) == null || !this.dependenciesModel.contains((Object)dependency)) {
            List list2 = this.dependenciesModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"dependenciesModel.items");
            this.dependencyProperty.set((DependencyItem)CollectionsKt.firstOrNull((List)list2));
        }
    }

    private final void updateUsagesModel() {
        this.usagesModel.removeAll();
        ExternalSystemProjectId projectId = (ExternalSystemProjectId)this.projectIdProperty.get();
        DependencyItem dependency = (DependencyItem)this.dependencyProperty.get();
        if (projectId != null && dependency != null) {
            Iterator<DependenciesContributor.Dependency> iterator2 = dependency.getVariances().iterator();
            while (iterator2.hasNext()) {
                DependenciesContributor.Dependency candidate;
                for (DependenciesContributor.Dependency current2 = candidate = iterator2.next(); current2 != null; current2 = current2.getUsage()) {
                    this.usagesModel.add((Object)new DependencyItem(projectId, current2));
                }
            }
        }
    }

    private final JComponent horizontalFlow(JComponent ... components) {
        JPanel jPanel2 = new JPanel();
        boolean bl = false;
        boolean bl2 = false;
        JPanel $this$apply = jPanel2;
        boolean bl3 = false;
        $this$apply.setLayout(new GridLayout(1, components.length));
        JComponent[] $this$forEach$iv = components;
        boolean $i$f$forEach = false;
        for (JComponent element$iv : $this$forEach$iv) {
            Component p1 = element$iv;
            boolean bl4 = false;
            $this$apply.add(p1);
        }
        return jPanel2;
    }

    private final String getUsagesTitle() {
        DependencyItem dependencyItem = (DependencyItem)this.dependencyProperty.get();
        if (dependencyItem == null) {
            return "";
        }
        DependencyItem dependency = dependencyItem;
        String string = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.usages.title", (Object[])new Object[]{dependency.getDisplayText()});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExternalSystemBundle.mes\u2026, dependency.displayText)");
        return string;
    }

    private final <C extends JComponent> C addOnLeft(JPanel $this$addOnLeft, C component2) {
        $this$addOnLeft.add((Component)component2, "West");
        return component2;
    }

    private final <C extends JComponent> LabeledComponent<C> labelFor(String $this$labelFor, C component2) {
        LabeledComponent labeledComponent = LabeledComponent.create(component2, (String)$this$labelFor, (String)"West");
        Intrinsics.checkNotNullExpressionValue((Object)labeledComponent, (String)"LabeledComponent.create(\u2026 this, BorderLayout.WEST)");
        return labeledComponent;
    }

    private final SimpleToolWindowPanel toolWindowPanel(Function1<? super SimpleToolWindowPanel, Unit> configure) {
        SimpleToolWindowPanel simpleToolWindowPanel = new SimpleToolWindowPanel(true, true);
        boolean bl = false;
        boolean bl2 = false;
        SimpleToolWindowPanel $this$apply = simpleToolWindowPanel;
        boolean bl3 = false;
        configure.invoke((Object)$this$apply);
        return simpleToolWindowPanel;
    }

    private final BorderLayoutPanel toolbarPanel(Function1<? super BorderLayoutPanel, Unit> configure) {
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel();
        boolean bl = false;
        boolean bl2 = false;
        BorderLayoutPanel $this$apply = borderLayoutPanel;
        boolean bl3 = false;
        $this$apply.setBorder((Border)JBUI.Borders.empty());
        bl = false;
        bl2 = false;
        $this$apply = borderLayoutPanel;
        boolean bl4 = false;
        $this$apply.withMinimumHeight(JBUI.scale((int)30));
        bl = false;
        bl2 = false;
        $this$apply = borderLayoutPanel;
        boolean bl5 = false;
        $this$apply.withPreferredHeight(JBUI.scale((int)30));
        bl = false;
        bl2 = false;
        $this$apply = borderLayoutPanel;
        boolean bl6 = false;
        configure.invoke((Object)$this$apply);
        return borderLayoutPanel;
    }

    private final String getDisplayText(DependenciesContributor.Dependency.Data $this$displayText) {
        String string;
        DependenciesContributor.Dependency.Data data2 = $this$displayText;
        if (data2 instanceof DependenciesContributor.Dependency.Data.Module) {
            string = ((DependenciesContributor.Dependency.Data.Module)$this$displayText).getName();
        } else if (data2 instanceof DependenciesContributor.Dependency.Data.Artifact) {
            string = ((Boolean)this.showGroupIdProperty.get()).booleanValue() ? ((DependenciesContributor.Dependency.Data.Artifact)$this$displayText).getGroupId() + ':' + ((DependenciesContributor.Dependency.Data.Artifact)$this$displayText).getArtifactId() + ':' + ((DependenciesContributor.Dependency.Data.Artifact)$this$displayText).getVersion() : ((DependenciesContributor.Dependency.Data.Artifact)$this$displayText).getArtifactId() + ':' + ((DependenciesContributor.Dependency.Data.Artifact)$this$displayText).getVersion();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public DependencyAnalyzerViewImpl(@NotNull DependenciesContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        this.contributor = contributor;
        this.propertyGraph = new PropertyGraph(null, false, 3, null);
        this.projectIdProperty = GraphPropertyImpl.Companion.graphProperty(this.propertyGraph, projectIdProperty.1.INSTANCE);
        this.searchRequestProperty = GraphPropertyImpl.Companion.graphProperty(this.propertyGraph, searchRequestProperty.1.INSTANCE);
        this.searchScopeProperty = GraphPropertyImpl.Companion.graphProperty(this.propertyGraph, searchScopeProperty.1.INSTANCE);
        this.dependencyProperty = GraphPropertyImpl.Companion.graphProperty(this.propertyGraph, dependencyProperty.1.INSTANCE);
        this.showGroupIdProperty = GraphPropertyImpl.Companion.graphProperty(this.propertyGraph, showGroupIdProperty.1.INSTANCE);
        this.usagesTitleProperty = GraphPropertyImpl.Companion.graphProperty(this.propertyGraph, (Function0)new Function0<String>(this){

            @NotNull
            public final String invoke() {
                return DependencyAnalyzerViewImpl.access$getUsagesTitle((DependencyAnalyzerViewImpl)this.receiver);
            }
        });
        this.projectIdsModel = new CollectionComboBoxModel();
        this.scopesModel = new CollectionComboBoxModel();
        this.dependenciesModel = new CollectionListModel((Object[])new DependencyItem[0]);
        this.usagesModel = new CollectionListModel((Object[])new DependencyItem[0]);
        this.scopesModel.add((Object)Scope.Any.INSTANCE);
        this.component = (JComponent)this.toolWindowPanel((Function1<? super SimpleToolWindowPanel, Unit>)((Function1)new Function1<SimpleToolWindowPanel, Unit>(){

            public final void invoke(@NotNull SimpleToolWindowPanel $this$toolWindowPanel) {
                Intrinsics.checkNotNullParameter((Object)$this$toolWindowPanel, (String)"$receiver");
                $this$toolWindowPanel.setToolbar((JComponent)this.toolbarPanel((Function1<? super BorderLayoutPanel, Unit>)((Function1)new Function1<BorderLayoutPanel, Unit>(){

                    public final void invoke(@NotNull BorderLayoutPanel $this$toolbarPanel) {
                        Object $this$apply;
                        JComponent[] jComponentArray;
                        Intrinsics.checkNotNullParameter((Object)$this$toolbarPanel, (String)"$receiver");
                        Object object = CellKt.bind(new ComboBox((ComboBoxModel)projectIdsModel), projectIdProperty);
                        boolean bl = false;
                        boolean bl2 = false;
                        ComboBox comboBox2 = object;
                        int n = 0;
                        JComponent[] jComponentArray2 = jComponentArray = new JComponent[3];
                        DependencyAnalyzerViewImpl dependencyAnalyzerViewImpl = this;
                        JPanel jPanel2 = (JPanel)$this$toolbarPanel;
                        DependencyAnalyzerViewImpl dependencyAnalyzerViewImpl2 = this;
                        boolean bl3 = false;
                        $this$apply.setSelectedItem(projectIdProperty.get());
                        Object object2 = Unit.INSTANCE;
                        bl = false;
                        bl2 = false;
                        $this$apply = object;
                        boolean bl4 = false;
                        $this$apply.setRenderer((ListCellRenderer)((Object)new ProjectIdRenderer()));
                        object2 = Unit.INSTANCE;
                        jComponentArray[n] = (JComponent)object;
                        object = CellKt.bind((JTextComponent)new JTextField(), searchRequestProperty);
                        bl = false;
                        bl2 = false;
                        $this$apply = (JTextField)object;
                        n = 1;
                        jComponentArray = jComponentArray2;
                        boolean bl5 = false;
                        ((JTextComponent)$this$apply).setText((String)searchRequestProperty.get());
                        object2 = Unit.INSTANCE;
                        jComponentArray[n] = (JComponent)object;
                        DependencyAnalyzerViewImpl dependencyAnalyzerViewImpl3 = this;
                        String string = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.scope.label", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExternalSystemBundle.mes\u2026cy.analyzer.scope.label\")");
                        object = CellKt.bind(new ComboBox((ComboBoxModel)scopesModel), searchScopeProperty);
                        bl = false;
                        bl2 = false;
                        $this$apply = object;
                        String string2 = string;
                        object2 = dependencyAnalyzerViewImpl3;
                        n = 2;
                        jComponentArray = jComponentArray2;
                        boolean bl6 = false;
                        $this$apply.setSelectedItem(searchScopeProperty.get());
                        Unit unit = Unit.INSTANCE;
                        jComponentArray[n] = (JComponent)((DependencyAnalyzerViewImpl)object2).labelFor(string2, (JComponent)object);
                        dependencyAnalyzerViewImpl2.addOnLeft(jPanel2, dependencyAnalyzerViewImpl.horizontalFlow(jComponentArray2));
                    }
                })));
                $this$toolWindowPanel.setContent(this.horizontalFlow((JComponent)this.toolWindowPanel((Function1<? super SimpleToolWindowPanel, Unit>)((Function1)new Function1<SimpleToolWindowPanel, Unit>(){

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull SimpleToolWindowPanel $this$toolWindowPanel) {
                        void $this$apply;
                        Intrinsics.checkNotNullParameter((Object)$this$toolWindowPanel, (String)"$receiver");
                        $this$toolWindowPanel.setToolbar((JComponent)this.toolbarPanel((Function1<? super BorderLayoutPanel, Unit>)((Function1)new Function1<BorderLayoutPanel, Unit>(){

                            public final void invoke(@NotNull BorderLayoutPanel $this$toolbarPanel) {
                                Intrinsics.checkNotNullParameter((Object)$this$toolbarPanel, (String)"$receiver");
                                this.addOnLeft((JPanel)$this$toolbarPanel, new JLabel(ExternalSystemBundle.message((String)"external.system.dependency.analyzer.resolved.title", (Object[])new Object[0])));
                            }
                        })));
                        JBList jBList = new JBList((ListModel)dependenciesModel);
                        boolean bl = false;
                        boolean bl2 = false;
                        JBList jBList2 = jBList;
                        SimpleToolWindowPanel simpleToolWindowPanel = $this$toolWindowPanel;
                        boolean bl3 = false;
                        $this$apply.setCellRenderer((ListCellRenderer)((Object)new DependenciesRenderer()));
                        CellKt.bind((JList)$this$apply, dependencyProperty);
                        StatusText statusText2 = $this$apply.getEmptyText();
                        Intrinsics.checkNotNullExpressionValue((Object)statusText2, (String)"emptyText");
                        statusText2.setText(ExternalSystemBundle.message((String)"external.system.dependency.analyzer.resolved.empty", (Object[])new Object[0]));
                        Unit unit = Unit.INSTANCE;
                        simpleToolWindowPanel.setContent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Component)jBList)));
                    }
                }))));
            }
        }));
        this.projectIdProperty.afterChange((Function1<ExternalSystemProjectId, Unit>)((Function1)new Function1<ExternalSystemProjectId, Unit>(){

            public final void invoke(@Nullable ExternalSystemProjectId it) {
                this.updateScopesModel();
                this.updateDependenciesModel();
            }
        }));
        this.dependencyProperty.afterChange((Function1<DependencyItem, Unit>)((Function1)new Function1<DependencyItem, Unit>(){

            public final void invoke(@Nullable DependencyItem it) {
                this.updateUsagesModel();
            }
        }));
        this.updateProjectIdsModel();
        this.usagesTitleProperty.dependsOn((ObservableClearableProperty)this.dependencyProperty);
        this.usagesTitleProperty.dependsOn((ObservableClearableProperty)this.showGroupIdProperty);
    }

    public static final /* synthetic */ String access$getDisplayText$p(DependencyAnalyzerViewImpl $this, DependenciesContributor.Dependency.Data $this$access_u24displayText_u24p) {
        return $this.getDisplayText($this$access_u24displayText_u24p);
    }

    public static final /* synthetic */ String access$getUsagesTitle(DependencyAnalyzerViewImpl $this) {
        return $this.getUsagesTitle();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$ProjectIdRenderer;", "Lcom/intellij/ui/SimpleListCellRenderer;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "(Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl;)V", "customize", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "intellij.platform.externalSystem.impl"})
    private final class ProjectIdRenderer
    extends SimpleListCellRenderer<ExternalSystemProjectId> {
        public void customize(@NotNull JList<? extends ExternalSystemProjectId> list2, @Nullable ExternalSystemProjectId value2, int index2, boolean selected2, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            if (value2 == null) {
                this.setText(ExternalSystemBundle.message((String)"external.system.dependency.analyzer.projects.empty", (Object[])new Object[0]));
            } else {
                this.setText(DependencyAnalyzerViewImpl.this.contributor.getProjectName(value2));
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00a2\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004JB\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0001\u0012\u00060\u0002R\u00020\u00030\b2\f\u0010\t\u001a\b\u0018\u00010\u0002R\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014J\u001c\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0002R\u00020\u0003H\u0016J\u001c\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0002R\u00020\u0003H\u0016J\u001c\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0002R\u00020\u0003H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$AbstractDependencyRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$DependencyItem;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl;", "(Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl;)V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "setupIcon", "projectId", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "dependency", "setupName", "setupScope", "intellij.platform.externalSystem.impl"})
    private abstract class AbstractDependencyRenderer
    extends ColoredListCellRenderer<DependencyItem> {
        public void setupIcon(@NotNull ExternalSystemProjectId projectId, @NotNull DependencyItem dependency) {
            Icon icon2;
            Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            DependenciesContributor.Dependency.Data data2 = dependency.getDependency().getData();
            if (data2 instanceof DependenciesContributor.Dependency.Data.Module) {
                icon2 = AllIcons.Nodes.Module;
            } else if (data2 instanceof DependenciesContributor.Dependency.Data.Artifact) {
                icon2 = AllIcons.Nodes.PpLib;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            this.setIcon(icon2);
        }

        public void setupName(@NotNull ExternalSystemProjectId projectId, @NotNull DependencyItem dependency) {
            Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            if (dependency.getInspectionResult().contains(DependenciesContributor.InspectionResult.Omitted.INSTANCE)) {
                this.append(dependency.getDisplayText(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)this.append(dependency.getDisplayText()), (String)"append(dependency.displayText)");
            }
        }

        public void setupScope(@NotNull ExternalSystemProjectId projectId, @NotNull DependencyItem dependency) {
            Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            if (!dependency.getInspectionResult().contains(DependenciesContributor.InspectionResult.Omitted.INSTANCE)) {
                this.append(" (" + dependency.getScope() + ')', SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }

        protected void customizeCellRenderer(@NotNull JList<? extends DependencyItem> list2, @Nullable DependencyItem value2, int index2, boolean selected2, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            ExternalSystemProjectId externalSystemProjectId = (ExternalSystemProjectId)DependencyAnalyzerViewImpl.this.projectIdProperty.get();
            if (externalSystemProjectId == null) {
                return;
            }
            ExternalSystemProjectId projectId = externalSystemProjectId;
            DependencyItem dependencyItem = value2;
            if (dependencyItem == null) {
                return;
            }
            DependencyItem dependency = dependencyItem;
            this.setupIcon(projectId, dependency);
            this.setupName(projectId, dependency);
            this.setupScope(projectId, dependency);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$DependenciesRenderer;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$AbstractDependencyRenderer;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl;", "(Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl;)V", "setupIcon", "", "projectId", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "dependency", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$DependencyItem;", "intellij.platform.externalSystem.impl"})
    private final class DependenciesRenderer
    extends AbstractDependencyRenderer {
        @Override
        public void setupIcon(@NotNull ExternalSystemProjectId projectId, @NotNull DependencyItem dependency) {
            boolean bl;
            block5: {
                Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
                Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
                Iterable $this$any$iv = dependency.getInspectionResult();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DependenciesContributor.InspectionResult it = (DependenciesContributor.InspectionResult)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof DependenciesContributor.InspectionResult.VersionConflict)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                this.setIcon(AllIcons.General.Warning);
            } else {
                super.setupIcon(projectId, dependency);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$UsagesRenderer;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$AbstractDependencyRenderer;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl;", "(Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl;)V", "setupScope", "", "projectId", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "dependency", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$DependencyItem;", "intellij.platform.externalSystem.impl"})
    private final class UsagesRenderer
    extends AbstractDependencyRenderer {
        /*
         * WARNING - void declaration
         */
        @Override
        public void setupScope(@NotNull ExternalSystemProjectId projectId, @NotNull DependencyItem dependency) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            super.setupScope(projectId, dependency);
            Iterable $this$filterIsInstance$iv = dependency.getInspectionResult();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DependenciesContributor.InspectionResult.VersionConflict)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            DependenciesContributor.InspectionResult.VersionConflict versionConflict = (DependenciesContributor.InspectionResult.VersionConflict)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (versionConflict != null) {
                String version2 = versionConflict.getConflicted().getVersion();
                String message2 = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.error.version.conflict", (Object[])new Object[]{version2});
                this.append(' ' + message2, SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\b\tB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$Scope;", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "toString", "Any", "Just", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$Scope$Any;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$Scope$Just;", "intellij.platform.externalSystem.impl"})
    private static abstract class Scope {
        @NotNull
        private final String name;

        @NotNull
        public String toString() {
            return this.name;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        private Scope(String name2) {
            this.name = name2;
        }

        public /* synthetic */ Scope(String name2, DefaultConstructorMarker $constructor_marker) {
            this(name2);
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$Scope$Any;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$Scope;", "()V", "intellij.platform.externalSystem.impl"})
        public static final class Any
        extends Scope {
            @NotNull
            public static final Any INSTANCE;

            private Any() {
                String string = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.scope.any", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExternalSystemBundle.mes\u2026ency.analyzer.scope.any\")");
                super(string, null);
            }

            static {
                Any any;
                INSTANCE = any = new Any();
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$Scope$Just;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$Scope;", "name", "", "(Ljava/lang/String;)V", "intellij.platform.externalSystem.impl"})
        public static final class Just
        extends Scope {
            public Just(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                super(name2, null);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\f\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\f\u001a\u0004\b\u0017\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\f\u001a\u0004\b\u001c\u0010\u0013R!\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\f\u001a\u0004\b\u001f\u0010\n\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$DependencyItem;", "", "projectId", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "dependency", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependenciesContributor$Dependency;", "(Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependenciesContributor$Dependency;)V", "dependencies", "", "getDependencies", "()Ljava/util/List;", "dependencies$delegate", "Lkotlin/Lazy;", "getDependency", "()Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependenciesContributor$Dependency;", "displayText", "", "Lcom/intellij/openapi/util/NlsSafe;", "getDisplayText", "()Ljava/lang/String;", "displayText$delegate", "inspectionResult", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependenciesContributor$InspectionResult;", "getInspectionResult", "inspectionResult$delegate", "getProjectId", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "scope", "getScope", "scope$delegate", "variances", "getVariances", "variances$delegate", "intellij.platform.externalSystem.impl"})
    private final class DependencyItem {
        @NotNull
        private final Lazy scope$delegate;
        @NotNull
        private final Lazy dependencies$delegate;
        @NotNull
        private final Lazy variances$delegate;
        @NotNull
        private final Lazy inspectionResult$delegate;
        @NotNull
        private final Lazy displayText$delegate;
        @NotNull
        private final ExternalSystemProjectId projectId;
        @NotNull
        private final DependenciesContributor.Dependency dependency;

        @NotNull
        public final String getScope() {
            Lazy lazy = this.scope$delegate;
            DependencyItem dependencyItem = this;
            Object var3_3 = null;
            boolean bl = false;
            return (String)lazy.getValue();
        }

        @NotNull
        public final List<DependenciesContributor.Dependency> getDependencies() {
            Lazy lazy = this.dependencies$delegate;
            DependencyItem dependencyItem = this;
            Object var3_3 = null;
            boolean bl = false;
            return (List)lazy.getValue();
        }

        @NotNull
        public final List<DependenciesContributor.Dependency> getVariances() {
            Lazy lazy = this.variances$delegate;
            DependencyItem dependencyItem = this;
            Object var3_3 = null;
            boolean bl = false;
            return (List)lazy.getValue();
        }

        @NotNull
        public final List<DependenciesContributor.InspectionResult> getInspectionResult() {
            Lazy lazy = this.inspectionResult$delegate;
            DependencyItem dependencyItem = this;
            Object var3_3 = null;
            boolean bl = false;
            return (List)lazy.getValue();
        }

        @NotNull
        public final String getDisplayText() {
            Lazy lazy = this.displayText$delegate;
            DependencyItem dependencyItem = this;
            Object var3_3 = null;
            boolean bl = false;
            return (String)lazy.getValue();
        }

        @NotNull
        public final ExternalSystemProjectId getProjectId() {
            return this.projectId;
        }

        @NotNull
        public final DependenciesContributor.Dependency getDependency() {
            return this.dependency;
        }

        public DependencyItem(@NotNull ExternalSystemProjectId projectId, DependenciesContributor.Dependency dependency) {
            Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            this.projectId = projectId;
            this.dependency = dependency;
            this.scope$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ DependencyItem this$0;

                @NotNull
                public final String invoke() {
                    return DependencyAnalyzerViewImpl.access$getContributor$p(this.this$0.DependencyAnalyzerViewImpl.this).getDependencyScope(this.this$0.getProjectId(), this.this$0.getDependency());
                }
                {
                    this.this$0 = dependencyItem;
                    super(0);
                }
            }));
            this.dependencies$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends DependenciesContributor.Dependency>>(this){
                final /* synthetic */ DependencyItem this$0;

                @NotNull
                public final List<DependenciesContributor.Dependency> invoke() {
                    return DependencyAnalyzerViewImpl.access$getContributor$p(this.this$0.DependencyAnalyzerViewImpl.this).getDependencies(this.this$0.getProjectId(), this.this$0.getDependency());
                }
                {
                    this.this$0 = dependencyItem;
                    super(0);
                }
            }));
            this.variances$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends DependenciesContributor.Dependency>>(this){
                final /* synthetic */ DependencyItem this$0;

                @NotNull
                public final List<DependenciesContributor.Dependency> invoke() {
                    return DependencyAnalyzerViewImpl.access$getContributor$p(this.this$0.DependencyAnalyzerViewImpl.this).getVariances(this.this$0.getProjectId(), this.this$0.getDependency());
                }
                {
                    this.this$0 = dependencyItem;
                    super(0);
                }
            }));
            this.inspectionResult$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends DependenciesContributor.InspectionResult>>(this){
                final /* synthetic */ DependencyItem this$0;

                @NotNull
                public final List<DependenciesContributor.InspectionResult> invoke() {
                    return DependencyAnalyzerViewImpl.access$getContributor$p(this.this$0.DependencyAnalyzerViewImpl.this).getInspectionResult(this.this$0.getProjectId(), this.this$0.getDependency());
                }
                {
                    this.this$0 = dependencyItem;
                    super(0);
                }
            }));
            this.displayText$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ DependencyItem this$0;

                @NotNull
                public final String invoke() {
                    return DependencyAnalyzerViewImpl.access$getDisplayText$p(this.this$0.DependencyAnalyzerViewImpl.this, this.this$0.getDependency().getData());
                }
                {
                    this.this$0 = dependencyItem;
                    super(0);
                }
            }));
        }
    }
}

