/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MessageCounter {
    private final Map<ProjectSystemId, Map<String, Map<NotificationSource, Object2IntOpenHashMap<NotificationCategory>>>> map = new HashMap<ProjectSystemId, Map<String, Map<NotificationSource, Object2IntOpenHashMap<NotificationCategory>>>>();

    public synchronized void increment(@NotNull String groupName, @NotNull NotificationSource source, @NotNull NotificationCategory category, @NotNull ProjectSystemId projectSystemId) {
        if (groupName == null) {
            MessageCounter.$$$reportNull$$$0(0);
        }
        if (source == null) {
            MessageCounter.$$$reportNull$$$0(1);
        }
        if (category == null) {
            MessageCounter.$$$reportNull$$$0(2);
        }
        if (projectSystemId == null) {
            MessageCounter.$$$reportNull$$$0(3);
        }
        Object2IntMap counter = (Object2IntMap)this.map.computeIfAbsent(projectSystemId, __ -> new HashMap()).computeIfAbsent(groupName, __ -> new HashMap()).computeIfAbsent(source, __ -> new Object2IntOpenHashMap());
        counter.mergeInt((Object)category, 1, Math::addExact);
    }

    public synchronized void remove(@Nullable String groupName, @NotNull NotificationSource notificationSource, @NotNull ProjectSystemId projectSystemId) {
        if (notificationSource == null) {
            MessageCounter.$$$reportNull$$$0(4);
        }
        if (projectSystemId == null) {
            MessageCounter.$$$reportNull$$$0(5);
        }
        Map groupMap = this.map.computeIfAbsent(projectSystemId, __ -> new HashMap());
        if (groupName == null) {
            for (Map sourceMap : groupMap.values()) {
                sourceMap.remove((Object)notificationSource);
            }
        } else {
            Object2IntMap counter = (Object2IntMap)groupMap.computeIfAbsent(groupName, __ -> new HashMap()).computeIfAbsent(notificationSource, __ -> new Object2IntOpenHashMap());
            counter.clear();
        }
    }

    public synchronized int getCount(@Nullable String groupName, @NotNull NotificationSource notificationSource, @Nullable NotificationCategory notificationCategory, @NotNull ProjectSystemId projectSystemId) {
        if (notificationSource == null) {
            MessageCounter.$$$reportNull$$$0(6);
        }
        if (projectSystemId == null) {
            MessageCounter.$$$reportNull$$$0(7);
        }
        int count = 0;
        Map<String, Map<NotificationSource, Object2IntOpenHashMap<NotificationCategory>>> value2 = this.map.get(projectSystemId);
        Map<Object, Object> groupMap = value2 == null ? Collections.emptyMap() : value2;
        for (Map.Entry<Object, Object> entry2 : groupMap.entrySet()) {
            Object2IntMap counter;
            if (groupName != null && !groupName.equals(entry2.getKey()) || (counter = (Object2IntMap)((Map)entry2.getValue()).get((Object)notificationSource)) == null) continue;
            if (notificationCategory == null) {
                IntIterator iterator2 = counter.values().iterator();
                while (iterator2.hasNext()) {
                    count += iterator2.nextInt();
                }
                continue;
            }
            count += counter.getInt((Object)notificationCategory);
        }
        return count;
    }

    public String toString() {
        return "MessageCounter{map=" + this.map + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationSource";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/notification/MessageCounter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "increment";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getCount";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

