/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectsWorkspaceImpl;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemWorkspaceContributor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class ModifiableWorkspace {
    private final Map<ProjectCoordinate, String> myModuleMappingById = CollectionFactory.createCustomHashingStrategyMap((HashingStrategy)new HashingStrategy<ProjectCoordinate>(){

        public int hashCode(ProjectCoordinate object) {
            if (object == null) {
                return 0;
            }
            String groupId2 = object.getGroupId();
            String artifactId2 = object.getArtifactId();
            String version2 = object.getVersion();
            int result1 = groupId2 != null ? groupId2.hashCode() : 0;
            result1 = 31 * result1 + (artifactId2 != null ? artifactId2.hashCode() : 0);
            result1 = 31 * result1 + (version2 != null ? version2.hashCode() : 0);
            return result1;
        }

        public boolean equals(ProjectCoordinate o1, ProjectCoordinate o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            if (o1.getGroupId() != null ? !o1.getGroupId().equals(o2.getGroupId()) : o2.getGroupId() != null) {
                return false;
            }
            if (o1.getArtifactId() != null ? !o1.getArtifactId().equals(o2.getArtifactId()) : o2.getArtifactId() != null) {
                return false;
            }
            return !(o1.getVersion() != null ? !o1.getVersion().equals(o2.getVersion()) : o2.getVersion() != null);
        }
    });
    private final ExternalProjectsWorkspaceImpl.State myState;
    private final MultiMap<String, String> mySubstitutions = MultiMap.createSet();
    private final Map<String, String> myNamesMap = new HashMap<String, String>();
    private final Supplier<List<Module>> myModulesSupplier;

    public ModifiableWorkspace(ExternalProjectsWorkspaceImpl.State state, Supplier<List<Module>> modulesSupplier) {
        this.myModulesSupplier = modulesSupplier;
        HashSet<String> existingModules = new HashSet<String>();
        for (Module module : modulesSupplier.get()) {
            this.register(module);
            existingModules.add(module.getName());
        }
        this.myState = state;
        if (this.myState.names != null) {
            for (Map.Entry entry2 : this.myState.names.entrySet()) {
                if (!existingModules.contains(entry2.getKey())) continue;
                this.myNamesMap.put((String)entry2.getKey(), (String)entry2.getValue());
            }
        }
        if (this.myState.substitutions != null) {
            for (Map.Entry entry3 : this.myState.substitutions.entrySet()) {
                if (!existingModules.contains(entry3.getKey())) continue;
                this.mySubstitutions.put((Object)((String)entry3.getKey()), (Collection)entry3.getValue());
            }
        }
    }

    public void commit() {
        HashSet existingModules = new HashSet();
        this.myModulesSupplier.get().stream().map(Module::getName).forEach(existingModules::add);
        this.myState.names = new HashMap<String, String>();
        this.myNamesMap.forEach((module, lib) -> {
            if (existingModules.contains(module)) {
                this.myState.names.put((String)module, (String)lib);
            }
        });
        this.myState.substitutions = new HashMap<String, Set<String>>();
        for (Map.Entry entry2 : this.mySubstitutions.entrySet()) {
            Collection value2;
            if (!existingModules.contains(entry2.getKey()) || (value2 = (Collection)entry2.getValue()) == null || value2.isEmpty()) continue;
            this.myState.substitutions.put((String)entry2.getKey(), new TreeSet(value2));
        }
    }

    public void addSubstitution(String ownerModuleName, String moduleName, String libraryName, DependencyScope scope2) {
        this.myNamesMap.put(moduleName, libraryName);
        this.mySubstitutions.putValue((Object)ownerModuleName, (Object)(moduleName + "_" + scope2.getDisplayName()));
    }

    public void removeSubstitution(String ownerModuleName, String moduleName, String libraryName, DependencyScope scope2) {
        this.mySubstitutions.remove((Object)ownerModuleName, (Object)(moduleName + "_" + scope2.getDisplayName()));
        Collection substitutions = this.mySubstitutions.values();
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!substitutions.contains(moduleName + "_" + dependencyScope.getDisplayName())) continue;
            return;
        }
        this.myNamesMap.remove(moduleName, libraryName);
    }

    public boolean isSubstitution(String moduleOwner, String substitutionModule, DependencyScope scope2) {
        return this.mySubstitutions.get((Object)moduleOwner).contains(substitutionModule + "_" + scope2.getDisplayName());
    }

    public boolean isSubstituted(String libraryName) {
        return this.myNamesMap.containsValue(libraryName);
    }

    public String getSubstitutedLibrary(String moduleName) {
        return this.myNamesMap.get(moduleName);
    }

    @Nullable
    public String findModule(@NotNull ProjectCoordinate id2) {
        if (id2 == null) {
            ModifiableWorkspace.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)id2.getArtifactId())) {
            return null;
        }
        String result2 = this.myModuleMappingById.get(id2);
        return result2 == null && id2.getVersion() != null ? this.myModuleMappingById.get(new ProjectId(id2.getGroupId(), id2.getArtifactId(), null)) : result2;
    }

    public void register(@NotNull ProjectCoordinate id2, @NotNull Module module) {
        if (id2 == null) {
            ModifiableWorkspace.$$$reportNull$$$0(1);
        }
        if (module == null) {
            ModifiableWorkspace.$$$reportNull$$$0(2);
        }
        this.myModuleMappingById.put(id2, module.getName());
        this.myModuleMappingById.put((ProjectCoordinate)new ProjectId(id2.getGroupId(), id2.getArtifactId(), null), module.getName());
    }

    private void register(@NotNull Module module) {
        if (module == null) {
            ModifiableWorkspace.$$$reportNull$$$0(3);
        }
        Arrays.stream((ExternalSystemWorkspaceContributor[])ExternalProjectsWorkspaceImpl.EP_NAME.getExtensions()).map(contributor -> contributor.findProjectId(module)).filter(Objects::nonNull).findFirst().ifPresent(id2 -> this.register((ProjectCoordinate)id2, module));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/ModifiableWorkspace";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findModule";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

