/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui.completion;

import com.intellij.openapi.externalSystem.service.ui.completion.AbstractTextCompletionContributor;
import com.intellij.openapi.externalSystem.service.ui.completion.JTextCompletionContributor$WhenMappings;
import com.intellij.openapi.externalSystem.service.ui.completion.TextCompletionInfo;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u0000 \u0018*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002\u0018\u0019B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00132\u0006\u0010\t\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completion/JTextCompletionContributor;", "C", "Ljavax/swing/text/JTextComponent;", "Lcom/intellij/openapi/externalSystem/service/ui/completion/AbstractTextCompletionContributor;", "completionType", "Lcom/intellij/openapi/externalSystem/service/ui/completion/JTextCompletionContributor$CompletionType;", "(Lcom/intellij/openapi/externalSystem/service/ui/completion/JTextCompletionContributor$CompletionType;)V", "getCaretPosition", "", "owner", "(Ljavax/swing/text/JTextComponent;)I", "getTextToComplete", "", "(Ljavax/swing/text/JTextComponent;)Ljava/lang/String;", "getWordRange", "Lkotlin/ranges/IntRange;", "offset", "(Ljavax/swing/text/JTextComponent;I)Lkotlin/ranges/IntRange;", "insert", "", "variant", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionInfo;", "(Ljavax/swing/text/JTextComponent;Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionInfo;)V", "replace", "Companion", "CompletionType", "intellij.platform.externalSystem.impl"})
@ApiStatus.Experimental
public abstract class JTextCompletionContributor<C extends JTextComponent>
extends AbstractTextCompletionContributor<C> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getTextToComplete(@NotNull C owner) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        int caretPosition = this.getCaretPosition(owner);
        IntRange wordRange = this.getWordRange(owner, caretPosition);
        IntRange textToCompleteRange = RangesKt.until((int)wordRange.getFirst(), (int)caretPosition);
        String string = ((JTextComponent)owner).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"owner.text");
        return StringsKt.substring((String)string, (IntRange)textToCompleteRange);
    }

    private final IntRange getWordRange(C owner, int offset) {
        int wordStartPosition = 0;
        String string = ((JTextComponent)owner).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"owner.text");
        for (String word : StringsKt.split$default((CharSequence)string, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null)) {
            int wordEndPosition;
            int n = offset;
            if (wordStartPosition <= n && (wordEndPosition = wordStartPosition + word.length()) >= n) {
                return RangesKt.until((int)wordStartPosition, (int)wordEndPosition);
            }
            wordStartPosition = wordEndPosition + 1;
        }
        throw (Throwable)new BadLocationException(((JTextComponent)owner).getText(), offset);
    }

    private final int getCaretPosition(C owner) {
        int n = 0;
        int n2 = ((JTextComponent)owner).getText().length();
        int n3 = ((JTextComponent)owner).getCaretPosition();
        boolean bl = false;
        n2 = Math.min(n2, n3);
        n3 = 0;
        return Math.max(n, n2);
    }

    private final void insert(C owner, TextCompletionInfo variant) {
        String textToComplete = this.getTextToComplete(owner);
        String textCompletionSuffix = StringsKt.removePrefix((String)variant.getText(), (CharSequence)textToComplete);
        int caretPosition = this.getCaretPosition(owner);
        ((JTextComponent)owner).getDocument().insertString(caretPosition, textCompletionSuffix, null);
    }

    private final void replace(C owner, TextCompletionInfo variant) {
        int caretPosition = this.getCaretPosition(owner);
        IntRange wordRange = this.getWordRange(owner, caretPosition);
        ((JTextComponent)owner).getDocument().remove(caretPosition, wordRange.getLast() - caretPosition + 1);
        IntRange textToCompleteRange = RangesKt.until((int)wordRange.getFirst(), (int)caretPosition);
        String string = ((JTextComponent)owner).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"owner.text");
        String textToComplete = StringsKt.substring((String)string, (IntRange)textToCompleteRange);
        String textCompletionSuffix = StringsKt.removePrefix((String)variant.getText(), (CharSequence)textToComplete);
        ((JTextComponent)owner).getDocument().insertString(caretPosition, textCompletionSuffix, null);
    }

    public JTextCompletionContributor(final @NotNull CompletionType completionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)completionType), (String)"completionType");
        this.whenVariantChosen((Function2)new Function2<C, TextCompletionInfo, Unit>(){

            public final void invoke(@NotNull C owner, @NotNull TextCompletionInfo variant) {
                Intrinsics.checkNotNullParameter(owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                switch (JTextCompletionContributor$WhenMappings.$EnumSwitchMapping$0[completionType.ordinal()]) {
                    case 1: {
                        this.insert(owner, variant);
                        break;
                    }
                    case 2: {
                        this.replace(owner, variant);
                        break;
                    }
                }
            }
        });
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completion/JTextCompletionContributor$CompletionType;", "", "(Ljava/lang/String;I)V", "INSERT", "REPLACE", "intellij.platform.externalSystem.impl"})
    public static final class CompletionType
    extends Enum<CompletionType> {
        public static final /* enum */ CompletionType INSERT;
        public static final /* enum */ CompletionType REPLACE;
        private static final /* synthetic */ CompletionType[] $VALUES;

        static {
            CompletionType[] completionTypeArray = new CompletionType[2];
            CompletionType[] completionTypeArray2 = completionTypeArray;
            completionTypeArray[0] = INSERT = new CompletionType();
            completionTypeArray[1] = REPLACE = new CompletionType();
            $VALUES = completionTypeArray;
        }

        public static CompletionType[] values() {
            return (CompletionType[])$VALUES.clone();
        }

        public static CompletionType valueOf(String string) {
            return Enum.valueOf(CompletionType.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completion/JTextCompletionContributor$Companion;", "", "()V", "create", "Lcom/intellij/openapi/externalSystem/service/ui/completion/JTextCompletionContributor;", "C", "Ljavax/swing/text/JTextComponent;", "completionType", "Lcom/intellij/openapi/externalSystem/service/ui/completion/JTextCompletionContributor$CompletionType;", "completionVariants", "Lkotlin/Function1;", "", "", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionInfo;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @NotNull
        public final <C extends JTextComponent> JTextCompletionContributor<C> create(@NotNull CompletionType completionType, @NotNull Function1<? super String, ? extends List<TextCompletionInfo>> completionVariants) {
            Intrinsics.checkNotNullParameter((Object)((Object)completionType), (String)"completionType");
            Intrinsics.checkNotNullParameter(completionVariants, (String)"completionVariants");
            return new JTextCompletionContributor<C>(completionVariants, completionType, completionType){
                final /* synthetic */ Function1 $completionVariants;
                final /* synthetic */ CompletionType $completionType;

                @NotNull
                public List<TextCompletionInfo> getCompletionVariants(@NotNull C owner, @NotNull String textToComplete) {
                    Intrinsics.checkNotNullParameter(owner, (String)"owner");
                    Intrinsics.checkNotNullParameter((Object)textToComplete, (String)"textToComplete");
                    return (List)this.$completionVariants.invoke((Object)textToComplete);
                }
                {
                    this.$completionVariants = $captured_local_variable$0;
                    this.$completionType = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            };
        }

        public static /* synthetic */ JTextCompletionContributor create$default(Companion companion, CompletionType completionType, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                completionType = CompletionType.INSERT;
            }
            return companion.create(completionType, (Function1<? super String, ? extends List<TextCompletionInfo>>)function1);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

