/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui.project.path;

import com.intellij.execution.ui.SettingsEditorFragmentType;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.wizard.UIWizardUtil;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.service.ui.project.path.ExternalProject;
import com.intellij.openapi.externalSystem.service.ui.project.path.WorkingDirectoryInfo;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\nR$\u0010\u001a\u001a\u00180\b\u00a2\u0006\u0002\b\u001b\u00a2\u0006\u000e\b\u001c\u0012\n\b\u001d\u0012\u0006\b\n0\u001e8\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\n\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/project/path/ExternalSystemWorkingDirectoryInfo;", "Lcom/intellij/openapi/externalSystem/service/ui/project/path/WorkingDirectoryInfo;", "project", "Lcom/intellij/openapi/project/Project;", "externalSystemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;)V", "editorLabel", "", "getEditorLabel", "()Ljava/lang/String;", "emptyFieldError", "getEmptyFieldError", "externalProjects", "", "Lcom/intellij/openapi/externalSystem/service/ui/project/path/ExternalProject;", "getExternalProjects", "()Ljava/util/List;", "externalProjects$delegate", "Lkotlin/Lazy;", "fileChooserDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "getFileChooserDescriptor", "()Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "fileChooserTitle", "getFileChooserTitle", "readableName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "settingsName", "getSettingsName", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemWorkingDirectoryInfo
implements WorkingDirectoryInfo {
    private final String readableName;
    @NotNull
    private final String editorLabel;
    @NotNull
    private final String settingsName;
    @NotNull
    private final String fileChooserTitle;
    @NotNull
    private final FileChooserDescriptor fileChooserDescriptor;
    @NotNull
    private final String emptyFieldError;
    @NotNull
    private final Lazy externalProjects$delegate;

    @Override
    @NotNull
    public String getEditorLabel() {
        return this.editorLabel;
    }

    @Override
    @NotNull
    public String getSettingsName() {
        return this.settingsName;
    }

    @Override
    @NotNull
    public String getFileChooserTitle() {
        return this.fileChooserTitle;
    }

    @Override
    @NotNull
    public FileChooserDescriptor getFileChooserDescriptor() {
        return this.fileChooserDescriptor;
    }

    @Override
    @NotNull
    public String getEmptyFieldError() {
        return this.emptyFieldError;
    }

    @Override
    @NotNull
    public List<ExternalProject> getExternalProjects() {
        Lazy lazy = this.externalProjects$delegate;
        ExternalSystemWorkingDirectoryInfo externalSystemWorkingDirectoryInfo = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    public ExternalSystemWorkingDirectoryInfo(@NotNull Project project, @NotNull ProjectSystemId externalSystemId2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalSystemId2, (String)"externalSystemId");
        String string = externalSystemId2.getReadableName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"externalSystemId.readableName");
        this.readableName = string;
        String string2 = ExternalSystemBundle.message((String)"run.configuration.project.path.label", (Object[])new Object[]{this.readableName});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ExternalSystemBundle.mes\u2026ath.label\", readableName)");
        this.editorLabel = string2;
        String string3 = ExternalSystemBundle.message((String)"run.configuration.project.path.name", (Object[])new Object[]{this.readableName});
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ExternalSystemBundle.mes\u2026path.name\", readableName)");
        this.settingsName = string3;
        String string4 = ExternalSystemBundle.message((String)"settings.label.select.project", (Object[])new Object[]{this.readableName});
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"ExternalSystemBundle.mes\u2026t.project\", readableName)");
        this.fileChooserTitle = string4;
        FileChooserDescriptor fileChooserDescriptor2 = ExternalSystemApiUtil.getExternalProjectConfigDescriptor((ProjectSystemId)externalSystemId2);
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor2, (String)"ExternalSystemApiUtil.ge\u2026criptor(externalSystemId)");
        this.fileChooserDescriptor = fileChooserDescriptor2;
        String string5 = ExternalSystemBundle.message((String)"run.configuration.project.path.empty.error", (Object[])new Object[]{this.readableName});
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"ExternalSystemBundle.mes\u2026pty.error\", readableName)");
        this.emptyFieldError = string5;
        this.externalProjects$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ArrayList<ExternalProject>>(project, externalSystemId2){
            final /* synthetic */ Project $project;
            final /* synthetic */ ProjectSystemId $externalSystemId;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ArrayList<ExternalProject> invoke() {
                ArrayList<ExternalProject> arrayList = new ArrayList<ExternalProject>();
                boolean bl = false;
                boolean bl2 = false;
                ArrayList<ExternalProject> $this$apply = arrayList;
                boolean bl3 = false;
                AbstractExternalSystemLocalSettings localSettings = ExternalSystemApiUtil.getLocalSettings((Project)this.$project, (ProjectSystemId)this.$externalSystemId);
                ExternalSystemUiAware externalSystemUiAware = ExternalSystemUiUtil.getUiAware(this.$externalSystemId);
                Intrinsics.checkNotNullExpressionValue((Object)externalSystemUiAware, (String)"ExternalSystemUiUtil.getUiAware(externalSystemId)");
                ExternalSystemUiAware uiAware = externalSystemUiAware;
                AbstractExternalSystemLocalSettings abstractExternalSystemLocalSettings = localSettings;
                Intrinsics.checkNotNullExpressionValue((Object)abstractExternalSystemLocalSettings, (String)"localSettings");
                Map map2 = abstractExternalSystemLocalSettings.getAvailableProjects();
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"localSettings.availableProjects");
                Map map3 = map2;
                boolean bl4 = false;
                Iterator<Map.Entry<K, V>> iterator2 = map3.entrySet().iterator();
                while (iterator2.hasNext()) {
                    String parentName;
                    void parent;
                    Map.Entry<K, V> entry2;
                    Map.Entry<K, V> entry3 = entry2 = iterator2.next();
                    boolean bl5 = false;
                    map3 = (ExternalProjectPojo)entry3.getKey();
                    entry3 = entry2;
                    bl5 = false;
                    Collection children2 = (Collection)entry3.getValue();
                    void v3 = parent;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"parent");
                    String string = v3.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parent.path");
                    String parentPath = UIWizardUtil.getCanonicalPath$default(string, false, 2, null);
                    Intrinsics.checkNotNullExpressionValue((Object)uiAware.getProjectRepresentationName(this.$project, parentPath, null), (String)"uiAware.getProjectRepres\u2026roject, parentPath, null)");
                    $this$apply.add(new ExternalProject(parentName, parentPath));
                    Iterator<E> iterator3 = children2.iterator();
                    while (iterator3.hasNext()) {
                        String childName;
                        ExternalProjectPojo child2;
                        ExternalProjectPojo externalProjectPojo = child2 = (ExternalProjectPojo)iterator3.next();
                        Intrinsics.checkNotNullExpressionValue((Object)externalProjectPojo, (String)"child");
                        String string2 = externalProjectPojo.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"child.path");
                        String childPath = UIWizardUtil.getCanonicalPath$default(string2, false, 2, null);
                        if (Intrinsics.areEqual((Object)parentPath, (Object)childPath)) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)uiAware.getProjectRepresentationName(this.$project, childPath, parentPath), (String)"uiAware.getProjectRepres\u2026t, childPath, parentPath)");
                        $this$apply.add(new ExternalProject(childName, childPath));
                    }
                }
                return arrayList;
            }
            {
                this.$project = project;
                this.$externalSystemId = projectSystemId;
                super(0);
            }
        }));
    }

    @Override
    @NotNull
    public String getSettingsId() {
        return WorkingDirectoryInfo.DefaultImpls.getSettingsId(this);
    }

    @Override
    @Nullable
    public String getSettingsGroup() {
        return WorkingDirectoryInfo.DefaultImpls.getSettingsGroup(this);
    }

    @Override
    public int getSettingsPriority() {
        return WorkingDirectoryInfo.DefaultImpls.getSettingsPriority(this);
    }

    @Override
    @Nullable
    public String getSettingsHint() {
        return WorkingDirectoryInfo.DefaultImpls.getSettingsHint(this);
    }

    @Override
    @Nullable
    public String getSettingsActionHint() {
        return WorkingDirectoryInfo.DefaultImpls.getSettingsActionHint(this);
    }

    @Override
    @Nullable
    public String getFileChooserDescription() {
        return WorkingDirectoryInfo.DefaultImpls.getFileChooserDescription(this);
    }

    @Override
    @NotNull
    public Function1<Macro, Boolean> getFileChooserMacroFilter() {
        return WorkingDirectoryInfo.DefaultImpls.getFileChooserMacroFilter(this);
    }

    @Override
    @NotNull
    public SettingsEditorFragmentType getSettingsType() {
        return WorkingDirectoryInfo.DefaultImpls.getSettingsType(this);
    }
}

